/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.copper.runtime.auxiliary.internal;

import java.util.BitSet;

public class PrettyPrinter {
    public static <E> String iterablePrettyPrint(Iterable<E> coll, String linePrefix, int itemsPerLine) {
        String rv = linePrefix + "[";
        boolean isFirst = true;
        int currentLineItemCount = -1;
        for (E obj : coll) {
            if (!isFirst) {
                rv = rv + ",";
            }
            if ((currentLineItemCount = (currentLineItemCount + 1) % itemsPerLine) == 0 && !isFirst) {
                rv = rv + "\n" + linePrefix + " ";
            }
            isFirst = false;
            rv = rv + obj.toString();
        }
        rv = rv + "]";
        return rv;
    }

    public static <E> int getOptimalItemsPerLine(Iterable<E> coll, int rightLimit) {
        int maxLength = 0;
        for (E obj : coll) {
            maxLength = Math.max(maxLength, obj.toString().length());
        }
        if (maxLength == 0 || maxLength >= rightLimit) {
            return 1;
        }
        return Math.max(1, rightLimit / maxLength);
    }

    public static String bitSetPrettyPrint(BitSet coll, String[] nameMap, String linePrefix, int itemsPerLine) {
        String rv = linePrefix + "[";
        boolean isFirst = true;
        int currentLineItemCount = -1;
        int i = coll.nextSetBit(0);
        while (i >= 0) {
            if (!isFirst) {
                rv = rv + ",";
            }
            if ((currentLineItemCount = (currentLineItemCount + 1) % itemsPerLine) == 0 && !isFirst) {
                rv = rv + "\n" + linePrefix + " ";
            }
            isFirst = false;
            rv = rv + nameMap[i];
            i = coll.nextSetBit(i + 1);
        }
        rv = rv + "]";
        return rv;
    }

    public static String charPrettyPrint(char toPrint) {
        if (Character.isISOControl(toPrint)) {
            return String.format("U+%x", Character.valueOf(toPrint));
        }
        return String.valueOf(toPrint);
    }
}

