/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.copper.compiletime.logging.messages;

import edu.umn.cs.melt.copper.compiletime.auxiliary.SymbolTable;
import edu.umn.cs.melt.copper.compiletime.logging.CompilerLevel;
import edu.umn.cs.melt.copper.compiletime.logging.CompilerLogMessage;
import edu.umn.cs.melt.copper.compiletime.lrdfa.LR0DFA;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.CopperASTBean;
import edu.umn.cs.melt.copper.compiletime.spec.numeric.PSSymbolTable;
import edu.umn.cs.melt.copper.compiletime.spec.numeric.ParserSpec;
import java.util.BitSet;

public class LookaheadSpillageMessage
implements CompilerLogMessage {
    private SymbolTable<CopperASTBean> symbolTable;
    private int state;
    private int item;
    private BitSet diff;
    private final boolean isMasked;

    public LookaheadSpillageMessage(SymbolTable<CopperASTBean> symbolTable, ParserSpec spec, LR0DFA dfa, int state, int item, BitSet diff, boolean isMasked) {
        this.symbolTable = symbolTable;
        this.state = state;
        this.item = item;
        this.diff = diff;
        this.isMasked = isMasked;
    }

    @Override
    public CompilerLevel getLevel() {
        return this.isMasked ? CompilerLevel.VERBOSE : CompilerLevel.QUIET;
    }

    @Override
    public int getType() {
        return 12;
    }

    @Override
    public boolean isError() {
        return true;
    }

    @Override
    public boolean isFatalError() {
        return false;
    }

    @Override
    public String toString() {
        return "DFA state " + this.state + ", item " + this.item + " has lookahead spillage of\n" + PSSymbolTable.bitSetPrettyPrint(this.diff, this.symbolTable, "   ", 80);
    }
}

