/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.copper.ant;

import edu.umn.cs.melt.copper.compiletime.logging.CompilerLevel;
import edu.umn.cs.melt.copper.main.CopperDumpControl;
import edu.umn.cs.melt.copper.main.CopperDumpType;
import edu.umn.cs.melt.copper.main.CopperEngineType;
import edu.umn.cs.melt.copper.main.CopperIOType;
import edu.umn.cs.melt.copper.main.CopperPipelineType;
import edu.umn.cs.melt.copper.main.CopperSkinType;
import edu.umn.cs.melt.copper.main.ParserCompiler;
import edu.umn.cs.melt.copper.main.ParserCompilerParameters;
import edu.umn.cs.melt.copper.runtime.auxiliary.Pair;
import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Hashtable;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public class CopperAntTask
extends Task {
    private Hashtable<String, Object> customSwitches;
    protected File dumpFile = null;
    protected CopperDumpType dumpFormat;
    protected CopperDumpControl dump;
    protected PrintStream dumpStream = null;
    private CopperIOType dumpOutputType = null;
    private ArrayList<Pair<String, Object>> inputs = new ArrayList();
    protected boolean isWarnUselessNTs = true;
    protected File logFile = null;
    protected PrintStream logStream = null;
    private CopperIOType logType = null;
    protected File outputFile = null;
    protected PrintStream outputStream = null;
    private CopperIOType outputType = null;
    protected String packageName = null;
    protected String parserName = null;
    protected CompilerLevel quietLevel;
    protected boolean runMDA = false;
    private CopperEngineType useEngine;
    private CopperPipelineType usePipeline;
    private CopperSkinType useSkin;
    private boolean avoidRecompile = false;
    private File dotOut = null;
    private boolean colorCounterexample = true;

    public void addConfiguredInputs(FileSet files) {
        DirectoryScanner ds = files.getDirectoryScanner(this.getProject());
        String[] includedFiles = ds.getIncludedFiles();
        for (int i = 0; i < includedFiles.length; ++i) {
            this.inputs.add(Pair.cons(includedFiles[i], new File(ds.getBasedir(), includedFiles[i])));
        }
    }

    public CopperAntTask() {
        this.dump = CopperDumpControl.OFF;
        this.dumpFormat = ParserCompiler.getDefaultDumpType();
        this.useEngine = ParserCompiler.getDefaultEngine();
        this.useSkin = ParserCompiler.getDefaultSkin();
        this.quietLevel = ParserCompiler.getDefaultQuietLevel();
        this.usePipeline = ParserCompiler.getDefaultPipeline();
        this.customSwitches = new Hashtable();
    }

    public void execute() throws BuildException {
        ParserCompilerParameters params = new ParserCompilerParameters();
        params.setInputs(this.inputs);
        params.setRunMDA(this.runMDA);
        params.setDump(this.dump);
        params.setDumpFormat(this.dumpFormat);
        params.setUseEngine(this.useEngine);
        params.setUseSkin(this.useSkin);
        params.setQuietLevel(this.quietLevel);
        params.setUsePipeline(this.usePipeline);
        params.setPackageName(this.packageName);
        params.setParserName(this.parserName);
        params.setOutputStream(this.outputStream);
        params.setOutputFile(this.outputFile);
        params.setOutputType(this.outputType);
        params.setLogStream(this.logStream);
        params.setLogFile(this.logFile);
        params.setLogType(this.logType);
        params.setDumpStream(this.dumpStream);
        params.setDumpFile(this.dumpFile);
        params.setDumpOutputType(this.dumpOutputType);
        params.setDotOutput(this.dotOut);
        params.setColorCounterexample(this.colorCounterexample);
        params.setAvoidRecompile(this.avoidRecompile);
        params.setWarnUselessNTs(this.isWarnUselessNTs);
        for (String string : this.customSwitches.keySet()) {
            params.setCustomSwitch(string, this.customSwitches.get(string));
        }
        System.out.println("============================================================\nCompiling " + this.inputs.size() + " input file" + (this.inputs.size() == 1 ? "" : "s") + ":");
        for (Pair pair : this.inputs) {
            System.out.println("\t" + (String)pair.first());
        }
        int errorlevel = 1;
        try {
            errorlevel = ParserCompiler.compile(params);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (errorlevel != 0) {
            throw new BuildException("Error " + errorlevel);
        }
    }

    public File getDumpFile() {
        return this.dumpFile;
    }

    public CopperDumpType getDumpFormat() {
        return this.dumpFormat;
    }

    public PrintStream getDumpStream() {
        return this.dumpStream;
    }

    public CopperIOType getDumpOutputType() {
        return this.dumpOutputType;
    }

    public File getLogFile() {
        return this.logFile;
    }

    public PrintStream getLogStream() {
        return this.logStream;
    }

    public CopperIOType getLogType() {
        return this.logType;
    }

    public File getOutputFile() {
        return this.outputFile;
    }

    public PrintStream getOutputStream() {
        return this.outputStream;
    }

    public CopperIOType getOutputType() {
        return this.outputType;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getParserName() {
        return this.parserName;
    }

    public CompilerLevel getQuietLevel() {
        return this.quietLevel;
    }

    public CopperEngineType getUseEngine() {
        return this.useEngine;
    }

    public CopperPipelineType getUsePipeline() {
        return this.usePipeline;
    }

    public CopperSkinType getUseSkin() {
        return this.useSkin;
    }

    public boolean hasCustomSwitch(String key) {
        return this.customSwitches.containsKey(key);
    }

    public boolean isRunMDA() {
        return this.runMDA;
    }

    public boolean isWarnUselessNTs() {
        return this.isWarnUselessNTs;
    }

    public File getDotOut() {
        return this.dotOut;
    }

    public void setDotOut(File dotOut) {
        this.dotOut = dotOut;
    }

    public boolean isColorCounterexample() {
        return this.colorCounterexample;
    }

    public void setColorCounterexample(boolean colorCounterexample) {
        this.colorCounterexample = colorCounterexample;
    }

    public void setDumpFile(File dumpFile) {
        if (this.dumpOutputType == null) {
            this.dumpOutputType = CopperIOType.FILE;
        }
        if (this.dump == null) {
            this.dump = CopperDumpControl.ON;
        }
        this.dumpFile = dumpFile;
    }

    public void setDumpFormat(CopperDumpType dumpFormat) {
        this.dumpFormat = dumpFormat;
    }

    public void setDumpStream(PrintStream dumpStream) {
        if (this.dumpOutputType == null) {
            this.dumpOutputType = CopperIOType.STREAM;
        }
        if (this.dump == null) {
            this.dump = CopperDumpControl.ON;
        }
        this.dumpStream = dumpStream;
    }

    public void setDumpOutputType(CopperIOType dumpOutputType) {
        this.dumpOutputType = dumpOutputType;
    }

    public void setLogFile(File logFile) {
        if (this.logType == null) {
            this.logType = CopperIOType.FILE;
        }
        this.logFile = logFile;
    }

    public void setLogStream(PrintStream logStream) {
        if (this.logType == null) {
            this.logType = CopperIOType.STREAM;
        }
        this.logStream = logStream;
    }

    public void setLogType(CopperIOType logType) {
        this.logType = logType;
    }

    public void setOutputFile(File outputFile) {
        if (this.outputType == null) {
            this.outputType = CopperIOType.FILE;
        }
        this.outputFile = outputFile;
    }

    public void setOutputStream(PrintStream outputStream) {
        if (this.outputType == null) {
            this.outputType = CopperIOType.STREAM;
        }
        this.outputStream = outputStream;
    }

    public void setOutputType(CopperIOType outputType) {
        this.outputType = outputType;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public void setParserName(String parserName) {
        this.parserName = parserName;
    }

    public void setQuietLevel(CompilerLevel quietLevel) {
        this.quietLevel = quietLevel;
    }

    public void setRunMDA(boolean isComposition) {
        this.runMDA = isComposition;
    }

    public void setUseEngine(CopperEngineType useEngine) {
        this.useEngine = useEngine;
    }

    public void setUsePipeline(CopperPipelineType usePipeline) {
        this.usePipeline = usePipeline;
    }

    public void setUseSkin(CopperSkinType useSkin) {
        this.useSkin = useSkin;
    }

    public void setWarnUselessNTs(boolean isWarnUselessNTs) {
        this.isWarnUselessNTs = isWarnUselessNTs;
    }

    public CopperDumpControl getDump() {
        return this.dump;
    }

    public void setDump(CopperDumpControl dump) {
        this.dump = dump;
    }

    public boolean isAvoidRecompile() {
        return this.avoidRecompile;
    }

    public void setAvoidRecompile(boolean avoidRecompile) {
        this.avoidRecompile = avoidRecompile;
    }
}

