/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.copper.legacy.compiletime.abstractsyntax.grammar;

import edu.umn.cs.melt.copper.legacy.compiletime.abstractsyntax.grammar.Terminal;
import edu.umn.cs.melt.copper.legacy.compiletime.logging.CompilerLogMessageSort;
import edu.umn.cs.melt.copper.legacy.compiletime.logging.CompilerLogger;
import edu.umn.cs.melt.copper.runtime.auxiliary.internal.PrettyPrinter;
import edu.umn.cs.melt.copper.runtime.logging.CopperException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Queue;
import java.util.Stack;

public class PrecedenceRelationGraph {
    private Hashtable<Terminal, Integer> vertices = new Hashtable();
    private boolean[][] adjacencyMatrix;
    private int[] inDegrees;

    public PrecedenceRelationGraph(Iterable<Terminal> vertices) {
        int i = 0;
        for (Terminal vertex : vertices) {
            this.vertices.put(vertex, i++);
        }
        this.adjacencyMatrix = new boolean[i][i];
        this.inDegrees = new int[i];
    }

    private int getVertexNumber(Terminal vertex) {
        if (!this.hasVertex(vertex)) {
            return -1;
        }
        return this.vertices.get(vertex);
    }

    public boolean hasVertex(Terminal vertex) {
        return this.vertices.containsKey(vertex);
    }

    public void removeVertex(Terminal vertex) {
        if (!this.hasVertex(vertex)) {
            return;
        }
        int vertexNum = this.getVertexNumber(vertex);
        this.inDegrees[vertexNum] = 0;
        for (int i = 0; i < this.adjacencyMatrix.length; ++i) {
            this.adjacencyMatrix[vertexNum][i] = false;
            if (this.adjacencyMatrix[i][vertexNum]) {
                int n = i;
                this.inDegrees[n] = this.inDegrees[n] - 1;
            }
            this.adjacencyMatrix[i][vertexNum] = false;
        }
    }

    public boolean hasEdge(Terminal bottom, Terminal top) {
        int bottomNumber;
        if (!this.hasVertex(top) || !this.hasVertex(bottom)) {
            return false;
        }
        int topNumber = this.getVertexNumber(top);
        return this.adjacencyMatrix[topNumber][bottomNumber = this.getVertexNumber(bottom)];
    }

    public void addEdge(Terminal bottom, Terminal top) {
        int bottomNumber;
        if (!this.hasVertex(top) || !this.hasVertex(bottom)) {
            return;
        }
        int topNumber = this.getVertexNumber(top);
        if (!this.adjacencyMatrix[topNumber][bottomNumber = this.getVertexNumber(bottom)]) {
            int n = bottomNumber;
            this.inDegrees[n] = this.inDegrees[n] + 1;
        }
        this.adjacencyMatrix[topNumber][bottomNumber] = true;
    }

    public int getInDegree(Terminal vertex) {
        if (!this.hasVertex(vertex)) {
            return 0;
        }
        return this.inDegrees[this.getVertexNumber(vertex)];
    }

    public boolean detect2VertexCycle() {
        for (Terminal t : this.vertices.keySet()) {
            for (Terminal u : this.vertices.keySet()) {
                if (t.equals(u) || !this.adjacencyMatrix[this.getVertexNumber(t)][this.getVertexNumber(u)] || !this.adjacencyMatrix[this.getVertexNumber(u)][this.getVertexNumber(t)]) continue;
                return true;
            }
        }
        return false;
    }

    public void detectCycles(CompilerLogger logger, String location, Queue<Terminal> topologicallySortedVertices) throws CopperException {
        int[] colors = new int[this.adjacencyMatrix.length];
        for (Terminal u : this.vertices.keySet()) {
            colors[this.getVertexNumber((Terminal)u)] = 0;
        }
        for (Terminal u : this.vertices.keySet()) {
            if (colors[this.getVertexNumber(u)] != 0) continue;
            this.detectCyclesVisit(u, new Stack<Terminal>(), colors, logger, location, topologicallySortedVertices);
        }
    }

    private void detectCyclesVisit(Terminal u, Stack<Terminal> stackU, int[] colors, CompilerLogger logger, String location, Queue<Terminal> topologicallySortedVertices) throws CopperException {
        stackU.push(u);
        colors[this.getVertexNumber((Terminal)u)] = 1;
        for (Terminal v : this.vertices.keySet()) {
            if (!this.hasEdge(u, v)) continue;
            if (colors[this.getVertexNumber(v)] == 0) {
                this.detectCyclesVisit(v, stackU, colors, logger, location, topologicallySortedVertices);
                continue;
            }
            if (colors[this.getVertexNumber(v)] != 1 || !logger.isLoggable(CompilerLogMessageSort.ERROR)) continue;
            ArrayList<String> cycleMembers = new ArrayList<String>();
            int startIndex = stackU.lastIndexOf(v);
            if (startIndex != -1) {
                for (int i = startIndex; i < stackU.size(); ++i) {
                    cycleMembers.add(((Terminal)stackU.get(i)).toString());
                }
            }
            logger.logErrorMessage(CompilerLogMessageSort.ERROR, null, "In " + location + ":\nCyclic precedence relation involving terminals\n" + PrettyPrinter.iterablePrettyPrint(cycleMembers, "  ", 1) + " on graph\n" + this);
        }
        colors[this.getVertexNumber((Terminal)u)] = 2;
        if (topologicallySortedVertices != null) {
            topologicallySortedVertices.offer(u);
        }
        stackU.pop();
    }

    public PrecedenceRelationGraph makeCut(Iterable<Terminal> vertices) {
        PrecedenceRelationGraph rv = new PrecedenceRelationGraph(vertices);
        int[] vertexNumbers = new int[rv.vertices.size()];
        for (Terminal t : vertices) {
            vertexNumbers[rv.getVertexNumber((Terminal)t)] = this.getVertexNumber(t);
        }
        for (int i = 0; i < vertexNumbers.length; ++i) {
            for (int j = 0; j < vertexNumbers.length; ++j) {
                rv.adjacencyMatrix[i][j] = this.adjacencyMatrix[vertexNumbers[i]][vertexNumbers[j]];
                if (!rv.adjacencyMatrix[i][j]) continue;
                int n = j;
                rv.inDegrees[n] = rv.inDegrees[n] + 1;
            }
        }
        return rv;
    }

    public HashSet<Terminal> partitionAcceptSet(CompilerLogger logger, String location) throws CopperException {
        this.detectCycles(logger, location, null);
        HashSet<Terminal> rej = new HashSet<Terminal>();
        HashSet<Terminal> sources = new HashSet<Terminal>();
        HashSet<Terminal> culled = new HashSet<Terminal>();
        for (Terminal t : this.vertices.keySet()) {
            if (this.getInDegree(t) != 0) continue;
            sources.add(t);
        }
        while (!sources.isEmpty()) {
            HashSet<Terminal> newSources = new HashSet<Terminal>();
            culled.clear();
            for (Terminal t : sources) {
                for (Terminal u : this.vertices.keySet()) {
                    if (!this.hasEdge(u, t)) continue;
                    culled.add(u);
                }
            }
            rej.addAll(culled);
            for (Terminal c : culled) {
                for (Terminal d : this.vertices.keySet()) {
                    if (!this.hasEdge(d, c)) continue;
                    newSources.add(d);
                }
                this.removeVertex(c);
            }
            Iterator it = newSources.iterator();
            while (it.hasNext()) {
                Terminal t;
                t = (Terminal)it.next();
                if (this.getInDegree(t) == 0) continue;
                it.remove();
            }
            sources = newSources;
        }
        return rej;
    }

    public HashSet<Terminal> getClosure(HashSet<Terminal> seed) {
        HashSet<Terminal> rv = new HashSet<Terminal>(seed);
        for (Terminal t : seed) {
            for (Terminal u : this.vertices.keySet()) {
                if (!this.hasEdge(t, u)) continue;
                rv.add(u);
            }
        }
        return rv;
    }

    public String toString() {
        int i;
        String rv = "";
        ArrayList<String> vertexStrings = new ArrayList<String>(this.vertices.keySet().size());
        for (int i2 = 0; i2 < this.vertices.keySet().size(); ++i2) {
            vertexStrings.add(i2, null);
        }
        for (Terminal t : this.vertices.keySet()) {
            vertexStrings.set(this.vertices.get(t), t.toString());
        }
        for (i = 0; i < this.vertices.keySet().size(); ++i) {
            vertexStrings.set(i, i + ": " + (String)vertexStrings.get(i));
        }
        rv = rv + "Vertices: [\n" + PrettyPrinter.iterablePrettyPrint(vertexStrings, "  ", 1) + "];\nAdjacency matrix\n(read as column < row): \n";
        for (i = 0; i < this.adjacencyMatrix.length; ++i) {
            rv = rv + "   ";
            for (int j = 0; j < this.adjacencyMatrix.length; ++j) {
                rv = this.adjacencyMatrix[i][j] ? rv + "1 " : rv + "0 ";
            }
            rv = rv + "\n";
        }
        return rv;
    }
}

