/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.copper.compiletime.builders;

import edu.umn.cs.melt.copper.compiletime.lrdfa.TransparentPrefixes;
import edu.umn.cs.melt.copper.compiletime.parsetable.LRParseTable;
import edu.umn.cs.melt.copper.compiletime.spec.numeric.ParserSpec;

public class TransparentPrefixSetBuilder {
    private ParserSpec spec;
    private LRParseTable parseTable;

    private TransparentPrefixSetBuilder(ParserSpec spec, LRParseTable parseTable) {
        this.spec = spec;
        this.parseTable = parseTable;
    }

    public static TransparentPrefixes build(ParserSpec spec, LRParseTable parseTable) {
        return new TransparentPrefixSetBuilder(spec, parseTable).buildPrefixSets();
    }

    private TransparentPrefixes buildPrefixSets() {
        TransparentPrefixes prefixes = new TransparentPrefixes(this.spec, this.parseTable);
        for (int state = 0; state < this.parseTable.size(); ++state) {
            int t = this.parseTable.getValidLA(state).nextSetBit(0);
            while (t >= 0) {
                int prefix;
                if (this.spec.terminals.get(t) && t != this.spec.getEOFTerminal() && (prefix = this.spec.t.getTransparentPrefix(t)) != -1) {
                    prefixes.getPrefixes(state).set(prefix);
                    prefixes.initializePrefixMap(state, prefix);
                    prefixes.getFollowingTerminals(state, prefix).set(t);
                }
                t = this.parseTable.getValidLA(state).nextSetBit(t + 1);
            }
        }
        return prefixes;
    }
}

