/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.copper.legacy.compiletime.logging;

import edu.umn.cs.melt.copper.legacy.compiletime.logging.CompilerLogHandler;
import edu.umn.cs.melt.copper.legacy.compiletime.logging.CompilerLogMessage;
import edu.umn.cs.melt.copper.legacy.compiletime.logging.CompilerLogMessageSort;
import edu.umn.cs.melt.copper.legacy.compiletime.logging.CompilerLogger;
import edu.umn.cs.melt.copper.legacy.compiletime.logging.FatalCompileErrorException;
import edu.umn.cs.melt.copper.runtime.auxiliary.internal.PrettyPrinter;
import edu.umn.cs.melt.copper.runtime.logging.CopperException;
import java.io.PrintStream;
import java.util.Queue;
import java.util.TreeSet;
import java.util.logging.Logger;

public class StringBasedCompilerLogger
extends CompilerLogger {
    public StringBasedCompilerLogger() {
        this.logger = Logger.getLogger("edu.umn.cs.melt.copper.StringBasedCompilerLogger");
        if (this.logger.getParent().getHandlers().length > 0) {
            this.logger.getParent().removeHandler(this.logger.getParent().getHandlers()[0]);
        }
        this.handler = new CompilerLogHandler();
        this.logger.addHandler(this.handler);
    }

    @Override
    public void flushTicks() {
        Queue<CompilerLogMessage> ticks = this.handler.flushTickQueue();
        for (CompilerLogMessage msg : ticks) {
            this.printMessage(msg);
        }
    }

    @Override
    public void flushMessages() throws CopperException {
        Queue<CompilerLogMessage> messages = this.handler.flushMessageQueue();
        CompilerLogMessage throwExceptionForMsg = null;
        long requiresFailure = -1L;
        for (CompilerLogMessage msg : messages) {
            if (!msg.isRequiresImmediateFailure()) continue;
            throwExceptionForMsg = msg;
        }
        for (CompilerLogMessage msg : messages) {
            this.printMessage(msg);
            if (!msg.sort.isErrorLevel()) continue;
            requiresFailure = msg.sequenceNumber;
        }
        if (throwExceptionForMsg != null) {
            this.throwException(throwExceptionForMsg);
        } else if (requiresFailure != -1L) {
            this.throwException(new CompilerLogMessage(requiresFailure + 1L, System.currentTimeMillis(), "Errors raised in compilation", new Object[]{CompilerLogMessageSort.ERROR, null, true}));
        }
    }

    public void throwException(CompilerLogMessage msg) throws CopperException {
        switch (msg.sort) {
            case FATAL_ERROR: {
                throw new FatalCompileErrorException(msg.getMessage());
            }
        }
        throw new CopperException(msg.getMessage());
    }

    public void printMessage(CompilerLogMessage msg) {
        String location;
        PrintStream out = this.out;
        switch (msg.sort) {
            case DEBUG: {
                if (msg.getLocation() == null && msg.getVirtualLocation() == null) {
                    location = "Global debug info:\n  ";
                    break;
                }
                if (msg.getLocation() == null) {
                    location = "Debug info at " + this.virtualLocMessagetoString(msg) + ":\n  ";
                    break;
                }
                location = "Debug info at " + msg.getLocation() + ":\n  ";
                break;
            }
            case TAGGED_STATUS: {
                if (msg.getLocation() == null && msg.getVirtualLocation() == null) {
                    location = "Global:\n  ";
                    break;
                }
                if (msg.getLocation() == null) {
                    location = "At " + this.virtualLocMessagetoString(msg) + ":\n  ";
                    break;
                }
                location = "At " + msg.getLocation() + ":\n  ";
                break;
            }
            case WARNING: {
                if (msg.getLocation() == null && msg.getVirtualLocation() == null) {
                    location = "Global warning:\n  ";
                    break;
                }
                if (msg.getLocation() == null) {
                    location = "Warning at " + this.virtualLocMessagetoString(msg) + ":\n  ";
                    break;
                }
                location = "Warning at " + msg.getLocation() + ":\n  ";
                break;
            }
            case LEXICAL_CONFLICT: {
                location = "Lexical ambiguity at " + this.ambiguityLocToString(msg);
                break;
            }
            case PARSE_TABLE_CONFLICT: {
                location = "Parse table conflict at " + this.tableCelltoString(msg) + ":\n  ";
                break;
            }
            case UNRESOLVED_LEXICAL_CONFLICT: {
                location = "Unresolvable lexical ambiguity at " + this.unresolvableAmbiguityLocToString(msg);
                break;
            }
            case UNRESOLVED_CONFLICT: {
                location = "Unresolvable parse table conflict at " + this.tableCelltoString(msg) + ":\n  ";
                break;
            }
            case ERROR: 
            case PARSING_ERROR: {
                if (msg.getLocation() == null && msg.getVirtualLocation() == null) {
                    location = "Global error:\n  ";
                    break;
                }
                if (msg.getLocation() == null) {
                    location = "Error at " + this.virtualLocMessagetoString(msg) + ":\n  ";
                    break;
                }
                location = "Error at " + msg.getLocation() + ":\n  ";
                break;
            }
            case FATAL_ERROR: {
                if (msg.getLocation() == null && msg.getVirtualLocation() == null) {
                    location = "Global fatal error:\n  ";
                    break;
                }
                if (msg.getLocation() == null) {
                    location = "Fatal error at " + this.virtualLocMessagetoString(msg) + ":\n  ";
                    break;
                }
                location = "Fatal error at " + msg.getLocation() + ":\n  ";
                break;
            }
            default: {
                location = "";
            }
        }
        if (!location.equals("")) {
            location = "\n" + location;
        }
        out.print(location + msg.getMessage() + (location.equals("") ? "" : "\n"));
    }

    private String ambiguityLocToString(CompilerLogMessage msg) {
        if (msg.getParameters().length < 4 || !(msg.getParameters()[1] instanceof TreeSet)) {
            return "<malformed>";
        }
        String location = "";
        int size = ((TreeSet)msg.getParameters()[1]).size();
        location = size + " scanner state" + (size == 1 ? "" : "s");
        return location;
    }

    private String unresolvableAmbiguityLocToString(CompilerLogMessage msg) {
        String placeHash = PrettyPrinter.iterablePrettyPrint((TreeSet)msg.getParameters()[1], "   ", 14);
        if (msg.getParameters().length < 4 || !(msg.getParameters()[1] instanceof TreeSet)) {
            return "<malformed>";
        }
        String location = "";
        int size = ((TreeSet)msg.getParameters()[1]).size();
        location = "parser state" + (size == 1 ? "" : "s") + "\n" + placeHash;
        return location;
    }

    private String tableCelltoString(CompilerLogMessage msg) {
        if (msg.getParameters().length < 4 || !(msg.getParameters()[1] instanceof Integer) || !(msg.getParameters()[3] instanceof String)) {
            return "<malformed>";
        }
        String location = "";
        location = location + "parser state " + msg.getParameters()[1] + ", on terminal " + msg.getParameters()[3];
        return location;
    }

    private String virtualLocMessagetoString(CompilerLogMessage msg) {
        if (msg.getParameters().length < 5 || !(msg.getParameters()[3] instanceof Integer) || !(msg.getParameters()[4] instanceof Long)) {
            return "<malformed>";
        }
        String location = "";
        location = location + "line " + msg.getVirtualLocation().getLine() + ", column " + msg.getVirtualLocation().getColumn();
        if (msg.getVirtualLocation().getFileName().length() > 40) {
            location = location + "\n         ";
        }
        location = location + " in file " + msg.getVirtualLocation().getFileName();
        location = location + "\n         (parser state: " + (Integer)msg.getParameters()[3] + "; real character index: " + (Long)msg.getParameters()[4] + ")";
        return location;
    }
}

