/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.copper.legacy.compiletime.logging;

import edu.umn.cs.melt.copper.legacy.compiletime.abstractsyntax.grammar.GrammarName;
import edu.umn.cs.melt.copper.legacy.compiletime.abstractsyntax.grammar.GrammarSource;
import edu.umn.cs.melt.copper.legacy.compiletime.abstractsyntax.grammar.GrammarSymbol;
import edu.umn.cs.melt.copper.legacy.compiletime.abstractsyntax.grammar.LexicalDisambiguationGroup;
import edu.umn.cs.melt.copper.legacy.compiletime.abstractsyntax.grammar.NonTerminal;
import edu.umn.cs.melt.copper.legacy.compiletime.abstractsyntax.grammar.Production;
import edu.umn.cs.melt.copper.legacy.compiletime.abstractsyntax.grammar.Terminal;
import edu.umn.cs.melt.copper.legacy.compiletime.finiteautomaton.lalrengine.lalr1.LALR1DFA;
import edu.umn.cs.melt.copper.legacy.compiletime.finiteautomaton.lalrengine.lalr1.LALR1State;
import edu.umn.cs.melt.copper.legacy.compiletime.finiteautomaton.lalrengine.lalr1.LALR1StateItem;
import edu.umn.cs.melt.copper.legacy.compiletime.finiteautomaton.lalrengine.lalr1.LALR1Transition;
import edu.umn.cs.melt.copper.legacy.compiletime.logging.FatalCompileErrorException;
import edu.umn.cs.melt.copper.legacy.compiletime.logging.GrammarDumper;
import edu.umn.cs.melt.copper.legacy.compiletime.parsetable.AcceptAction;
import edu.umn.cs.melt.copper.legacy.compiletime.parsetable.FullReduceAction;
import edu.umn.cs.melt.copper.legacy.compiletime.parsetable.ParseAction;
import edu.umn.cs.melt.copper.legacy.compiletime.parsetable.ParseActionVisitor;
import edu.umn.cs.melt.copper.legacy.compiletime.parsetable.ReadOnlyParseTable;
import edu.umn.cs.melt.copper.legacy.compiletime.parsetable.ShiftAction;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XMLGrammarDumper
extends GrammarDumper
implements ParseActionVisitor<String, RuntimeException> {
    private Document document;
    private Element dumpTop;
    private Element currentCell;
    private PrintStream finalOutputStream;
    private GrammarSource grammar;
    private LALR1DFA dfa;
    private ReadOnlyParseTable parseTable;
    private Hashtable<Object, Integer> numbering;

    public XMLGrammarDumper(PrintStream finalOutputStream, GrammarSource grammar, LALR1DFA dfa, ReadOnlyParseTable parseTable) throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        this.document = builder.newDocument();
        this.dumpTop = (Element)this.document.appendChild(this.document.createElement("copper_spec"));
        this.finalOutputStream = finalOutputStream;
        this.grammar = grammar;
        this.dfa = dfa;
        this.parseTable = parseTable;
        this.numbering = new Hashtable();
    }

    @Override
    public void logXML() {
        TransformerFactory tFactory = TransformerFactory.newInstance();
        Transformer transformer = null;
        try {
            transformer = tFactory.newTransformer();
        }
        catch (TransformerConfigurationException e) {
            throw new FatalCompileErrorException(e);
        }
        DOMSource source = new DOMSource(this.document);
        StreamResult result = new StreamResult(new PrintWriter(this.finalOutputStream));
        try {
            transformer.transform(source, result);
        }
        catch (TransformerException e) {
            throw new FatalCompileErrorException(e);
        }
    }

    @Override
    public void logHTML() {
        StreamSource xslt = new StreamSource(new InputStreamReader(this.getClass().getClassLoader().getResourceAsStream("resources/edu/umn/cs/melt/copper/legacy/dumpformat.xslt")));
        this.logHTML(xslt);
    }

    public void logHTML(StreamSource xslt) {
        DOMSource xml = new DOMSource(this.document);
        TransformerFactory fact = TransformerFactory.newInstance();
        Transformer tr = null;
        try {
            tr = fact.newTransformer(xslt);
        }
        catch (TransformerException ex) {
            throw new FatalCompileErrorException(ex.getMessage());
        }
        StringWriter wr = new StringWriter();
        StreamResult output = new StreamResult(wr);
        try {
            tr.transform(xml, output);
        }
        catch (TransformerException ex) {
            throw new FatalCompileErrorException(ex.getMessage());
        }
        this.finalOutputStream.print(wr.toString());
    }

    @Override
    public void dumpPreamble() {
        int i = 0;
        for (GrammarName gn : this.grammar.getContainedGrammars()) {
            Element grammarElement = (Element)this.dumpTop.appendChild(this.document.createElement("grammar"));
            grammarElement.setAttribute("tag", "g" + i);
            grammarElement.setAttribute("id", gn.toString());
            if (this.grammar.hasDisplayName(gn.getName())) {
                Element displayNameElement = (Element)grammarElement.appendChild(this.document.createElement("displayname"));
                displayNameElement.setTextContent(this.grammar.getDisplayName(gn.getName()));
            }
            this.numbering.put(gn, i++);
        }
    }

    @Override
    public void dumpDisambigGroups() {
        int i = 0;
        for (LexicalDisambiguationGroup group : this.grammar.getDisambiguationGroups()) {
            Element dgNode = (Element)this.dumpTop.appendChild(this.document.createElement("disambig_group"));
            dgNode.setAttribute("tag", "dg" + i);
            dgNode.setAttribute("id", group.getName().toString());
            for (Terminal t : group.getMembers()) {
                Element memberNode = (Element)dgNode.appendChild(this.document.createElement("member"));
                memberNode.setTextContent("t" + this.numbering.get(t));
            }
            this.numbering.put(group, i++);
        }
    }

    @Override
    public void dumpLALR1DFA() {
        Element lalrDFANode = (Element)this.dumpTop.appendChild(this.document.createElement("lalr_dfa"));
        for (int statenum = 0; statenum <= this.parseTable.getLastState(); ++statenum) {
            LALR1State state = this.dfa.getState(statenum);
            Element stateNode = (Element)lalrDFANode.appendChild(this.document.createElement("state"));
            stateNode.setAttribute("id", String.valueOf(statenum));
            stateNode.setAttribute("tag", "ds" + statenum);
            for (LALR1StateItem item : state.getItems()) {
                Element itemNode = (Element)stateNode.appendChild(this.document.createElement("item"));
                itemNode.setAttribute("production", "p" + this.numbering.get(item.getProd()));
                itemNode.setAttribute("marker", String.valueOf(item.getPosition()));
                for (Terminal lookahead : this.dfa.getLookahead(state, item)) {
                    Element lookaheadNode = (Element)itemNode.appendChild(this.document.createElement("lookahead"));
                    lookaheadNode.setTextContent("t" + this.numbering.get(lookahead));
                }
            }
            for (LALR1Transition transition : this.dfa.getTransitions(state)) {
                Element transitionNode = (Element)stateNode.appendChild(this.document.createElement("transition"));
                GrammarSymbol label = transition.getLabel();
                if (label instanceof Terminal) {
                    transitionNode.setAttribute("label", "t" + this.numbering.get(label));
                } else {
                    transitionNode.setAttribute("label", "nt" + this.numbering.get(label));
                }
                transitionNode.setAttribute("dest", "ds" + this.dfa.getLabel(transition.getDest()));
            }
        }
    }

    @Override
    public void dumpNonTerminals() {
        int i = 0;
        for (NonTerminal nt : this.grammar.getNT()) {
            Element ntElement = (Element)this.dumpTop.appendChild(this.document.createElement("nonterminal"));
            ntElement.setAttribute("tag", "nt" + i);
            ntElement.setAttribute("id", nt.toString());
            if (this.grammar.getOwner(nt) != null && this.numbering.containsKey(this.grammar.getOwner(nt))) {
                ntElement.setAttribute("owner", "g" + this.numbering.get(this.grammar.getOwner(nt)));
            }
            if (this.grammar.hasDisplayName(nt.getId())) {
                Element displayNameElement = (Element)ntElement.appendChild(this.document.createElement("displayname"));
                displayNameElement.setTextContent(this.grammar.getDisplayName(nt.getId()));
            }
            this.numbering.put(nt, i++);
        }
    }

    @Override
    public void dumpParseTable() {
        Element parseTableElement = (Element)this.dumpTop.appendChild(this.document.createElement("parsetable"));
        for (int statenum = 0; statenum <= this.parseTable.getLastState(); ++statenum) {
            Element stateElement = (Element)parseTableElement.appendChild(this.document.createElement("state"));
            stateElement.setAttribute("tag", "tr" + statenum);
            stateElement.setAttribute("id", String.valueOf(statenum));
            if (this.parseTable.hasShiftable(statenum)) {
                Element followElement;
                if (this.parseTable.hasLayout(statenum)) {
                    for (Terminal terminal : this.parseTable.getLayout(statenum)) {
                        Element layoutElement = (Element)stateElement.appendChild(this.document.createElement("layout"));
                        layoutElement.setAttribute("tag", "t" + this.numbering.get(terminal));
                        for (Terminal t : this.parseTable.getShiftableFollowingLayout(statenum, terminal)) {
                            followElement = (Element)layoutElement.appendChild(this.document.createElement("follow"));
                            followElement.setTextContent("t" + this.numbering.get(t));
                        }
                    }
                }
                if (this.parseTable.hasPrefixes(statenum)) {
                    for (Terminal terminal : this.parseTable.getPrefixes(statenum)) {
                        Element prefixElement = (Element)stateElement.appendChild(this.document.createElement("prefix"));
                        prefixElement.setAttribute("tag", "t" + this.numbering.get(terminal));
                        for (Terminal t : this.parseTable.getShiftableFollowingPrefix(statenum, terminal)) {
                            followElement = (Element)prefixElement.appendChild(this.document.createElement("follow"));
                            followElement.setTextContent("t" + this.numbering.get(t));
                        }
                    }
                }
                for (Terminal terminal : this.parseTable.getShiftable(statenum)) {
                    this.currentCell = (Element)stateElement.appendChild(this.document.createElement("parse_cell"));
                    this.currentCell.setAttribute("id", "t" + this.numbering.get(terminal));
                    for (ParseAction action : this.parseTable.getParseActions(statenum, terminal)) {
                        action.acceptVisitor(this);
                    }
                }
            }
            if (!this.parseTable.hasGotoable(statenum)) continue;
            for (NonTerminal nonTerminal : this.parseTable.getGotoable(statenum)) {
                ShiftAction action = this.parseTable.getGotoAction(statenum, nonTerminal);
                Element cellElement = (Element)stateElement.appendChild(this.document.createElement("goto_cell"));
                cellElement.setAttribute("id", "nt" + this.numbering.get(nonTerminal));
                Element gotoElement = (Element)cellElement.appendChild(this.document.createElement("goto"));
                gotoElement.setAttribute("dest", "tr" + action.getDestState());
            }
        }
    }

    @Override
    public void dumpPrecedenceGraph() {
        Element precGraphElement = (Element)this.dumpTop.appendChild(this.document.createElement("precgraph"));
        for (Terminal t : this.grammar.getT()) {
            if (!this.grammar.getPrecedenceRelationsGraph().hasVertex(t)) continue;
            Element vertexElement = (Element)precGraphElement.appendChild(this.document.createElement("vertex"));
            vertexElement.setAttribute("tag", "t" + this.numbering.get(t));
            for (Terminal u : this.grammar.getT()) {
                if (!this.grammar.getPrecedenceRelationsGraph().hasVertex(u) || !this.grammar.getPrecedenceRelationsGraph().hasEdge(t, u)) continue;
                Element edgeElement = (Element)precGraphElement.appendChild(this.document.createElement("edge"));
                edgeElement.setAttribute("submits", "t" + this.numbering.get(t));
                edgeElement.setAttribute("dominates", "t" + this.numbering.get(u));
            }
        }
    }

    @Override
    public void dumpProductions() {
        int i = 0;
        for (NonTerminal nt : this.grammar.getNT()) {
            if (!this.grammar.pContains(nt)) continue;
            for (Production p : this.grammar.getP(nt)) {
                Element productionElement = (Element)this.dumpTop.appendChild(this.document.createElement("production"));
                productionElement.setAttribute("tag", "p" + i);
                productionElement.setAttribute("id", p.toString());
                if (this.grammar.getOwner(p) != null && this.numbering.containsKey(this.grammar.getOwner(p))) {
                    productionElement.setAttribute("owner", "g" + this.numbering.get(this.grammar.getOwner(p)));
                }
                productionElement.setAttribute("name", p.getName().toString());
                if (this.grammar.hasDisplayName(p.getName())) {
                    Element displayNameElement = (Element)productionElement.appendChild(this.document.createElement("displayname"));
                    displayNameElement.setTextContent(this.grammar.getDisplayName(nt.getId()));
                }
                Element lhsElement = (Element)productionElement.appendChild(this.document.createElement("lhs"));
                lhsElement.setTextContent("nt" + this.numbering.get(p.getLeft()));
                for (GrammarSymbol s : p.getRight()) {
                    Element rhsElement = (Element)productionElement.appendChild(this.document.createElement("rhssym"));
                    if (s instanceof Terminal) {
                        rhsElement.setTextContent("t" + this.numbering.get(s));
                        continue;
                    }
                    if (!(s instanceof NonTerminal)) continue;
                    rhsElement.setTextContent("nt" + this.numbering.get(s));
                }
                this.numbering.put(p, i++);
            }
        }
    }

    @Override
    public void dumpTerminals() {
        int i = 0;
        for (Terminal t : this.grammar.getT()) {
            Element terminalElement = (Element)this.dumpTop.appendChild(this.document.createElement("terminal"));
            terminalElement.setAttribute("tag", "t" + i);
            terminalElement.setAttribute("id", t.toString());
            if (this.grammar.getOwner(t) != null && this.numbering.containsKey(this.grammar.getOwner(t))) {
                terminalElement.setAttribute("owner", "g" + this.numbering.get(this.grammar.getOwner(t)));
            }
            if (this.grammar.hasDisplayName(t.getId())) {
                Element displayNameElement = (Element)terminalElement.appendChild(this.document.createElement("displayname"));
                displayNameElement.setTextContent(this.grammar.getDisplayName(t.getId()));
            }
            this.numbering.put(t, i++);
        }
    }

    @Override
    public void dumpPostamble() {
    }

    @Override
    public String visitAcceptAction(AcceptAction action) throws RuntimeException {
        this.currentCell.appendChild(this.document.createElement("accept"));
        return null;
    }

    @Override
    public String visitFullReduceAction(FullReduceAction action) throws RuntimeException {
        Element reduceElement = (Element)this.currentCell.appendChild(this.document.createElement("reduce"));
        reduceElement.setAttribute("prod", "p" + this.numbering.get(action.getProd()));
        return null;
    }

    @Override
    public String visitShiftAction(ShiftAction action) throws RuntimeException {
        Element shiftElement = (Element)this.currentCell.appendChild(this.document.createElement("shift"));
        shiftElement.setAttribute("dest", "tr" + action.getDestState());
        return null;
    }
}

