/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.copper.legacy.runtime.engines.split;

import edu.umn.cs.melt.copper.runtime.auxiliary.internal.PrettyPrinter;
import edu.umn.cs.melt.copper.runtime.engines.CopperParser;
import edu.umn.cs.melt.copper.runtime.engines.semantics.VirtualLocation;
import edu.umn.cs.melt.copper.runtime.engines.single.SingleDFAParseStackNode;
import edu.umn.cs.melt.copper.runtime.engines.single.scanner.SingleDFAMatchData;
import edu.umn.cs.melt.copper.runtime.io.InputPosition;
import edu.umn.cs.melt.copper.runtime.io.ScannerBuffer;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.BitSet;
import java.util.LinkedList;
import java.util.Stack;

public abstract class SplitEngine<ROOT, EXCEPT extends Exception>
implements CopperParser<ROOT, EXCEPT> {
    public static final int STATE_ERROR = 0;
    public static final int STATE_SHIFT = 1;
    public static final int STATE_GOTO = 1;
    public static final int STATE_REDUCE = 2;
    public static final int STATE_ACCEPT = 3;
    public static final int SYMBOL_TERMINAL = 0;
    public static final int SYMBOL_NONTERM = 1;
    public static final int SYMBOL_PRODUCTION = 2;
    protected static int TERMINAL_COUNT;
    protected static int GRAMMAR_SYMBOL_COUNT;
    protected static int SYMBOL_COUNT;
    protected static int PARSER_STATE_COUNT;
    protected static int[] scannerStateCounts;
    protected static int DISAMBIG_GROUP_COUNT;
    protected static int[] scannerStartStates;
    protected static int PARSER_START_STATENUM;
    protected static int EOF_SYMNUM;
    protected static int EPS_SYMNUM;
    protected static String[] symbolNames;
    protected static int[] symbolNumbers;
    protected static int[] productionLHSs;
    protected static int[][] parseTableHost;
    protected static int[][] parseTableExts;
    protected static int[][] parseTableMarking;
    protected static BitSet[] shiftableSets;
    protected static BitSet[] layoutSets;
    protected static BitSet[] prefixSets;
    protected static BitSet[][] layoutMaps;
    protected static BitSet[][] prefixMaps;
    protected static BitSet[] disambiguationGroups;
    protected static BitSet[] neededScanners;
    protected static BitSet[] neededLayoutScanners;
    protected static BitSet[] neededPrefixScanners;
    protected static BitSet shiftableUnion;
    protected Stack<SingleDFAParseStackNode> parseStack;
    protected VirtualLocation virtualLocation;
    protected SingleDFAParseStackNode currentState;
    protected SingleDFAMatchData scanResult;
    protected ScannerBuffer buffer;
    protected BitSet lastShiftable;
    protected InputPosition lastPosition;
    protected SingleDFAMatchData lastMatched;

    public static int newSymbol(int symType, int index) {
        return (symType & 3) << 29 | index & 0x1FFFFFFF;
    }

    public static int newAction(int symType, int index) {
        return (symType & 3) << 29 | index & 0x1FFFFFFF;
    }

    public static int actionIndex(int action) {
        return action & 0x1FFFFFFF;
    }

    public static int actionType(int action) {
        return action >> 29 & 3;
    }

    public static BitSet newBitVec(int totalBits, int ... newBits) {
        BitSet rv = new BitSet(totalBits);
        SplitEngine.setBits(rv, newBits);
        return rv;
    }

    public static void setBits(BitSet vec, int ... newBits) {
        for (int bit : newBits) {
            vec.set(bit);
        }
    }

    public String bitVecToString(BitSet vec) {
        return PrettyPrinter.bitSetPrettyPrint(vec, symbolNames, "   ", 1);
    }

    public abstract int getParseTableAction(int var1, int var2);

    protected static boolean cheq(char input, char single) {
        return input == single;
    }

    protected static boolean chin(char input, char min, char max) {
        return input >= min && input <= max;
    }

    protected abstract int transition(int var1, int var2, char var3);

    protected abstract BitSet getAcceptSet(int var1, int var2);

    protected abstract BitSet getRejectSet(int var1, int var2);

    protected abstract BitSet getPossibleSet(int var1, int var2);

    protected abstract int runDisambiguationAction(InputPosition var1, SingleDFAMatchData var2) throws IOException, EXCEPT;

    protected abstract Object runSemanticAction(InputPosition var1, Object[] var2, int var3) throws IOException, EXCEPT;

    protected abstract Object runSemanticAction(InputPosition var1, SingleDFAMatchData var2) throws IOException, EXCEPT;

    public void runPostParseCode(Object __root) throws IOException, EXCEPT {
    }

    @Override
    public ROOT parse(Reader input) throws IOException, EXCEPT {
        return this.parse(input, "<stdin>");
    }

    @Override
    public abstract ROOT parse(Reader var1, String var2) throws IOException, EXCEPT;

    @Override
    public ROOT parse(String text) throws IOException, EXCEPT {
        return this.parse(text, "<StringBuffer>");
    }

    @Override
    public ROOT parse(String text, String inputName) throws IOException, EXCEPT {
        StringReader reader = new StringReader(text);
        return this.parse(reader, inputName);
    }

    protected abstract String formatError(String var1);

    protected abstract void reportError(String var1) throws EXCEPT;

    protected SingleDFAMatchData layoutScan(boolean runDisjoint) throws IOException, EXCEPT {
        BitSet shiftable = shiftableSets[this.currentState.statenum];
        InputPosition whence = this.currentState.pos;
        this.buffer.advanceBufferTo(whence.getPos());
        if (!runDisjoint && whence.equals(this.lastPosition) && this.lastMatched != null && (this.lastMatched.terms.get(EOF_SYMNUM) || this.lastMatched.precedingPos.equals(this.lastMatched.followingPos))) {
            boolean partiallyDisjoint = false;
            int i = this.lastMatched.terms.nextSetBit(0);
            while (i >= 0) {
                if (!shiftable.get(i)) {
                    partiallyDisjoint = true;
                    break;
                }
                i = this.lastMatched.terms.nextSetBit(i + 1);
            }
            if (!partiallyDisjoint) {
                this.lastShiftable = shiftable;
                return this.lastMatched;
            }
        }
        this.lastPosition = whence;
        this.lastShiftable = shiftable;
        LinkedList<SingleDFAMatchData> layouts = new LinkedList<SingleDFAMatchData>();
        if (layoutSets[this.currentState.statenum].isEmpty()) {
            return this.prefixScan(whence, shiftable, layouts, runDisjoint);
        }
        shiftable = shiftable.get(0, TERMINAL_COUNT);
        while (true) {
            SingleDFAMatchData matchingLayout = this.simpleScan(whence, neededLayoutScanners[this.currentState.statenum], layoutSets[this.currentState.statenum], layouts);
            if (layouts.isEmpty() && matchingLayout.terms.isEmpty() && layoutMaps[this.currentState.statenum][EPS_SYMNUM] != null && !layoutMaps[this.currentState.statenum][EPS_SYMNUM].isEmpty()) {
                matchingLayout.terms.set(EPS_SYMNUM);
                matchingLayout.firstTerm = matchingLayout.terms.nextSetBit(0);
                shiftable.and(layoutMaps[this.currentState.statenum][EPS_SYMNUM]);
                break;
            }
            if (matchingLayout.terms.cardinality() == 1) {
                shiftable.and(layoutMaps[this.currentState.statenum][matchingLayout.firstTerm]);
                whence = InputPosition.advance(whence, matchingLayout.lexeme.length(), matchingLayout.lexeme);
                if (matchingLayout.lexeme.length() == 0) {
                    if (layouts.isEmpty()) {
                        layouts.add(matchingLayout);
                    }
                    break;
                }
                layouts.add(matchingLayout);
                continue;
            }
            if (matchingLayout.terms.cardinality() > 1) {
                return matchingLayout;
            }
            if (layouts.isEmpty() && matchingLayout.terms.isEmpty()) {
                this.reportError(this.formatError("Expected layout of the following types:\n" + this.bitVecToString(layoutSets[this.currentState.statenum])));
                break;
            }
            if (matchingLayout.terms.isEmpty()) break;
        }
        SingleDFAMatchData finalMatches = this.prefixScan(whence, shiftable, layouts, runDisjoint);
        if (!finalMatches.terms.isEmpty()) {
            this.lastMatched = finalMatches;
        }
        return finalMatches;
    }

    protected SingleDFAMatchData prefixScan(InputPosition whence, BitSet shiftable, LinkedList<SingleDFAMatchData> layouts, boolean runDisjoint) throws IOException {
        if (prefixSets[this.currentState.statenum].isEmpty()) {
            return this.maybeDisjointScan(whence, neededScanners[this.currentState.statenum], shiftable, layouts, runDisjoint);
        }
        SingleDFAMatchData matchingPrefixes = this.simpleScan(whence, neededPrefixScanners[this.currentState.statenum], prefixSets[this.currentState.statenum], new LinkedList<SingleDFAMatchData>());
        if (matchingPrefixes.terms.isEmpty()) {
            return this.maybeDisjointScan(whence, neededScanners[this.currentState.statenum], shiftable, layouts, runDisjoint);
        }
        if (matchingPrefixes.terms.cardinality() > 1) {
            return matchingPrefixes;
        }
        layouts.add(matchingPrefixes);
        shiftable = prefixMaps[this.currentState.statenum][matchingPrefixes.firstTerm];
        whence = InputPosition.advance(whence, matchingPrefixes.lexeme.length(), matchingPrefixes.lexeme);
        return this.maybeDisjointScan(whence, neededScanners[this.currentState.statenum], shiftable, layouts, runDisjoint);
    }

    protected SingleDFAMatchData maybeDisjointScan(InputPosition whence, BitSet scanners, BitSet shiftable, LinkedList<SingleDFAMatchData> layouts, boolean runDisjoint) throws IOException {
        if (!runDisjoint) {
            return this.simpleScan(whence, scanners, shiftable, layouts);
        }
        return this.simpleScan(whence, scanners, shiftableUnion, layouts);
    }

    protected SingleDFAMatchData simpleScan(InputPosition whence, BitSet scanners, BitSet shiftable, LinkedList<SingleDFAMatchData> layouts) throws IOException {
        if (scanners.cardinality() == 1) {
            return this.simpleDetScan(whence, scanners, shiftable, layouts);
        }
        return this.simpleDualScan(whence, scanners, shiftable, layouts);
    }

    protected SingleDFAMatchData simpleDetScan(InputPosition whence, BitSet scanner, BitSet shiftable, LinkedList<SingleDFAMatchData> layouts) throws IOException {
        int activeScanner = scanner.nextSetBit(0);
        int currentState = scannerStartStates[activeScanner];
        char symbol = '\u0000';
        BitSet shiftableS = shiftable.get(0, TERMINAL_COUNT);
        BitSet present = SplitEngine.newBitVec(TERMINAL_COUNT, new int[0]);
        InputPosition presentPos = whence;
        InputPosition p = InputPosition.copy(whence);
        while (true) {
            BitSet tP = this.getPossibleSet(activeScanner, currentState).get(0, TERMINAL_COUNT);
            tP.and(shiftableS);
            if (p.equals(whence) && shiftableS.get(EOF_SYMNUM)) {
                tP.set(EOF_SYMNUM);
            }
            if (tP.isEmpty()) break;
            shiftableS.and(tP);
            BitSet tA = this.getAcceptSet(activeScanner, currentState).get(0, TERMINAL_COUNT);
            tA.and(shiftableS);
            if (!tA.isEmpty()) {
                present = tA;
                presentPos = InputPosition.copy(p);
            } else {
                BitSet tR = this.getRejectSet(activeScanner, currentState).get(0, TERMINAL_COUNT);
                tR.and(shiftableS);
                if (!tR.isEmpty()) {
                    present.clear();
                    presentPos = whence;
                }
            }
            symbol = this.buffer.charAt(p.getPos());
            if (symbol == ScannerBuffer.EOFIndicator) break;
            currentState = this.transition(activeScanner, currentState, symbol);
            p = InputPosition.advance(p, symbol);
        }
        if (symbol == ScannerBuffer.EOFIndicator && p.equals(whence) && shiftableS.get(EOF_SYMNUM)) {
            present.set(EOF_SYMNUM);
            return new SingleDFAMatchData(present, whence, p, "", layouts);
        }
        return new SingleDFAMatchData(present, whence, presentPos, this.buffer.readStringFromBuffer(whence.getPos(), presentPos.getPos()), layouts);
    }

    protected SingleDFAMatchData simpleDualScan(InputPosition whence, BitSet scanners, BitSet shiftable, LinkedList<SingleDFAMatchData> layouts) throws IOException {
        int activeScanner1 = scanners.nextSetBit(0);
        int activeScanner2 = scanners.nextSetBit(activeScanner1 + 1);
        int currentState1 = scannerStartStates[activeScanner1];
        int currentState2 = scannerStartStates[activeScanner2];
        char symbol = '\u0000';
        BitSet shiftableS = shiftable.get(0, TERMINAL_COUNT);
        BitSet present = SplitEngine.newBitVec(TERMINAL_COUNT, new int[0]);
        InputPosition presentPos = whence;
        InputPosition p = InputPosition.copy(whence);
        while (true) {
            BitSet tP1 = currentState1 == -1 ? new BitSet() : this.getPossibleSet(activeScanner1, currentState1).get(0, TERMINAL_COUNT);
            BitSet tP2 = currentState2 == -1 ? new BitSet() : this.getPossibleSet(activeScanner2, currentState2).get(0, TERMINAL_COUNT);
            BitSet tPUnion = new BitSet();
            tP1.and(shiftableS);
            tP2.and(shiftableS);
            tPUnion.or(tP1);
            tPUnion.or(tP2);
            if (p.equals(whence) && shiftableS.get(EOF_SYMNUM)) {
                tP1.set(EOF_SYMNUM);
            }
            if (tPUnion.isEmpty()) break;
            shiftableS.and(tPUnion);
            BitSet tA1 = currentState1 == -1 ? new BitSet() : this.getAcceptSet(activeScanner1, currentState1).get(0, TERMINAL_COUNT);
            BitSet tA2 = currentState2 == -1 ? new BitSet() : this.getAcceptSet(activeScanner2, currentState2).get(0, TERMINAL_COUNT);
            BitSet tAUnion = new BitSet();
            tA1.and(shiftableS);
            tA2.and(shiftableS);
            tAUnion.or(tA1);
            tAUnion.or(tA2);
            BitSet tR1 = currentState1 == -1 ? new BitSet() : this.getRejectSet(activeScanner1, currentState1).get(0, TERMINAL_COUNT);
            BitSet tR2 = currentState2 == -1 ? new BitSet() : this.getRejectSet(activeScanner2, currentState2).get(0, TERMINAL_COUNT);
            BitSet tRUnion = new BitSet();
            tR1.and(shiftableS);
            tR2.and(shiftableS);
            tRUnion.or(tR1);
            tRUnion.or(tR2);
            if (!tAUnion.isEmpty()) {
                if (tA1.isEmpty()) {
                    present = tA2;
                } else if (tA2.isEmpty()) {
                    present = tA1;
                } else {
                    System.err.println("Ambiguity across dual scanners: " + this.bitVecToString(tA1) + " vs. " + this.bitVecToString(tA2));
                    present = tAUnion;
                }
                presentPos = InputPosition.copy(p);
            } else if (!tRUnion.isEmpty()) {
                present.clear();
                presentPos = whence;
            }
            symbol = this.buffer.charAt(p.getPos());
            if (symbol == ScannerBuffer.EOFIndicator) break;
            currentState1 = tP1.isEmpty() ? -1 : this.transition(activeScanner1, currentState1, symbol);
            currentState2 = tP2.isEmpty() ? -1 : this.transition(activeScanner2, currentState2, symbol);
            p = InputPosition.advance(p, symbol);
        }
        if (symbol == ScannerBuffer.EOFIndicator && p.equals(whence) && shiftableS.get(EOF_SYMNUM)) {
            present.set(EOF_SYMNUM);
            return new SingleDFAMatchData(present, whence, p, "", layouts);
        }
        return new SingleDFAMatchData(present, whence, presentPos, this.buffer.readStringFromBuffer(whence.getPos(), presentPos.getPos()), layouts);
    }

    protected void startEngine(InputPosition initialPos) throws IOException, EXCEPT {
        this.parseStack = new Stack();
        this.parseStack.push(new SingleDFAParseStackNode(PARSER_START_STATENUM, initialPos, null));
        this.virtualLocation = new VirtualLocation(initialPos.getFileName(), 1, 0);
        this.currentState = null;
        this.lastPosition = null;
        this.lastMatched = null;
        this.lastShiftable = null;
        this.scanResult = null;
    }

    protected Object runEngine() throws IOException, EXCEPT {
        block5: while (true) {
            this.currentState = this.parseStack.peek();
            SingleDFAMatchData scanResult = this.layoutScan(false);
            if (scanResult.terms.isEmpty()) {
                SingleDFAMatchData disjointMatch = this.layoutScan(true);
                this.reportError(this.formatError("Expected a token of the following types:\n" + this.bitVecToString(shiftableSets[this.currentState.statenum]) + "\n   Input currently matches:\n" + this.bitVecToString(disjointMatch.terms)));
            } else if (scanResult.terms.cardinality() > 1) {
                int disambiguatedTerm = this.runDisambiguationAction(this.currentState.pos, scanResult);
                if (disambiguatedTerm == -1) {
                    int firstActionIndex = scanResult.firstTerm;
                    int action = this.getParseTableAction(this.currentState.statenum, firstActionIndex);
                    if (SplitEngine.actionType(action) == 2) {
                        disambiguatedTerm = firstActionIndex;
                    }
                    int i = scanResult.terms.nextSetBit(firstActionIndex + 1);
                    while (i >= 0) {
                        if (action != this.getParseTableAction(this.currentState.statenum, i)) {
                            disambiguatedTerm = -1;
                            break;
                        }
                        i = scanResult.terms.nextSetBit(i + 1);
                    }
                }
                if (disambiguatedTerm == -1) {
                    this.reportError(this.formatError("Lexical ambiguity between tokens:\n" + this.bitVecToString(scanResult.terms)));
                } else {
                    scanResult.terms = SplitEngine.newBitVec(TERMINAL_COUNT, disambiguatedTerm);
                    scanResult.firstTerm = disambiguatedTerm;
                }
            }
            int action = this.getParseTableAction(this.currentState.statenum, scanResult.firstTerm);
            switch (SplitEngine.actionType(action)) {
                case 3: {
                    return this.parseStack.peek().synthAttr;
                }
                case 1: {
                    int nextState = SplitEngine.actionIndex(action);
                    for (SingleDFAMatchData layout : scanResult.layouts) {
                        this.runSemanticAction(layout.precedingPos, layout);
                        this.virtualLocation.defaultUpdateAutomatic(layout.lexeme);
                    }
                    Object synthAttr = this.runSemanticAction(scanResult.precedingPos, scanResult);
                    this.virtualLocation.defaultUpdateAutomatic(scanResult.lexeme);
                    this.parseStack.push(new SingleDFAParseStackNode(nextState, scanResult.followingPos, synthAttr));
                    continue block5;
                }
                case 2: {
                    int production = SplitEngine.actionIndex(action);
                    int productionLength = SplitEngine.actionIndex(symbolNumbers[production]);
                    int productionLHS = SplitEngine.actionIndex(productionLHSs[production - GRAMMAR_SYMBOL_COUNT]);
                    Object[] children = new Object[productionLength];
                    for (int i = productionLength - 1; i >= 0; --i) {
                        children[i] = this.parseStack.pop().synthAttr;
                    }
                    int gotoState = SplitEngine.actionIndex(this.getParseTableAction(this.parseStack.peek().statenum, productionLHS));
                    Object synthAttr = this.runSemanticAction(this.currentState.pos, children, production);
                    this.parseStack.push(new SingleDFAParseStackNode(gotoState, this.currentState.pos, synthAttr));
                    continue block5;
                }
            }
            this.reportError(this.formatError("Cannot locate an action --- bug in parser"));
        }
    }
}

