/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.copper.compiletime.builders;

import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.CopperASTBean;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.Production;
import edu.umn.cs.melt.copper.compiletime.spec.numeric.PSSymbolTable;
import edu.umn.cs.melt.copper.compiletime.spec.numeric.ParserSpec;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;

public class ExtensionMappingSpec
implements Serializable {
    private static final long serialVersionUID = 6737324814615857778L;
    public Map<Integer, Integer> composedToDecomposedStates = new TreeMap<Integer, Integer>();
    public Map<Integer, Integer> extensionToComposedStates = new TreeMap<Integer, Integer>();
    public Map<Integer, Integer> composedToDecomposedSymbols;
    public Map<Integer, Integer> extensionToComposedSymbols;
    public BitSet composedExtensionStates;
    public BitSet extensionTerminalIndices;
    public BitSet extensionNonterminalIndices;
    public BitSet extensionProductionIndices;
    public BitSet extensionDisambiguationFunctionIndices;
    public BitSet extensionTerminalClassIndices;
    public BitSet extensionOperatorClassIndices;
    public BitSet extensionParserAttributeIndices;
    public BitSet extensionGrammarIndices;
    public BitSet extensionParserIndices;
    public BitSet hostTerminalIndices;
    public BitSet hostNonterminalIndices;
    public BitSet hostProductionIndices;
    public BitSet hostDisambiguationFunctionIndices;
    public BitSet hostTerminalClassIndices;
    public BitSet hostOperatorClassIndices;
    public BitSet hostParserAttributeIndices;
    public BitSet hostGrammarIndices;
    public BitSet hostParserIndices;
    public int extensionSymbolCount;
    public int extensionSymbolOffset;
    public int extensionSymbolTableOffset;
    public transient ParserSpec.TerminalData t;
    public transient ParserSpec.NonterminalData nt;
    public ParserSpec.ProductionData pr;
    public ParserSpec.DisambiguationFunctionData df;
    public transient ParserSpec.TerminalClassData tc;
    public transient ParserSpec.GrammarData g;
    public transient ParserSpec.ParserData p;
    public PSSymbolTable extensionSymbolTable;

    public ExtensionMappingSpec(ParserSpec fullSpec, PSSymbolTable fullSymbolTable, ParserSpec hostSpec, Map<Integer, Integer> composedToHostStates, BitSet composedExtensionStates) {
        this.composedExtensionStates = composedExtensionStates;
        this.composedToDecomposedStates = new TreeMap<Integer, Integer>();
        int extensionState = composedExtensionStates.nextSetBit(0);
        int i = 0;
        while (extensionState >= 0) {
            this.extensionToComposedStates.put(i, extensionState);
            this.composedToDecomposedStates.put(extensionState, ExtensionMappingSpec.encodeExtensionIndex(i));
            extensionState = composedExtensionStates.nextSetBit(extensionState + 1);
            ++i;
        }
        for (Map.Entry<Integer, Integer> entry : composedToHostStates.entrySet()) {
            this.composedToDecomposedStates.put(entry.getKey(), entry.getValue());
        }
        this.generateSymbolMaps(fullSpec, hostSpec);
        this.generateSymbolTable(fullSymbolTable);
        this.generateSymbolData(fullSpec);
    }

    private void generateSymbolMaps(ParserSpec fullSpec, ParserSpec hostSpec) {
        this.extensionTerminalIndices = new BitSet();
        this.extensionNonterminalIndices = new BitSet();
        this.extensionProductionIndices = new BitSet();
        this.extensionDisambiguationFunctionIndices = new BitSet();
        this.extensionTerminalClassIndices = new BitSet();
        this.extensionOperatorClassIndices = new BitSet();
        this.extensionParserAttributeIndices = new BitSet();
        this.extensionGrammarIndices = new BitSet();
        this.extensionParserIndices = new BitSet();
        this.hostTerminalIndices = new BitSet();
        this.hostNonterminalIndices = new BitSet();
        this.hostProductionIndices = new BitSet();
        this.hostDisambiguationFunctionIndices = new BitSet();
        this.hostTerminalClassIndices = new BitSet();
        this.hostOperatorClassIndices = new BitSet();
        this.hostParserAttributeIndices = new BitSet();
        this.hostGrammarIndices = new BitSet();
        this.hostParserIndices = new BitSet();
        this.composedToDecomposedSymbols = new TreeMap<Integer, Integer>();
        this.extensionToComposedSymbols = new TreeMap<Integer, Integer>();
        ArrayList<SymbolMapData> symbolMapDataList = new ArrayList<SymbolMapData>();
        symbolMapDataList.add(new SymbolMapData(fullSpec.terminals, hostSpec.terminals, this.extensionTerminalIndices, this.hostTerminalIndices));
        symbolMapDataList.add(new SymbolMapData(fullSpec.nonterminals, hostSpec.nonterminals, this.extensionNonterminalIndices, this.hostNonterminalIndices));
        symbolMapDataList.add(new SymbolMapData(fullSpec.productions, hostSpec.productions, this.extensionProductionIndices, this.hostProductionIndices));
        symbolMapDataList.add(new SymbolMapData(fullSpec.disambiguationFunctions, hostSpec.disambiguationFunctions, this.extensionDisambiguationFunctionIndices, this.hostDisambiguationFunctionIndices));
        symbolMapDataList.add(new SymbolMapData(fullSpec.terminalClasses, hostSpec.terminalClasses, this.extensionTerminalClassIndices, this.hostTerminalClassIndices));
        symbolMapDataList.add(new SymbolMapData(fullSpec.operatorClasses, hostSpec.operatorClasses, this.extensionOperatorClassIndices, this.hostOperatorClassIndices));
        symbolMapDataList.add(new SymbolMapData(fullSpec.parserAttributes, hostSpec.parserAttributes, this.extensionParserAttributeIndices, this.hostParserAttributeIndices));
        symbolMapDataList.add(new SymbolMapData(fullSpec.grammars, hostSpec.grammars, this.extensionGrammarIndices, this.hostGrammarIndices));
        int extensionIndex = 0;
        int hostIndex = 0;
        for (SymbolMapData data : symbolMapDataList) {
            this.generateSymbolPartitionMap(data.fullSpecSymbols, data.hostSpecSymbols, data.extensionSymbolIndices, extensionIndex, data.hostSymbolIndices, hostIndex);
            extensionIndex += data.extensionSymbolIndices.cardinality();
            hostIndex += data.hostSymbolIndices.cardinality();
        }
        this.hostParserIndices.set(hostIndex);
        this.composedToDecomposedSymbols.put(fullSpec.parser, hostIndex);
        this.extensionSymbolCount = extensionIndex;
        this.extensionSymbolOffset = ++hostIndex;
        this.extensionSymbolTableOffset = Math.max(this.hostTerminalIndices.length(), this.hostNonterminalIndices.length());
    }

    private void generateSymbolPartitionMap(BitSet fullSpecSymbols, BitSet hostSpecSymbols, BitSet extensionSymbolIndices, int eStartIndex, BitSet hostSymbolIndicies, int hStartIndex) {
        int t = fullSpecSymbols.nextSetBit(0);
        int hi = hStartIndex;
        int ei = eStartIndex;
        while (t >= 0) {
            if (hostSpecSymbols.get(t)) {
                this.composedToDecomposedSymbols.put(t, hi);
                hostSymbolIndicies.set(hi);
                ++hi;
            } else {
                this.composedToDecomposedSymbols.put(t, ExtensionMappingSpec.encodeExtensionIndex(ei));
                this.extensionToComposedSymbols.put(ei, t);
                extensionSymbolIndices.set(ei);
                ++ei;
            }
            t = fullSpecSymbols.nextSetBit(t + 1);
        }
    }

    private void generateSymbolTable(PSSymbolTable fullSymbolTable) {
        ArrayList<CopperASTBean> beans = new ArrayList<CopperASTBean>(this.composedToDecomposedSymbols.size());
        for (Map.Entry<Integer, Integer> entry : this.composedToDecomposedSymbols.entrySet()) {
            int decomposedIndex = entry.getValue();
            int composedIndex = entry.getKey();
            if (decomposedIndex >= 0) continue;
            int extensionSymbolIndex = ExtensionMappingSpec.decodeExtensionIndex(decomposedIndex);
            CopperASTBean composedBean = (CopperASTBean)fullSymbolTable.get(composedIndex);
            beans.add(extensionSymbolIndex, composedBean);
        }
        this.extensionSymbolTable = new PSSymbolTable((Collection<CopperASTBean>)beans);
    }

    private void generateSymbolData(ParserSpec fullSpec) {
        int maxRHS = 2;
        int i = this.extensionProductionIndices.nextSetBit(0);
        while (i >= 0) {
            maxRHS = Math.max(maxRHS, ((Production)this.extensionSymbolTable.get(i)).getRhs().size());
            i = this.extensionProductionIndices.nextSetBit(i + 1);
        }
        this.t = new ParserSpec.TerminalData(this.extensionTerminalIndices.length());
        this.nt = new ParserSpec.NonterminalData(this.extensionNonterminalIndices.length());
        this.pr = new ParserSpec.ProductionData(this.extensionProductionIndices.length(), maxRHS);
        this.df = new ParserSpec.DisambiguationFunctionData(this.extensionDisambiguationFunctionIndices.length());
        this.tc = new ParserSpec.TerminalClassData(this.extensionTerminalClassIndices.length());
        this.generateTerminalData(fullSpec);
        this.generateNonTerminalData(fullSpec);
        this.generateProductionData(fullSpec);
        this.generateDisambiguationFunctionData(fullSpec);
        this.generateTerminalClassData(fullSpec);
    }

    private void generateTerminalData(ParserSpec fullSpec) {
        int i = this.extensionTerminalIndices.nextSetBit(0);
        while (i >= 0) {
            int composedIndex = this.extensionToComposedSymbols.get(i);
            this.t.setRegex(i, fullSpec.t.getRegex(composedIndex));
            this.translateSymbolBitSetWithOffset(fullSpec.t.getTerminalClasses(composedIndex), this.t.getTerminalClasses(i));
            this.t.setTransparentPrefix(i, this.convertValidIndex(fullSpec.t.getTransparentPrefix(composedIndex)));
            this.t.setOperatorClass(i, this.convertValidIndex(fullSpec.t.getOperatorClass(composedIndex)));
            this.t.setOperatorPrecedence(i, fullSpec.t.getOperatorPrecedence(composedIndex));
            this.t.setOperatorAssociativity(i, fullSpec.t.getOperatorAssociativity(composedIndex));
            i = this.extensionTerminalIndices.nextSetBit(i + 1);
        }
    }

    private void generateNonTerminalData(ParserSpec fullSpec) {
        int i = this.extensionNonterminalIndices.nextSetBit(0);
        while (i >= 0) {
            int composedIndex = this.extensionToComposedSymbols.get(i);
            this.translateSymbolBitSetWithOffset(fullSpec.nt.getProductions(composedIndex), this.nt.getProductions(i));
            i = this.extensionNonterminalIndices.nextSetBit(i + 1);
        }
    }

    private void generateProductionData(ParserSpec fullSpec) {
        int i = this.extensionProductionIndices.nextSetBit(0);
        while (i >= 0) {
            int composedIndex = this.extensionToComposedSymbols.get(i);
            this.pr.setLHS(i, this.translateAndTableOffsetComposedSymbol(fullSpec.pr.getLHS(composedIndex)));
            int rhsLength = fullSpec.pr.getRHSLength(composedIndex);
            this.pr.setRHSLength(i, rhsLength);
            for (int j = 0; j < rhsLength; ++j) {
                this.pr.setRHSSym(i, j, this.translateAndTableOffsetComposedSymbol(fullSpec.pr.getRHSSym(composedIndex, j)));
            }
            this.pr.setOperator(i, this.convertValidIndexWithTableOffset(fullSpec.pr.getOperator(composedIndex)));
            this.pr.setPrecedence(i, fullSpec.pr.getPrecedence(composedIndex));
            this.pr.setHasLayout(i, fullSpec.pr.hasLayout(composedIndex));
            this.translateSymbolBitSetWithTableOffset(fullSpec.pr.getLayouts(composedIndex), this.pr.getLayouts(i));
            i = this.extensionProductionIndices.nextSetBit(i + 1);
        }
    }

    private void generateDisambiguationFunctionData(ParserSpec fullSpec) {
        int i = this.extensionDisambiguationFunctionIndices.nextSetBit(0);
        while (i >= 0) {
            int composedIndex = this.extensionToComposedSymbols.get(i);
            this.translateSymbolBitSetWithTableOffset(fullSpec.df.getMembers(composedIndex), this.df.getMembers(i));
            this.df.setDisambiguateTo(i, this.convertValidIndexWithTableOffset(fullSpec.df.getDisambiguateTo(composedIndex)));
            i = this.extensionDisambiguationFunctionIndices.nextSetBit(i + 1);
        }
    }

    private void generateTerminalClassData(ParserSpec fullSpec) {
        int i = this.extensionTerminalClassIndices.nextSetBit(0);
        while (i >= 0) {
            int composedIndex = this.extensionToComposedSymbols.get(i);
            this.translateSymbolBitSetWithOffset(fullSpec.tc.getMembers(composedIndex), this.tc.getMembers(i));
            i = this.extensionTerminalClassIndices.nextSetBit(i + 1);
        }
    }

    private int convertValidIndex(int index) {
        return index < 0 ? index : this.translateAndOffsetComposedSymbol(index);
    }

    private int convertValidIndexWithTableOffset(int index) {
        return index < 0 ? index : this.translateAndTableOffsetComposedSymbol(index);
    }

    public static int encodeExtensionIndex(int i) {
        return -1 * (i + 1);
    }

    public static int decodeExtensionIndex(int i) {
        return -1 * i - 1;
    }

    public int translateAndOffsetComposedSymbol(int i) {
        int decomposedIndex = this.composedToDecomposedSymbols.get(i);
        return decomposedIndex < 0 ? this.decodeAndOffsetExtensionIndex(decomposedIndex) : decomposedIndex;
    }

    public int untranslateAndOffsetComposedSymbol(int i) {
        if (i < this.extensionSymbolOffset) {
            return i;
        }
        return this.encodeOffsetExtensionIndex(i);
    }

    public int translateAndTableOffsetComposedSymbol(int i) {
        int decomposedIndex = this.composedToDecomposedSymbols.get(i);
        return decomposedIndex < 0 ? this.decodeAndTableOffsetExtensionIndex(decomposedIndex) : decomposedIndex;
    }

    public void translateSymbolBitSetWithOffset(BitSet from, BitSet to) {
        to.clear();
        int i = from.nextSetBit(0);
        while (i >= 0) {
            to.set(this.translateAndOffsetComposedSymbol(i));
            i = from.nextSetBit(i + 1);
        }
    }

    public BitSet translateSymbolBitSetWithTableOffset(BitSet from, BitSet to) {
        to.clear();
        int i = from.nextSetBit(0);
        while (i >= 0) {
            to.set(this.translateAndTableOffsetComposedSymbol(i));
            i = from.nextSetBit(i + 1);
        }
        return to;
    }

    public int decodeAndOffsetExtensionIndex(int i) {
        return -1 * i - 1 + this.extensionSymbolOffset;
    }

    public int decodeAndTableOffsetExtensionIndex(int i) {
        return -1 * i - 1 + this.extensionSymbolTableOffset;
    }

    public int offsetExtensionIndex(int i) {
        return i + this.extensionSymbolOffset;
    }

    public int tableOffsetExtensionIndex(int i) {
        return i + this.extensionSymbolTableOffset;
    }

    public int unOffsetExtensionIndex(int i) {
        return i - this.extensionSymbolOffset;
    }

    public int encodeOffsetExtensionIndex(int i) {
        return -1 * (i - this.extensionSymbolOffset + 1);
    }

    public boolean isTableOffsetTerminal(int i) {
        if (i >= this.extensionSymbolTableOffset) {
            return this.extensionTerminalIndices.get(i - this.extensionSymbolTableOffset);
        }
        return this.hostTerminalIndices.get(i);
    }

    public boolean isTableOffsetNonterminal(int i) {
        if (i >= this.extensionSymbolTableOffset) {
            return this.extensionNonterminalIndices.get(i - this.extensionSymbolTableOffset);
        }
        return this.hostNonterminalIndices.get(i);
    }

    private class SymbolMapData {
        public BitSet fullSpecSymbols;
        public BitSet hostSpecSymbols;
        public BitSet extensionSymbolIndices;
        public BitSet hostSymbolIndices;

        public SymbolMapData(BitSet fullSpecSymbols, BitSet hostSpecSymbols, BitSet extensionSymbolIndices, BitSet hostSymbolIndices) {
            this.fullSpecSymbols = fullSpecSymbols;
            this.hostSpecSymbols = hostSpecSymbols;
            this.extensionSymbolIndices = extensionSymbolIndices;
            this.hostSymbolIndices = hostSymbolIndices;
        }
    }
}

