/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.copper.compiletime.spec.grammarbeans;

import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.CopperElementName;
import edu.umn.cs.melt.copper.runtime.io.Location;
import java.io.Serializable;
import java.text.ParseException;

public class CopperElementReference
implements Comparable<CopperElementReference>,
Serializable {
    private static final long serialVersionUID = 3611269639124084387L;
    protected CopperElementName grammarName;
    protected CopperElementName name;
    protected Location location;

    protected CopperElementReference(CopperElementName name, Location location) {
        this(null, name, location);
    }

    protected CopperElementReference(CopperElementName grammarName, CopperElementName name, Location location) {
        this.grammarName = grammarName;
        this.name = name;
        this.location = location;
    }

    public static CopperElementReference ref(CopperElementName name, Location location) {
        return new CopperElementReference(name, location);
    }

    public static CopperElementReference ref(String name, Location location) throws ParseException {
        String[] components = name.split(":");
        if (components.length == 1) {
            return new CopperElementReference(CopperElementName.newName(name), location);
        }
        if (components.length == 2) {
            return CopperElementReference.ref(CopperElementName.newName(components[0]), components[1], location);
        }
        throw new ParseException("Invalid name for a Copper element: " + name, 0);
    }

    public static CopperElementReference ref(CopperElementName grammarName, String localName, Location location) throws ParseException {
        return new CopperElementReference(grammarName, CopperElementName.newName(localName), location);
    }

    public static CopperElementReference ref(CopperElementName grammarName, CopperElementName localName, Location location) {
        return new CopperElementReference(grammarName, localName, location);
    }

    public CopperElementName getGrammarName() {
        return this.grammarName;
    }

    public CopperElementName getName() {
        return this.name;
    }

    public Location getLocation() {
        return this.location;
    }

    public boolean isFQ() {
        return this.grammarName != null;
    }

    public int hashCode() {
        return this.grammarName == null ? this.name.hashCode() : this.name.hashCode() + this.grammarName.hashCode();
    }

    public boolean equals(Object o) {
        return o instanceof CopperElementReference && (this.grammarName != null && this.grammarName.equals(((CopperElementReference)o).grammarName) || this.grammarName == null && ((CopperElementReference)o).grammarName == null) && this.name.equals(((CopperElementReference)o).name);
    }

    public String toString() {
        if (this.grammarName == null) {
            return this.name.toString();
        }
        return this.grammarName + ":" + this.name;
    }

    @Override
    public int compareTo(CopperElementReference o) {
        int gC;
        if (this.grammarName == null && o.grammarName != null) {
            return -1;
        }
        if (this.grammarName != null && o.grammarName == null) {
            return 1;
        }
        if (this.grammarName != null && o.grammarName != null && (gC = this.grammarName.compareTo(o.grammarName)) != 0) {
            return gC;
        }
        return this.name.compareTo(o.name);
    }
}

