/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.visitors;

import edu.umn.cs.melt.copper.compiletime.auxiliary.SetOfCharsSyntax;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.CharacterSetRegex;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.ChoiceRegex;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.ConcatenationRegex;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.CopperElementName;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.CopperElementReference;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.CopperElementType;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.DisambiguationFunction;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.EmptyStringRegex;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.ExtendedParserBean;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.ExtensionGrammar;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.Grammar;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.GrammarElement;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.KleeneStarRegex;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.MacroHoleRegex;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.NonTerminal;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.OperatorClass;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.ParserAttribute;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.ParserBean;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.Production;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.Regex;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.Terminal;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.TerminalClass;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.visitors.CopperASTBeanVisitor;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.visitors.GrammarError;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.visitors.RegexBeanVisitor;
import edu.umn.cs.melt.copper.runtime.io.Location;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

class GrammarConsistencyChecker
implements CopperASTBeanVisitor<Boolean, RuntimeException>,
RegexBeanVisitor<Boolean, RuntimeException> {
    protected SortedSet<GrammarError> errors = new TreeSet<GrammarError>();
    private ParserBean currentParser = null;
    private Grammar currentGrammar = null;
    private Terminal currentTerminal;
    private boolean isBridgeProduction;

    GrammarConsistencyChecker() {
    }

    public SortedSet<GrammarError> getErrors() {
        return this.errors;
    }

    @Override
    public Boolean visitDisambiguationFunction(DisambiguationFunction bean) {
        boolean hasError = false;
        if (!bean.isComplete()) {
            Set<String> whatIsMissing = bean.whatIsMissing();
            this.errors.add(new GrammarError(bean.getLocation(), this.currentParser, null, "Disambiguation function " + bean.getDisplayName() + " is missing the following required attributes: " + whatIsMissing));
            hasError = true;
        } else {
            for (CopperElementReference n : bean.getMembers()) {
                boolean isDefined = this.nameIsDefined(n) && this.nameIsHost(n);
                hasError |= !isDefined;
                if (!isDefined || this.dereference(n).getType() == CopperElementType.TERMINAL || this.dereference(n).getType() == CopperElementType.TERMINAL_CLASS) continue;
                this.reportError(n.getLocation(), this.getDisplayName(n) + ", member of disambiguation function " + bean.getDisplayName() + ", is not a terminal or a terminal class");
                hasError = true;
            }
            if (bean.getDisambiguateTo() != null && !bean.getMembers().contains(bean.getDisambiguateTo())) {
                this.reportError(bean.getLocation(), this.getDisplayName(bean.getDisambiguateTo()) + ", target of disambiguation function " + bean.getDisplayName() + ", is not a member of the disambiguation function");
                hasError = true;
            }
            if (bean.getDisambiguateTo() != null && bean.getCode() != null) {
                this.reportError(bean.getLocation(), "A disambiguation function cannot specify both a declarative target and a code block");
                hasError = true;
            }
        }
        return hasError;
    }

    private boolean visitCompleteGrammarBean(Grammar bean, boolean isExtensionGrammar) {
        ExtensionGrammar extBean = isExtensionGrammar ? (ExtensionGrammar)bean : null;
        boolean hasError = false;
        if (bean.getGrammarLayout() != null) {
            for (CopperElementReference copperElementReference : bean.getGrammarLayout()) {
                boolean isDefined = this.nameIsDefined(copperElementReference) && this.nameIsHost(copperElementReference);
                hasError |= !isDefined;
                if (!isDefined || this.dereference(copperElementReference).getType() == CopperElementType.TERMINAL) continue;
                this.reportError(copperElementReference.getLocation(), this.getDisplayName(copperElementReference) + ", designated as a grammar layout symbol of grammar " + bean.getDisplayName() + ", is not a terminal");
                hasError = true;
            }
        }
        for (CopperElementName copperElementName : bean.getGrammarElements()) {
            if (isExtensionGrammar && extBean.getBridgeProductions().contains(copperElementName)) {
                this.isBridgeProduction = true;
            }
            hasError |= bean.getGrammarElement(copperElementName).acceptVisitor(this).booleanValue();
            this.isBridgeProduction = false;
        }
        return hasError;
    }

    @Override
    public Boolean visitGrammar(Grammar bean) {
        this.currentGrammar = bean;
        boolean hasError = false;
        if (bean.isPlaceholder()) {
            this.reportError(this.currentParser.getLocation(), this.currentParser, this.currentGrammar, "Grammar is listed in parser but not specified");
            hasError = true;
        } else if (!bean.isComplete()) {
            Set<String> whatIsMissing = bean.whatIsMissing();
            this.reportError(bean.getLocation(), "Grammar is missing the following required attributes: " + whatIsMissing);
            hasError = true;
        } else {
            hasError |= this.visitCompleteGrammarBean(bean, false);
        }
        this.currentGrammar = null;
        return hasError;
    }

    @Override
    public Boolean visitExtensionGrammar(ExtensionGrammar bean) {
        this.currentGrammar = bean;
        boolean hasError = false;
        if (!bean.isComplete()) {
            Set<String> whatIsMissing = bean.whatIsMissing();
            this.reportError(bean.getLocation(), "Extension grammar is missing the following required attributes: " + whatIsMissing);
            hasError = true;
        } else {
            hasError |= this.visitCompleteGrammarBean(bean, true);
            Hashtable<CopperElementName, CopperElementName> markingToLHS = new Hashtable<CopperElementName, CopperElementName>();
            for (CopperElementName p : bean.getBridgeProductions()) {
                CopperElementName marking = bean.getBridgeProduction(p).getRhs().get(0).getName();
                if (markingToLHS.containsKey(marking) && !((CopperElementName)markingToLHS.get(marking)).equals(bean.getBridgeProduction(p).getLhs().getName())) {
                    this.reportError(bean.getLocation(), "Marking terminal " + marking + " used on bridge productions with different left-hand sides");
                    continue;
                }
                markingToLHS.put(marking, bean.getBridgeProduction(p).getLhs().getName());
            }
        }
        return hasError;
    }

    @Override
    public Boolean visitNonTerminal(NonTerminal bean) {
        boolean hasError = false;
        if (!bean.isComplete()) {
            Set<String> whatIsMissing = bean.whatIsMissing();
            this.errors.add(new GrammarError(bean.getLocation(), this.currentParser, null, "Nonterminal " + bean.getDisplayName() + " is missing the following required attributes: " + whatIsMissing));
            hasError = true;
        }
        return hasError;
    }

    @Override
    public Boolean visitParserAttribute(ParserAttribute bean) {
        boolean hasError = false;
        if (!bean.isComplete()) {
            Set<String> whatIsMissing = bean.whatIsMissing();
            this.errors.add(new GrammarError(bean.getLocation(), this.currentParser, null, "Parser attribute " + bean.getDisplayName() + " is missing the following required attributes: " + whatIsMissing));
            hasError = true;
        }
        return hasError;
    }

    @Override
    public Boolean visitParserBean(ParserBean bean) {
        this.currentParser = bean;
        boolean hasError = false;
        if (bean == null) {
            this.errors.add(new GrammarError(null, null, null, "No parser specified"));
            hasError = true;
        } else if (!bean.isComplete()) {
            Set<String> whatIsMissing = bean.whatIsMissing();
            this.errors.add(new GrammarError(bean.getLocation(), this.currentParser, null, "Parser is missing the following required attributes: " + whatIsMissing));
            hasError = true;
        } else {
            if (bean.getClassName() != null && bean.getClassName().indexOf(46) != -1) {
                this.errors.add(new GrammarError(bean.getLocation(), this.currentParser, null, "Class name " + bean.getClassName() + " includes package name"));
                hasError = true;
            }
            if (bean.isUnitary() && bean.getGrammars().size() > 1) {
                this.errors.add(new GrammarError(bean.getLocation(), this.currentParser, null, "Parser " + bean.getDisplayName() + " has been declared as unitary but contains more than one grammar"));
                hasError = true;
            }
            for (CopperElementName n : bean.getGrammars()) {
                if (bean.getGrammar(n).getType() == CopperElementType.EXTENSION_GRAMMAR && bean.getType() != CopperElementType.EXTENDED_PARSER) {
                    this.errors.add(new GrammarError(bean.getLocation(), this.currentParser, bean.getGrammar(n), "Extension grammars may only appear inside extended parsers"));
                    hasError = true;
                }
                hasError |= bean.getGrammar(n).acceptVisitor(this).booleanValue();
            }
            boolean isDefined = this.nameIsDefined(bean.getStartSymbol());
            hasError |= !isDefined;
            if (isDefined && this.dereference(bean.getStartSymbol()).getType() != CopperElementType.NON_TERMINAL) {
                this.errors.add(new GrammarError(bean.getStartSymbol().getLocation(), this.currentParser, null, this.getDisplayName(bean.getStartSymbol()) + ", designated as praser's start symbol, is not a nonterminal"));
                hasError = true;
            } else if (isDefined && bean.getGrammar(bean.getStartSymbol().getGrammarName()).getType() == CopperElementType.EXTENSION_GRAMMAR) {
                this.errors.add(new GrammarError(bean.getStartSymbol().getLocation(), this.currentParser, null, "Designated start symbol " + this.getDisplayName(bean.getStartSymbol()) + " is in an extension grammar (" + bean.getGrammar(bean.getStartSymbol().getGrammarName()).getDisplayName() + ")"));
                hasError = true;
            }
            if (bean.getStartLayout() != null) {
                for (CopperElementReference n : bean.getStartLayout()) {
                    isDefined = this.nameIsDefined(n);
                    hasError |= !isDefined;
                    if (!isDefined || this.dereference(n).getType() == CopperElementType.TERMINAL) continue;
                    this.reportError(n.getLocation(), this.getDisplayName(n) + ", designated as a start layout symbol of parser " + bean.getDisplayName() + ", is not a terminal");
                    hasError = true;
                }
            }
        }
        return hasError;
    }

    @Override
    public Boolean visitExtendedParserBean(ExtendedParserBean bean) {
        boolean hasError = this.visitParserBean(bean);
        if (hasError) {
            return hasError;
        }
        if (bean.getHostGrammar() != null && !bean.getGrammars().contains(bean.getHostGrammar())) {
            this.reportError(bean.getLocation(), bean.getHostGrammar() + ", designated as the host grammar of parser " + bean.getDisplayName() + " is not designated as one of the parser's grammars");
            hasError = true;
        }
        if (bean.getGrammar(bean.getHostGrammar()).getType() == CopperElementType.EXTENSION_GRAMMAR) {
            this.reportError(bean.getLocation(), bean.getGrammar(bean.getHostGrammar()).getDisplayName() + ", designated as the host grammar of parser " + bean.getDisplayName() + " is an extension grammar");
            hasError = true;
        }
        if (bean.getGrammars().size() != 2) {
            this.reportError(bean.getLocation(), "Extended parser " + bean.getDisplayName() + " must have exactly two grammars, one host and one extension");
            hasError = true;
        } else {
            for (CopperElementName grammar : bean.getGrammars()) {
                if (grammar.equals(bean.getHostGrammar()) || bean.getGrammar(grammar).getType() == CopperElementType.EXTENSION_GRAMMAR) continue;
                this.reportError(bean.getLocation(), bean.getGrammar(bean.getHostGrammar()).getDisplayName() + ", designated as an extension grammar in parser " + bean.getDisplayName() + ", is not an extension grammar");
                hasError = true;
            }
        }
        if (hasError) {
            return hasError;
        }
        if (!bean.getStartSymbol().isFQ() || !bean.getStartSymbol().getGrammarName().equals(bean.getHostGrammar())) {
            this.reportError(bean.getStartSymbol().getLocation(), this.getDisplayName(bean.getStartSymbol()) + ", designated as the start symbol of parser " + bean.getDisplayName() + ", does not belong to the host grammar");
            hasError = true;
        }
        if (bean.getStartLayout() != null) {
            for (CopperElementReference layout : bean.getStartLayout()) {
                if (layout.isFQ() && layout.getGrammarName().equals(bean.getHostGrammar())) continue;
                this.reportError(bean.getStartSymbol().getLocation(), this.getDisplayName(bean.getStartSymbol()) + ", designated as a start layout symbol of parser " + bean.getDisplayName() + ", does not belong to the host grammar");
                hasError = true;
            }
        }
        return hasError;
    }

    @Override
    public Boolean visitProduction(Production bean) {
        boolean hasError = false;
        if (!bean.isComplete()) {
            Set<String> whatIsMissing = bean.whatIsMissing();
            this.reportError(bean.getLocation(), "Production " + bean.getDisplayName() + " is missing the following required attributes: " + whatIsMissing);
            hasError = true;
        } else {
            CopperElementReference n;
            boolean isDefined = this.nameIsDefined(bean.getLhs());
            hasError |= !isDefined;
            if (isDefined && this.dereference(bean.getLhs()).getType() != CopperElementType.NON_TERMINAL) {
                this.reportError(bean.getLhs().getLocation(), this.getDisplayName(bean.getLhs()) + ", designated as production " + bean.getDisplayName() + "'s left-hand side, is not a nonterminal");
                hasError = true;
            }
            int i = 0;
            if (this.isBridgeProduction) {
                if (bean.getRhs().size() < 1 || bean.getRhs().get(0).isFQ() && !bean.getRhs().get(0).getGrammarName().equals(this.currentGrammar.getName()) || !((ExtensionGrammar)this.currentGrammar).getMarkingTerminals().contains(bean.getRhs().get(0).getName())) {
                    this.reportError(bean.getLocation(), bean.getDisplayName() + ", designated as a bridge production of grammar " + this.currentGrammar.getDisplayName() + ", must have a marking terminal as its first right-hand side symbol");
                    hasError = true;
                }
                if (!bean.getLhs().isFQ() || !bean.getLhs().getGrammarName().equals(((ExtendedParserBean)this.currentParser).getHostGrammar())) {
                    this.reportError(bean.getLhs().getLocation(), this.getDisplayName(bean.getLhs()) + ", designated as the left-hand side of a bridge production, was not declared in the host grammar");
                    hasError = true;
                }
                ++i;
            } else if (this.currentParser.getType() == CopperElementType.EXTENDED_PARSER && bean.getLhs().isFQ() && !bean.getLhs().getGrammarName().equals(this.currentGrammar.getName())) {
                this.reportError(bean.getLhs().getLocation(), this.getDisplayName(bean.getLhs()) + ", designated as the left-hand side of a production in an extended parser, was not declared in the same grammar as the production");
                hasError = true;
            }
            while (i < bean.getRhs().size()) {
                n = bean.getRhs().get(i);
                isDefined = this.nameIsDefined(n) && this.nameIsHost(n);
                hasError |= !isDefined;
                if (isDefined && this.dereference(n).getType() != CopperElementType.TERMINAL && this.dereference(n).getType() != CopperElementType.NON_TERMINAL) {
                    this.reportError(n.getLocation(), this.getDisplayName(n) + " is not a terminal or a nonterminal");
                    hasError = true;
                }
                if (isDefined && this.currentParser.getType() == CopperElementType.EXTENDED_PARSER && this.currentGrammar.getType() == CopperElementType.EXTENSION_GRAMMAR && (!n.isFQ() || n.getGrammarName().equals(this.currentGrammar.getName())) && ((ExtensionGrammar)this.currentGrammar).getMarkingTerminals().contains(this.dereference(n).getName())) {
                    this.reportError(n.getLocation(), this.getDisplayName(n) + ", designated as a marking terminal, must be referenced only as the first right-hand-side element in a bridge production");
                    hasError = true;
                }
                ++i;
            }
            if (bean.getRhsVarNames() != null && bean.getRhsVarNames().size() != bean.getRhs().size()) {
                this.reportError(bean.getLocation(), "In production " + bean.getDisplayName() + ": Size mismatch between right-hand side symbols (" + bean.getRhs().size() + ") and variable names (" + bean.getRhs().size() + " symbols on its right-hand side but specifies " + bean.getRhsVarNames() + " variable names");
                hasError = true;
            }
            if (bean.getRhsVarNames() != null) {
                HashSet<String> varNames = new HashSet<String>();
                for (String n2 : bean.getRhsVarNames()) {
                    if (n2 == null || varNames.add(n2)) continue;
                    this.reportError(bean.getLocation(), "In production " + bean.getDisplayName() + ": Duplicate variable name: " + n2);
                    hasError = true;
                }
            }
            if (bean.getOperator() != null) {
                n = bean.getOperator();
                isDefined = this.nameIsDefined(n) && this.nameIsHost(n);
                hasError |= !isDefined;
                if (isDefined && this.dereference(n).getType() != CopperElementType.TERMINAL) {
                    this.reportError(n.getLocation(), this.getDisplayName(n) + ", designated as production " + bean.getDisplayName() + "'s operator symbol, is not a terminal");
                    hasError = true;
                }
            }
            if (bean.getPrecedenceClass() != null) {
                n = bean.getPrecedenceClass();
                isDefined = this.nameIsDefined(n) && this.nameIsHost(n);
                hasError |= !isDefined;
                if (isDefined && this.dereference(n).getType() != CopperElementType.OPERATOR_CLASS) {
                    this.reportError(n.getLocation(), this.getDisplayName(n) + ", designated as production " + bean.getDisplayName() + "'s operator class, is not an operator class");
                    hasError = true;
                }
            }
            if (bean.getPrecedence() != null && bean.getPrecedence() < 0) {
                this.reportError(bean.getLocation(), "Production " + bean.getDisplayName() + "'s precedence must be a non-negative integer; instead is " + bean.getPrecedence());
                hasError = true;
            }
            if (bean.getLayout() != null) {
                for (CopperElementReference n3 : bean.getLayout()) {
                    isDefined = this.nameIsDefined(n3) && this.nameIsHost(n3);
                    hasError |= !isDefined;
                    if (!isDefined || this.dereference(n3).getType() == CopperElementType.TERMINAL) continue;
                    this.reportError(n3.getLocation(), this.getDisplayName(n3) + ", specified as layout to production " + bean.getDisplayName() + ", is not a terminal");
                    hasError = true;
                }
            }
        }
        return hasError;
    }

    @Override
    public Boolean visitTerminal(Terminal bean) {
        this.currentTerminal = bean;
        boolean hasError = false;
        if (!bean.isComplete()) {
            Set<String> whatIsMissing = bean.whatIsMissing();
            this.reportError(bean.getLocation(), "Terminal " + bean.getDisplayName() + " is missing the following required attributes: " + whatIsMissing);
            hasError = true;
        } else {
            boolean isDefined;
            boolean isDefined2;
            CopperElementReference n;
            if (bean.getOperatorClass() != null) {
                n = bean.getOperatorClass();
                isDefined2 = this.nameIsDefined(n) && this.nameIsHost(n);
                hasError |= !isDefined2;
                if (isDefined2 && this.dereference(n).getType() != CopperElementType.OPERATOR_CLASS) {
                    this.reportError(n.getLocation(), this.getDisplayName(n) + ", designated as terminal " + bean.getDisplayName() + "'s operator class, is not an operator class");
                    hasError = true;
                }
            }
            if (bean.getOperatorPrecedence() != null && bean.getOperatorPrecedence() < 0) {
                this.reportError(bean.getLocation(), "Terminal " + bean.getDisplayName() + "'s operator precedence must be a non-negative integer; instead is " + bean.getOperatorPrecedence());
                hasError = true;
            }
            if (bean.getPrefix() != null) {
                n = bean.getPrefix();
                isDefined2 = this.nameIsDefined(n) && this.nameIsHost(n);
                hasError |= !isDefined2;
                if (isDefined2 && this.dereference(n).getType() != CopperElementType.TERMINAL) {
                    this.reportError(n.getLocation(), this.getDisplayName(n) + ", designated as terminal " + bean.getDisplayName() + "'s transparent prefix, is not a terminal");
                    hasError = true;
                }
            }
            for (CopperElementReference n2 : bean.getTerminalClasses()) {
                isDefined = this.nameIsDefined(n2) && this.nameIsHost(n2);
                hasError |= !isDefined;
                if (!isDefined || this.dereference(n2).getType() == CopperElementType.TERMINAL_CLASS) continue;
                this.reportError(n2.getLocation(), "Non-terminal class " + this.getDisplayName(n2) + " in the class list of terminal " + bean.getDisplayName());
                hasError = true;
            }
            for (CopperElementReference n3 : bean.getSubmitList()) {
                isDefined = this.nameIsDefined(n3) && this.nameIsHost(n3);
                hasError |= !isDefined;
                if (!isDefined || this.dereference(n3).getType() == CopperElementType.TERMINAL || this.dereference(n3).getType() == CopperElementType.TERMINAL_CLASS) continue;
                this.reportError(n3.getLocation(), this.getDisplayName(n3) + ", in the submit list of terminal " + bean.getDisplayName() + ", is not a terminal or a terminal class");
                hasError = true;
            }
            for (CopperElementReference n4 : bean.getDominateList()) {
                isDefined = this.nameIsDefined(n4) && this.nameIsHost(n4);
                hasError |= !isDefined;
                if (!isDefined || this.dereference(n4).getType() == CopperElementType.TERMINAL || this.dereference(n4).getType() == CopperElementType.TERMINAL_CLASS) continue;
                this.reportError(n4.getLocation(), this.getDisplayName(n4) + ", in the dominate list of terminal " + bean.getDisplayName() + ", is not a terminal or a terminal class");
                hasError = true;
            }
        }
        return hasError;
    }

    @Override
    public Boolean visitTerminalClass(TerminalClass bean) {
        boolean hasError = false;
        if (!bean.isComplete()) {
            Set<String> whatIsMissing = bean.whatIsMissing();
            this.reportError(bean.getLocation(), "Terminal class " + bean.getDisplayName() + " is missing the following required attributes: " + whatIsMissing);
            hasError = true;
        }
        return hasError;
    }

    @Override
    public Boolean visitOperatorClass(OperatorClass bean) throws RuntimeException {
        boolean hasError = false;
        if (!bean.isComplete()) {
            Set<String> whatIsMissing = bean.whatIsMissing();
            this.reportError(bean.getLocation(), "Production class " + bean.getDisplayName() + " is missing the following required attributes: " + whatIsMissing);
            hasError = true;
        }
        return hasError;
    }

    private boolean checkRegexCompleteness(Regex bean) {
        boolean hasError = false;
        if (!bean.isComplete()) {
            Set<String> whatIsMissing = bean.whatIsMissing();
            this.reportError(this.currentTerminal.getLocation(), "Regex is missing the following required attributes: " + whatIsMissing);
            hasError = true;
        }
        return hasError;
    }

    @Override
    public Boolean visitChoiceRegex(ChoiceRegex bean) throws RuntimeException {
        boolean hasError = this.checkRegexCompleteness(bean);
        for (Regex constit : bean.getSubexps()) {
            hasError |= constit.acceptVisitor(this).booleanValue();
        }
        return hasError;
    }

    @Override
    public Boolean visitConcatenationRegex(ConcatenationRegex bean) throws RuntimeException {
        boolean hasError = this.checkRegexCompleteness(bean);
        for (Regex constit : bean.getSubexps()) {
            hasError |= constit.acceptVisitor(this).booleanValue();
        }
        return hasError;
    }

    @Override
    public Boolean visitKleeneStarRegex(KleeneStarRegex bean) throws RuntimeException {
        boolean hasError = this.checkRegexCompleteness(bean);
        return hasError |= bean.getSubexp().acceptVisitor(this).booleanValue();
    }

    @Override
    public Boolean visitEmptyStringRegex(EmptyStringRegex bean) throws RuntimeException {
        return this.checkRegexCompleteness(bean);
    }

    @Override
    public Boolean visitCharacterSetRegex(CharacterSetRegex bean, SetOfCharsSyntax chars) throws RuntimeException {
        return this.checkRegexCompleteness(bean);
    }

    @Override
    public Boolean visitMacroHoleRegex(MacroHoleRegex bean) throws RuntimeException {
        boolean hasError = this.checkRegexCompleteness(bean);
        boolean isDefined = this.nameIsDefined(bean.getMacroName()) && this.nameIsHost(bean.getMacroName());
        hasError |= !isDefined;
        if (isDefined && this.dereference(bean.getMacroName()).getType() != CopperElementType.TERMINAL) {
            this.reportError(bean.getMacroName().getLocation(), this.getDisplayName(bean.getMacroName()) + " does not reference a valid regex");
            hasError = true;
        }
        return hasError;
    }

    private boolean nameIsDefined(CopperElementReference symbol) {
        if (!symbol.isFQ()) {
            if (this.currentGrammar == null || !this.currentGrammar.getGrammarElements().contains(symbol.getName())) {
                this.reportError(symbol.getLocation(), "Undefined reference to " + symbol.getName());
                return false;
            }
            return true;
        }
        if (!this.currentParser.getGrammars().contains(symbol.getGrammarName())) {
            this.reportError(symbol.getLocation(), "Undefined reference to grammar " + symbol.getGrammarName());
            return false;
        }
        if (!this.currentParser.getGrammar(symbol.getGrammarName()).getGrammarElements().contains(symbol.getName())) {
            this.reportError(symbol.getLocation(), "Undefined reference to " + (this.currentParser.isUnitary() ? symbol.getName() : symbol));
            return false;
        }
        return true;
    }

    private boolean nameIsHost(CopperElementReference symbol) {
        if (this.currentParser.getType() != CopperElementType.EXTENDED_PARSER) {
            return true;
        }
        ExtendedParserBean currentExtendedParser = (ExtendedParserBean)this.currentParser;
        if (symbol.isFQ() && !symbol.getGrammarName().equals(this.currentGrammar.getName()) && !symbol.getGrammarName().equals(currentExtendedParser.getHostGrammar())) {
            if (this.currentGrammar.getType() == CopperElementType.EXTENSION_GRAMMAR) {
                this.reportError(symbol.getLocation(), "Extension grammar " + this.currentGrammar.getDisplayName() + " may not contain a reference to symbol " + this.getDisplayName(symbol) + ", which is defined neither in " + this.currentGrammar.getDisplayName() + ", nor in the parser's host grammar");
                return false;
            }
            this.reportError(symbol.getLocation(), "The host grammar of an extended parser may not contain a reference to external symbol " + this.getDisplayName(symbol));
            return false;
        }
        return true;
    }

    private GrammarElement dereference(CopperElementReference symbol) {
        if (!symbol.isFQ()) {
            return this.currentGrammar.getGrammarElement(symbol.getName());
        }
        return this.currentParser.getGrammar(symbol.getGrammarName()).getGrammarElement(symbol.getName());
    }

    private String getDisplayName(CopperElementReference symbol) {
        GrammarElement dereferencedSymbol = this.dereference(symbol);
        if (dereferencedSymbol == null) {
            return symbol.toString();
        }
        return dereferencedSymbol.getDisplayName();
    }

    private void reportError(Location location, ParserBean parser, Grammar grammar, String message) {
        this.errors.add(new GrammarError(location, parser, grammar, message));
    }

    private void reportError(Location location, String message) {
        this.reportError(location, this.currentParser, this.currentGrammar, message);
    }
}

