/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.copper.compiletime.auxiliary.counterexample;

import edu.umn.cs.melt.copper.compiletime.auxiliary.counterexample.ColoredStringBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class Derivation {
    public String symbol;
    List<Derivation> derivations;
    private static int dotIdCount = 0;
    private int dotId;
    public static final Derivation dot = new Derivation("\u2022", null);

    public Derivation(String symbol) {
        this.symbol = symbol.contains("'") ? symbol.substring(0, symbol.lastIndexOf("'") + 1) : symbol.substring(symbol.lastIndexOf(58) + 1);
        this.derivations = null;
    }

    public Derivation(String symbol, List<Derivation> derivations) {
        this.symbol = symbol.contains("'") ? symbol.substring(0, symbol.lastIndexOf("'") + 1) : symbol.substring(symbol.lastIndexOf(58) + 1);
        this.derivations = derivations;
    }

    public String toDot() {
        this.dotId = ++dotIdCount;
        StringBuilder sb = new StringBuilder();
        sb.append(this.dotId);
        sb.append("[label=\"");
        sb.append(this.symbol);
        sb.append("\"];\n");
        if (this.derivations != null) {
            for (Derivation d : this.derivations) {
                sb.append(d.toDot());
                sb.append(this.dotId);
                sb.append(" -> ");
                sb.append(d.dotId);
                sb.append(";\n");
            }
        }
        return sb.toString();
    }

    public int prettyPrint(ArrayList<ColoredStringBuilder> sbs, int index, int indent, boolean color) {
        ColoredStringBuilder sb = sbs.get(index);
        if (this.derivations != null && color) {
            ColoredStringBuilder.incrementCurrentColor();
        }
        sb.append(" ");
        if (color) {
            sb.appendColored(this.symbol);
        } else {
            sb.append(this.symbol);
        }
        indent += this.symbol.length() + 1;
        if (this.derivations == null) {
            return indent;
        }
        try {
            sbs.get(index + 1);
        }
        catch (IndexOutOfBoundsException e) {
            sbs.add(new ColoredStringBuilder());
        }
        ColoredStringBuilder nextsb = sbs.get(index + 1);
        for (int i = nextsb.length(); i < indent - 1; ++i) {
            nextsb.append(" ");
        }
        if (color) {
            nextsb.appendColored("\u21b3");
        } else {
            nextsb.append("\u21b3");
        }
        for (Derivation d : this.derivations) {
            indent = d.prettyPrint(sbs, index + 1, indent, color);
        }
        for (int i = sb.length(); i < indent; ++i) {
            sb.append(" ");
        }
        if (color) {
            ColoredStringBuilder.decrementCurrentColor();
        }
        return indent;
    }

    public String toString() {
        ArrayList sbs = new ArrayList();
        StringBuilder sb = new StringBuilder(this.symbol);
        if (this.derivations != null) {
            sb.append(" ::= [");
            boolean tail = false;
            for (Derivation d : this.derivations) {
                if (tail) {
                    sb.append(" ");
                } else {
                    tail = true;
                }
                sb.append(d);
            }
            sb.append("]");
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Derivation that = (Derivation)o;
        if (!this.symbol.equals(that.symbol)) {
            return false;
        }
        return Objects.equals(this.derivations, that.derivations);
    }

    public int hashCode() {
        int result = this.symbol.hashCode();
        result = 31 * result + (this.derivations != null ? this.derivations.hashCode() : 0);
        return result;
    }
}

