/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.copper.compiletime.spec.grammarbeans;

import java.io.Serializable;
import java.text.ParseException;
import java.util.regex.Pattern;

public class CopperElementName
implements Comparable<CopperElementName>,
Serializable {
    private static final long serialVersionUID = -5913886908075922957L;
    private static final Pattern validNames = Pattern.compile("[A-Za-z_][A-Za-z0-9_]*");
    private String symbol;

    protected CopperElementName(String name) {
        this.symbol = name;
    }

    public static CopperElementName newName(String name) throws ParseException {
        if (!validNames.matcher(name).matches()) {
            throw new ParseException("Invalid name for a Copper element: " + name, 0);
        }
        return new CopperElementName(name);
    }

    public boolean equals(Object o) {
        return o instanceof CopperElementName && this.symbol.equals(((CopperElementName)o).symbol);
    }

    @Override
    public int compareTo(CopperElementName n) {
        if (n instanceof CopperElementName) {
            return this.symbol.toString().compareTo(n.symbol.toString());
        }
        return -1;
    }

    public int hashCode() {
        return this.symbol.hashCode();
    }

    public String toString() {
        return this.symbol.toString();
    }
}

