/*
 * Decompiled with CFR 0.152.
 */
package common.exceptions;

import common.exceptions.ReifyTraceException;

public class ChildReifyTraceException
extends ReifyTraceException {
    public final String prodName;
    public final String childName;
    public final int numChildren;
    public final int childIndex;

    public ChildReifyTraceException(String prodName, String childName, int numChildren, int childIndex, Throwable t) {
        super("While reifying child '" + childName + "' of production '" + prodName + "'", t);
        this.prodName = prodName;
        this.childName = childName;
        this.numChildren = numChildren;
        this.childIndex = childIndex;
    }

    @Override
    protected final String getASTRepr() {
        int i;
        String result = this.prodName + "(";
        for (i = 0; i < this.childIndex; ++i) {
            result = result + "_, ";
        }
        result = result + ChildReifyTraceException.getASTRepr(this.getCause());
        ++i;
        while (i < this.numChildren) {
            result = result + ", _";
            ++i;
        }
        result = result + ")";
        return result;
    }
}

