/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.copper.compiletime.dumpers;

import edu.umn.cs.melt.copper.compiletime.dumpers.FullParserDumper;
import edu.umn.cs.melt.copper.compiletime.lrdfa.LR0DFA;
import edu.umn.cs.melt.copper.compiletime.lrdfa.LR0ItemSet;
import edu.umn.cs.melt.copper.compiletime.lrdfa.LRLookaheadAndLayoutSets;
import edu.umn.cs.melt.copper.compiletime.lrdfa.TransparentPrefixes;
import edu.umn.cs.melt.copper.compiletime.parsetable.LRParseTable;
import edu.umn.cs.melt.copper.compiletime.parsetable.LRParseTableConflict;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.CopperASTBean;
import edu.umn.cs.melt.copper.compiletime.spec.numeric.ContextSets;
import edu.umn.cs.melt.copper.compiletime.spec.numeric.PSSymbolTable;
import edu.umn.cs.melt.copper.compiletime.spec.numeric.ParserSpec;
import edu.umn.cs.melt.copper.main.CopperDumpType;
import java.io.IOException;
import java.io.PrintStream;
import java.util.BitSet;

public class PlainTextParserDumper
extends FullParserDumper {
    private int textWidth;

    public PlainTextParserDumper(int textWidth, PSSymbolTable symbolTable, ParserSpec spec, ContextSets contextSets, LR0DFA dfa, LRLookaheadAndLayoutSets lookahead, LRParseTable parseTable, TransparentPrefixes prefixes) {
        super(symbolTable, spec, contextSets, dfa, lookahead, parseTable, prefixes);
        this.textWidth = textWidth;
    }

    @Override
    public void dump(CopperDumpType type, PrintStream out) throws IOException, UnsupportedOperationException {
        int statenum;
        if (type != CopperDumpType.PLAIN) {
            throw new UnsupportedOperationException(this.getClass().getName() + " only supports dump type " + (Object)((Object)CopperDumpType.PLAIN));
        }
        int charIndex = 0;
        out.print("===== TERMINALS =====\n");
        int t = this.spec.terminals.nextSetBit(0);
        while (t >= 0) {
            String term = this.generateName((CopperASTBean)this.symbolTable.get(t));
            String termS = "[" + t + "]" + term;
            if (((CopperASTBean)this.symbolTable.get(t)).hasDisplayName()) {
                termS = termS + " (" + ((CopperASTBean)this.symbolTable.get(t)).getDisplayName() + ")";
            }
            if (charIndex + termS.length() + 2 > this.textWidth && charIndex > 0) {
                out.print("\n");
                charIndex = 0;
            }
            out.print("  " + termS);
            charIndex += termS.length() + 2;
            t = this.spec.terminals.nextSetBit(t + 1);
        }
        out.println();
        charIndex = 0;
        out.print("===== NONTERMINALS =====\n");
        int nt = this.spec.nonterminals.nextSetBit(0);
        while (nt >= 0) {
            String nonterm = this.generateName((CopperASTBean)this.symbolTable.get(nt));
            String nontermS = "[" + nt + "]" + nonterm;
            if (((CopperASTBean)this.symbolTable.get(nt)).hasDisplayName()) {
                nontermS = nontermS + " (" + ((CopperASTBean)this.symbolTable.get(nt)).getDisplayName() + ")";
            }
            if (charIndex + nontermS.length() + 2 > this.textWidth && charIndex > 0) {
                out.print("\n");
                charIndex = 0;
            }
            out.print("  " + nontermS);
            charIndex += nontermS.length() + 2;
            nt = this.spec.nonterminals.nextSetBit(nt + 1);
        }
        out.println();
        charIndex = 0;
        out.print("===== PRODUCTIONS =====\n");
        int p = this.spec.productions.nextSetBit(0);
        while (p >= 0) {
            String productionS = "[" + p + "]" + this.spec.productionToString(this.symbolTable, p);
            if (charIndex + productionS.length() + 2 > this.textWidth && charIndex > 0) {
                out.print("\n");
                charIndex = 0;
            }
            out.print("  " + productionS);
            charIndex += productionS.length() + 2;
            p = this.spec.productions.nextSetBit(p + 1);
        }
        out.println();
        out.print("===== LEXICAL PRECEDENCE GRAPH =====\n");
        out.print(this.spec.t.precedences.toEquivalenceClassDot("PrecedenceGraph"));
        out.print("===== DISAMBIGUATION FUNCTIONS/GROUPS =====\n");
        int dg = this.spec.disambiguationFunctions.nextSetBit(0);
        while (dg >= 0) {
            out.print("[" + dg + "] " + this.symbolTable.getDisambiguationFunction(dg).getDisplayName() + " : " + this.spec.df.getMembers(dg));
            if (this.spec.df.hasDisambiguateTo(dg)) {
                out.print(" -> " + this.spec.df.getDisambiguateTo(dg));
            }
            out.print("\n");
            dg = this.spec.disambiguationFunctions.nextSetBit(dg + 1);
        }
        out.print("===== LALR(1) DFA =====\n");
        for (statenum = 1; statenum < this.dfa.size(); ++statenum) {
            LR0ItemSet state = this.dfa.getItemSet(statenum);
            out.print("-------------------\nlalr_state [" + statenum + "]: {\n");
            for (int item = 0; item < state.size(); ++item) {
                int production = state.getProduction(item);
                out.print("    [");
                out.print(((CopperASTBean)this.symbolTable.get(this.spec.pr.getLHS(production))).getDisplayName());
                out.print(" ::=");
                for (int rhs = 0; rhs < this.spec.pr.getRHSLength(production); ++rhs) {
                    if (rhs == state.getPosition(item)) {
                        out.print(" (*)");
                    }
                    out.print(" " + ((CopperASTBean)this.symbolTable.get(this.spec.pr.getRHSSym(production, rhs))).getDisplayName());
                }
                out.print(", {");
                boolean first = true;
                int k = this.lookahead.getLookahead(statenum, item).nextSetBit(0);
                while (k >= 0) {
                    if (first) {
                        first = false;
                    } else {
                        out.print(",");
                    }
                    out.print(((CopperASTBean)this.symbolTable.get(k)).getDisplayName());
                    k = this.lookahead.getLookahead(statenum, item).nextSetBit(k + 1);
                }
                out.print("}]\n");
            }
            out.print("}\n");
            int X = this.dfa.getTransitionLabels(statenum).nextSetBit(0);
            while (X >= 0) {
                out.print("transition on " + ((CopperASTBean)this.symbolTable.get(X)).getDisplayName() + " to state " + this.dfa.getTransition(statenum, X) + "\n");
                X = this.dfa.getTransitionLabels(statenum).nextSetBit(X + 1);
            }
        }
        out.print("===== PARSE TABLE =====\n");
        for (statenum = 1; statenum < this.parseTable.size(); ++statenum) {
            BitSet shiftable = new BitSet(this.parseTable.getValidLA(statenum).length());
            shiftable.or(this.parseTable.getValidLA(statenum));
            shiftable.andNot(this.spec.nonterminals);
            if (shiftable.isEmpty()) continue;
            out.print("From state #" + statenum + "\n");
            int layout = this.lookahead.getLayout(statenum).nextSetBit(0);
            while (layout >= 0) {
                out.print(" [layout term " + layout + "]\n");
                layout = this.lookahead.getLayout(statenum).nextSetBit(layout + 1);
            }
            int prefix = this.prefixes.getPrefixes(statenum).nextSetBit(0);
            while (prefix >= 0) {
                out.print(" [prefix term " + prefix + " -> terms " + this.prefixes.getFollowingTerminals(statenum, prefix) + "]\n");
                prefix = this.prefixes.getPrefixes(statenum).nextSetBit(prefix + 1);
            }
            int t2 = shiftable.nextSetBit(0);
            while (t2 >= 0) {
                byte actionType = this.parseTable.getActionType(statenum, t2);
                if (actionType == 1 || actionType == 2) {
                    out.println(this.parseActionToString(t2, actionType, this.parseTable.getActionParameter(statenum, t2)));
                } else if (actionType == 3) {
                    LRParseTableConflict conflict = this.parseTable.getConflict(this.parseTable.getActionParameter(statenum, t2));
                    if (conflict.shift != -1) {
                        out.println(this.parseActionToString(t2, (byte)1, conflict.shift));
                    }
                    int r = conflict.reduce.nextSetBit(0);
                    while (r >= 0) {
                        out.println(this.parseActionToString(t2, (byte)2, r));
                        r = conflict.reduce.nextSetBit(r + 1);
                    }
                }
                t2 = shiftable.nextSetBit(t2 + 1);
            }
        }
        out.print("===== GOTO TABLE =====\n");
        for (statenum = 1; statenum < this.parseTable.size(); ++statenum) {
            BitSet gotoable = new BitSet(this.parseTable.getValidLA(statenum).length());
            gotoable.or(this.parseTable.getValidLA(statenum));
            gotoable.andNot(this.spec.terminals);
            if (gotoable.isEmpty()) continue;
            out.print("From state #" + statenum + "\n");
            int nt2 = gotoable.nextSetBit(0);
            while (nt2 >= 0) {
                out.println(" [nonterm " + nt2 + "->state " + this.parseTable.getActionParameter(statenum, nt2) + "]");
                nt2 = gotoable.nextSetBit(nt2 + 1);
            }
        }
    }

    private String generateName(CopperASTBean bean) {
        if (this.symbolTable.getParser(this.spec.parser).isUnitary() || !this.spec.grammars.get(this.spec.owners[this.symbolTable.get(bean)])) {
            return bean.getName().toString();
        }
        return this.symbolTable.getGrammar(this.spec.owners[this.symbolTable.get(bean)]).getName() + "$" + bean.getName();
    }

    private String parseActionToString(int t, byte type, int parameter) {
        if (type == 1 && t == this.spec.getEOFTerminal()) {
            return " [term " + t + ":ACCEPT]";
        }
        if (type == 1) {
            return " [term " + t + ":SHIFT(to state " + parameter + ")]";
        }
        return " [term " + t + ":REDUCE(with prod " + parameter + ")]";
    }
}

