/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.copper.runtime.engines.fragment;

import edu.umn.cs.melt.copper.runtime.auxiliary.internal.PrettyPrinter;
import edu.umn.cs.melt.copper.runtime.engines.single.SingleDFAEngine;
import edu.umn.cs.melt.copper.runtime.engines.single.SingleDFAParseStackNode;
import edu.umn.cs.melt.copper.runtime.engines.single.scanner.SingleDFAMatchData;
import edu.umn.cs.melt.copper.runtime.io.InputPosition;
import edu.umn.cs.melt.copper.runtime.io.ScannerBuffer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.LinkedList;

public abstract class ParserFragmentEngine<ROOT, EXCEPT extends Exception>
extends SingleDFAEngine<ROOT, EXCEPT> {
    protected ScannerParams[] fragmentScanners;
    protected ScannerParams markingTerminalScanner;

    public String bitVecToString(int fragmentId, BitSet vec) {
        return PrettyPrinter.bitSetPrettyPrint(vec, this.getSymbolDisplayNamesInclMT(fragmentId), "   ", 1);
    }

    public ArrayList<String> bitVecToRealStringList(int fragmentId, BitSet vec) {
        ArrayList<String> stringList = new ArrayList<String>();
        int i = vec.nextSetBit(0);
        while (i >= 0) {
            stringList.add(this.getSymbolNamesInclMT(fragmentId)[i]);
            i = vec.nextSetBit(i + 1);
        }
        return stringList;
    }

    public ArrayList<String> bitVecToDisplayStringList(int fragmentId, BitSet vec) {
        ArrayList<String> stringList = new ArrayList<String>();
        int i = vec.nextSetBit(0);
        while (i >= 0) {
            stringList.add(this.getSymbolDisplayNamesInclMT(fragmentId)[i]);
            i = vec.nextSetBit(i + 1);
        }
        return stringList;
    }

    @Override
    public abstract int getPARSER_START_STATENUM();

    @Override
    public abstract int getEOF_SYMNUM();

    @Override
    public abstract int[][] getParseTable();

    @Override
    public abstract int[] getProductionLHSs();

    @Override
    public abstract BitSet[] getDisambiguationGroups();

    @Override
    protected abstract Object runSemanticAction(InputPosition var1, Object[] var2, int var3) throws IOException, EXCEPT;

    protected abstract int getFragmentCount();

    protected abstract int stateToFragmentId(int var1);

    protected abstract int getMarkingTerminalOffset();

    protected abstract void reportSyntaxError(int var1) throws EXCEPT;

    protected abstract String[] getSymbolNamesInclMT(int var1);

    protected abstract String[] getSymbolDisplayNamesInclMT(int var1);

    protected abstract int[] getProductionLengths();

    protected abstract int runFragmentDisambiguationAction(int var1, InputPosition var2, SingleDFAMatchData var3) throws IOException, EXCEPT;

    protected abstract Object runFragmentSemanticAction(int var1, InputPosition var2, SingleDFAMatchData var3) throws IOException, EXCEPT;

    protected abstract int transition(int var1, int var2, char var3);

    protected abstract BitSet[] getFragmentRejectSets(int var1);

    protected abstract BitSet[] getFragmentAcceptSets(int var1);

    protected abstract BitSet[] getFragmentPossibleSets(int var1);

    protected abstract int getFragmentTerminalCount(int var1);

    protected abstract int getFragmentStartState(int var1);

    protected abstract BitSet[][] getFragmentPrefixMaps(int var1);

    protected abstract BitSet[] getFragmentLayoutSets(int var1);

    protected abstract BitSet[] getFragmentPrefixSets(int var1);

    protected abstract int getFragmentTerminalUses(int var1, int var2);

    protected abstract BitSet getFragmentShiftableUnion(int var1);

    protected abstract BitSet[] getFragmentShiftableSets(int var1);

    @Override
    public void reportSyntaxError() throws EXCEPT {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getTERMINAL_COUNT() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getGRAMMAR_SYMBOL_COUNT() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getSYMBOL_COUNT() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getPARSER_STATE_COUNT() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getSCANNER_STATE_COUNT() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getDISAMBIG_GROUP_COUNT() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getSCANNER_START_STATENUM() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getEPS_SYMNUM() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String[] getSymbolNames() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String[] getSymbolDisplayNames() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int[] getSymbolNumbers() {
        throw new UnsupportedOperationException();
    }

    @Override
    public BitSet[] getShiftableSets() {
        throw new UnsupportedOperationException();
    }

    @Override
    public BitSet[] getLayoutSets() {
        throw new UnsupportedOperationException();
    }

    @Override
    public BitSet[] getPrefixSets() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int[] getTerminalUses() {
        throw new UnsupportedOperationException();
    }

    @Override
    public BitSet[][] getLayoutMaps() {
        throw new UnsupportedOperationException();
    }

    @Override
    public BitSet[][] getPrefixMaps() {
        throw new UnsupportedOperationException();
    }

    @Override
    public BitSet getShiftableUnion() {
        throw new UnsupportedOperationException();
    }

    @Override
    public BitSet[] getAcceptSets() {
        throw new UnsupportedOperationException();
    }

    @Override
    public BitSet[] getRejectSets() {
        throw new UnsupportedOperationException();
    }

    @Override
    public BitSet[] getPossibleSets() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int[][] getDelta() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int[] getCmap() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int transition(int state, char ch) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int runDisambiguationAction(InputPosition _pos, SingleDFAMatchData match) throws IOException, EXCEPT {
        throw new UnsupportedOperationException();
    }

    @Override
    protected Object runSemanticAction(InputPosition _pos, SingleDFAMatchData _terminal) throws IOException, EXCEPT {
        throw new UnsupportedOperationException();
    }

    protected SingleDFAMatchData parameterizedSimpleScan(InputPosition whence, BitSet shiftable, LinkedList<SingleDFAMatchData> layouts, ScannerParams params) throws IOException {
        if (!this.tokenBuffer.isEmpty()) {
            SingleDFAMatchData tok = (SingleDFAMatchData)this.tokenBuffer.poll();
            tok.precedingPos = whence;
            tok.followingPos = whence;
            this.lastMatchFromQueue = true;
            return tok;
        }
        int currentState = params.startState;
        char symbol = '\u0000';
        BitSet shiftableS = (BitSet)shiftable.clone();
        BitSet present = ParserFragmentEngine.newBitVec(params.terminalCount, new int[0]);
        InputPosition presentPos = whence;
        InputPosition p = InputPosition.copy(whence);
        while (true) {
            BitSet tP = (BitSet)params.possibleSets[currentState].clone();
            tP.and(shiftableS);
            if (p.equals(whence) && shiftableS.get(params.eofSymNum)) {
                tP.set(params.eofSymNum);
            }
            if (tP.isEmpty()) break;
            shiftableS.and(tP);
            BitSet tA = (BitSet)params.acceptSets[currentState].clone();
            tA.and(shiftableS);
            if (!tA.isEmpty()) {
                present = tA;
                presentPos = InputPosition.copy(p);
            } else {
                BitSet tR = (BitSet)params.rejectSets[currentState].clone();
                tR.and(shiftableS);
                if (!tR.isEmpty()) {
                    present.clear();
                    presentPos = whence;
                }
            }
            symbol = this.charBuffer.charAt(p.getPos());
            if (symbol == ScannerBuffer.EOFIndicator) break;
            currentState = this.transition(params.fragmentId, currentState, symbol);
            p = InputPosition.advance(p, symbol);
        }
        if (symbol == ScannerBuffer.EOFIndicator && p.equals(whence) && shiftableS.get(params.eofSymNum)) {
            present.set(params.eofSymNum);
            return new SingleDFAMatchData(present, whence, p, "", layouts);
        }
        return new SingleDFAMatchData(present, whence, presentPos, this.charBuffer.readStringFromBuffer(whence.getPos(), presentPos.getPos()), layouts);
    }

    protected SingleDFAMatchData parameterizedMaybeDisjointScan(InputPosition whence, BitSet shiftable, LinkedList<SingleDFAMatchData> layouts, boolean runDisjoint, ScannerParams params) throws IOException {
        if (!runDisjoint) {
            return this.parameterizedSimpleScan(whence, shiftable, layouts, params);
        }
        return this.parameterizedSimpleScan(whence, params.shiftableUnion, layouts, params);
    }

    protected SingleDFAMatchData parameterizedLayoutScan(boolean runDisjoint, SingleDFAMatchData previousResult, ScannerParams params) throws IOException, EXCEPT {
        SingleDFAMatchData finalMatches;
        BitSet shiftable = params.shiftableSets[this.currentState.statenum];
        InputPosition whence = runDisjoint ? (!previousResult.layouts.isEmpty() ? previousResult.layouts.getLast().followingPos : this.currentState.pos) : this.currentState.pos;
        this.charBuffer.advanceBufferTo(whence.getPos());
        if (!runDisjoint && whence.equals(this.lastPosition) && this.lastAction != 1) {
            if (this.lastMatchFromQueue) {
                this.lastShiftable = shiftable;
                return this.lastMatched;
            }
            if (this.lastMatched != null && !this.functionalDisambiguationUsed) {
                boolean partiallyDisjoint = false;
                BitSet diff = new BitSet();
                diff.or(this.lastMatched.terms);
                diff.andNot(shiftable);
                boolean bl = partiallyDisjoint = !diff.isEmpty();
                if (!partiallyDisjoint) {
                    this.lastShiftable = shiftable;
                    return this.lastMatched;
                }
            }
        }
        this.lastPosition = whence;
        this.lastShiftable = shiftable;
        this.functionalDisambiguationUsed = false;
        this.lastMatchFromQueue = false;
        LinkedList<SingleDFAMatchData> layouts = new LinkedList<SingleDFAMatchData>();
        block5: while (true) {
            finalMatches = this.parameterizedMaybeDisjointScan(whence, shiftable, layouts, runDisjoint, params);
            if (finalMatches.terms.cardinality() > 1) {
                if (finalMatches.terms.get(params.eofSymNum) && finalMatches.lexeme.isEmpty()) {
                    finalMatches.terms.clear();
                    finalMatches.terms.set(params.eofSymNum);
                    finalMatches.firstTerm = params.eofSymNum;
                } else {
                    this.functionalDisambiguationUsed = true;
                    int disambiguatedTerm = this.runFragmentDisambiguationAction(params.fragmentId, this.currentState.pos, finalMatches);
                    if (disambiguatedTerm == -1) {
                        int firstActionIndex = finalMatches.firstTerm;
                        int action = this.getParseTable()[this.currentState.statenum][firstActionIndex];
                        if (ParserFragmentEngine.actionType(action) == 2) {
                            disambiguatedTerm = firstActionIndex;
                        }
                        int j = finalMatches.terms.nextSetBit(firstActionIndex + 1);
                        while (j >= 0) {
                            if (action != this.getParseTable()[this.currentState.statenum][j]) {
                                disambiguatedTerm = -1;
                                break;
                            }
                            j = finalMatches.terms.nextSetBit(j + 1);
                        }
                    }
                    if (disambiguatedTerm == -1) {
                        if (!runDisjoint) {
                            this.reportError(this.formatError("Lexical ambiguity between tokens:\n" + this.bitVecToString(params.fragmentId, finalMatches.terms)));
                            return finalMatches;
                        }
                    } else {
                        finalMatches.terms.clear();
                        finalMatches.terms.set(disambiguatedTerm);
                        finalMatches.firstTerm = disambiguatedTerm;
                    }
                }
                if (finalMatches.terms.cardinality() > 1) {
                    return finalMatches;
                }
            }
            if (finalMatches.terms.isEmpty() || runDisjoint && !shiftable.get(finalMatches.firstTerm)) break;
            int useAs = this.getFragmentTerminalUses(params.fragmentId, finalMatches.firstTerm);
            if (useAs == 0) {
                useAs = this.getFragmentLayoutSets(params.fragmentId)[this.currentState.statenum].get(finalMatches.firstTerm) ? 1 : (params.prefixSets[this.currentState.statenum].get(finalMatches.firstTerm) ? 2 : 4);
            }
            switch (useAs) {
                case 4: {
                    if (!finalMatches.terms.isEmpty()) {
                        this.lastMatched = finalMatches;
                    }
                    return finalMatches;
                }
                case 1: {
                    whence = InputPosition.advance(whence, finalMatches.lexeme.length(), finalMatches.lexeme);
                    if (finalMatches.lexeme.length() == 0) {
                        if (layouts.isEmpty()) {
                            layouts.add(finalMatches);
                        }
                        shiftable = (BitSet)shiftable.clone();
                        shiftable.andNot(this.getFragmentLayoutSets(params.fragmentId)[this.currentState.statenum]);
                        continue block5;
                    }
                    layouts.add(finalMatches);
                    continue block5;
                }
                case 2: {
                    layouts.add(finalMatches);
                    shiftable = params.prefixMaps[this.currentState.statenum][finalMatches.firstTerm];
                    whence = InputPosition.advance(whence, finalMatches.lexeme.length(), finalMatches.lexeme);
                    continue block5;
                }
            }
            this.reportError(this.formatError("Cannot determine whether terminal is layout, prefix, or shiftable --- bug in scanner"));
        }
        if (!finalMatches.terms.isEmpty()) {
            this.lastMatched = finalMatches;
        }
        return finalMatches;
    }

    protected SingleDFAMatchData multiLayoutScan(int fragmentId) throws IOException, EXCEPT {
        SingleDFAMatchData mtScanResult = this.parameterizedLayoutScan(false, null, this.markingTerminalScanner);
        if (mtScanResult.terms.cardinality() > 1) {
            throw new RuntimeException("Ambiguous marking terminal match: " + this.bitVecToDisplayStringList(0, mtScanResult.terms));
        }
        if (!mtScanResult.terms.isEmpty()) {
            return new MarkingTerminalMatchData(mtScanResult);
        }
        ScannerParams extParams = this.fragmentScanners[fragmentId];
        SingleDFAMatchData extScanResult = this.parameterizedLayoutScan(false, null, extParams);
        if (extScanResult.terms.isEmpty()) {
            this.disjointMatch = this.parameterizedLayoutScan(true, extScanResult, extParams);
            for (SingleDFAMatchData layout : extScanResult.layouts) {
                this.runFragmentSemanticAction(fragmentId, layout.precedingPos, layout);
                this.virtualLocation.defaultUpdateAutomatic(layout.lexeme);
            }
            this.parseStack.push(new SingleDFAParseStackNode(this.currentState.statenum, extScanResult.followingPos, null));
            this.currentState = (SingleDFAParseStackNode)this.parseStack.peek();
            this.reportSyntaxError(fragmentId);
            this.parseStack.pop();
            this.currentState = (SingleDFAParseStackNode)this.parseStack.peek();
        } else if (extScanResult.terms.cardinality() > 1) {
            throw new RuntimeException("Ambiguous match: " + this.bitVecToDisplayStringList(fragmentId, extScanResult.terms));
        }
        return extScanResult;
    }

    @Override
    protected void startEngine(InputPosition initialPos) throws IOException, EXCEPT {
        super.startEngine(initialPos);
        this.fragmentScanners = new ScannerParams[this.getFragmentCount()];
        for (int fragmentId = 0; fragmentId < this.getFragmentCount(); ++fragmentId) {
            ScannerParams fragmentScannerParams = new ScannerParams();
            fragmentScannerParams.fragmentId = fragmentId;
            fragmentScannerParams.shiftableSets = this.getFragmentShiftableSets(fragmentId);
            fragmentScannerParams.shiftableUnion = this.getFragmentShiftableUnion(fragmentId);
            fragmentScannerParams.prefixSets = this.getFragmentPrefixSets(fragmentId);
            fragmentScannerParams.prefixMaps = this.getFragmentPrefixMaps(fragmentId);
            fragmentScannerParams.eofSymNum = this.getEOF_SYMNUM();
            fragmentScannerParams.startState = this.getFragmentStartState(fragmentId);
            fragmentScannerParams.terminalCount = this.getFragmentTerminalCount(fragmentId);
            fragmentScannerParams.possibleSets = this.getFragmentPossibleSets(fragmentId);
            fragmentScannerParams.acceptSets = this.getFragmentAcceptSets(fragmentId);
            fragmentScannerParams.rejectSets = this.getFragmentRejectSets(fragmentId);
            this.fragmentScanners[fragmentId] = fragmentScannerParams;
        }
        this.markingTerminalScanner = this.fragmentScanners[0];
    }

    @Override
    protected Object runEngine() throws IOException, EXCEPT {
        while (true) {
            this.currentState = (SingleDFAParseStackNode)this.parseStack.peek();
            int fragmentId = this.stateToFragmentId(this.currentState.statenum);
            if (fragmentId == 0) {
                fragmentId = 1;
            }
            SingleDFAMatchData scanResult = this.multiLayoutScan(fragmentId);
            boolean isMarkingTerminal = scanResult instanceof MarkingTerminalMatchData;
            int symbol = scanResult.firstTerm + (isMarkingTerminal ? this.getMarkingTerminalOffset() : 0);
            int terminalSemanticActionFragmentId = isMarkingTerminal ? 0 : fragmentId;
            int action = this.getParseTable()[this.currentState.statenum][symbol];
            switch (ParserFragmentEngine.actionType(action)) {
                case 3: {
                    for (SingleDFAMatchData layout : scanResult.layouts) {
                        this.runFragmentSemanticAction(terminalSemanticActionFragmentId, layout.precedingPos, layout);
                        this.virtualLocation.defaultUpdateAutomatic(layout.lexeme);
                    }
                    return ((SingleDFAParseStackNode)this.parseStack.peek()).synthAttr;
                }
                case 1: {
                    int nextState = ParserFragmentEngine.actionIndex(action);
                    for (SingleDFAMatchData layout : scanResult.layouts) {
                        this.runFragmentSemanticAction(terminalSemanticActionFragmentId, layout.precedingPos, layout);
                        this.virtualLocation.defaultUpdateAutomatic(layout.lexeme);
                    }
                    Object synthAttr = this.runFragmentSemanticAction(terminalSemanticActionFragmentId, scanResult.precedingPos, scanResult);
                    this.virtualLocation.defaultUpdateAutomatic(scanResult.lexeme);
                    this.parseStack.push(new SingleDFAParseStackNode(nextState, scanResult.followingPos, synthAttr));
                    break;
                }
                case 2: {
                    int production = ParserFragmentEngine.actionIndex(action);
                    int productionLength = ParserFragmentEngine.actionIndex(this.getProductionLengths()[production]);
                    int productionLHS = ParserFragmentEngine.actionIndex(this.getProductionLHSs()[production]);
                    Object[] children = new Object[productionLength];
                    for (int i = productionLength - 1; i >= 0; --i) {
                        children[i] = ((SingleDFAParseStackNode)this.parseStack.pop()).synthAttr;
                    }
                    int gotoState = ParserFragmentEngine.actionIndex(this.getParseTable()[((SingleDFAParseStackNode)this.parseStack.peek()).statenum][productionLHS]);
                    Object synthAttr = this.runSemanticAction(this.currentState.pos, children, production);
                    this.parseStack.push(new SingleDFAParseStackNode(gotoState, this.currentState.pos, synthAttr));
                    break;
                }
                default: {
                    this.disjointMatch = scanResult;
                    this.reportSyntaxError(fragmentId);
                }
            }
            this.lastAction = ParserFragmentEngine.actionType(action);
        }
    }

    protected static class MarkingTerminalMatchData
    extends SingleDFAMatchData {
        public MarkingTerminalMatchData(SingleDFAMatchData data) {
            super(data.terms, data.precedingPos, data.followingPos, data.lexeme, data.layouts);
        }
    }

    private static class ScannerParams {
        public int fragmentId;
        public BitSet[] shiftableSets;
        public BitSet shiftableUnion;
        public BitSet[] prefixSets;
        public BitSet[][] prefixMaps;
        public int eofSymNum;
        public int startState;
        public int terminalCount;
        public BitSet[] possibleSets;
        public BitSet[] acceptSets;
        public BitSet[] rejectSets;

        private ScannerParams() {
        }
    }
}

