/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.copper.compiletime.logging.messages;

import edu.umn.cs.melt.copper.compiletime.auxiliary.SymbolTable;
import edu.umn.cs.melt.copper.compiletime.logging.CompilerLevel;
import edu.umn.cs.melt.copper.compiletime.logging.CompilerLogMessage;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.CopperASTBean;
import edu.umn.cs.melt.copper.compiletime.spec.numeric.PSSymbolTable;
import java.util.BitSet;

public class FollowSpillageMessage
implements CompilerLogMessage {
    private SymbolTable<CopperASTBean> symbolTable;
    private int nonterminal;
    private BitSet diff;

    public FollowSpillageMessage(SymbolTable<CopperASTBean> symbolTable, int nonterminal, BitSet diff) {
        this.symbolTable = symbolTable;
        this.nonterminal = nonterminal;
        this.diff = diff;
    }

    @Override
    public CompilerLevel getLevel() {
        return CompilerLevel.QUIET;
    }

    @Override
    public int getType() {
        return 13;
    }

    @Override
    public boolean isError() {
        return true;
    }

    @Override
    public boolean isFatalError() {
        return false;
    }

    @Override
    public String toString() {
        return "Nonterminal " + this.symbolTable.get(this.nonterminal).getDisplayName() + " has follow spillage of\n" + PSSymbolTable.bitSetPrettyPrint(this.diff, this.symbolTable, "   ", 80);
    }
}

