/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.copper.compiletime.parsetable;

import edu.umn.cs.melt.copper.compiletime.parsetable.LRParseTableConflict;
import java.io.Serializable;
import java.util.BitSet;

public abstract class LRParseTable
implements Serializable {
    private static final long serialVersionUID = 9036145167742108891L;
    public static final byte ERROR = 0;
    public static final byte SHIFT = 1;
    public static final byte GOTO = 1;
    public static final byte ACCEPT = 1;
    public static final byte REDUCE = 2;
    public static final byte CONFLICT = 3;
    protected BitSet[] validLA;
    protected byte[][] actionType;
    protected int[][] actionParameters;
    protected LRParseTableConflict[] conflicts;

    protected LRParseTable(BitSet[] validLA, byte[][] actionType, int[][] actionParameters, LRParseTableConflict[] conflicts) {
        this.validLA = validLA;
        this.actionType = actionType;
        this.actionParameters = actionParameters;
        this.conflicts = conflicts;
    }

    public final BitSet getValidLA(int state) {
        return this.validLA[state];
    }

    public final byte getActionType(int state, int symbol) {
        return this.actionType[state][symbol];
    }

    public final int getActionParameter(int state, int symbol) {
        return this.actionParameters[state][symbol];
    }

    public abstract int getConflictCount();

    public abstract LRParseTableConflict getConflict(int var1);

    public int size() {
        return this.validLA.length;
    }

    public void print() {
        int i;
        int rows = this.actionType.length;
        int cols = this.actionType[0].length;
        int entryWidth = 4;
        System.out.print("State | ");
        for (i = 0; i < cols; ++i) {
            System.out.print(this.fixString(String.valueOf(i), entryWidth) + " ");
        }
        System.out.println();
        for (i = 0; i < rows; ++i) {
            System.out.print(this.fixString(String.valueOf(i), 6) + "| ");
            for (int j = 0; j < cols; ++j) {
                String entry = "";
                switch (this.actionType[i][j]) {
                    case 0: {
                        entry = entry + 'e';
                        break;
                    }
                    case 1: {
                        entry = entry + 's';
                        break;
                    }
                    case 2: {
                        entry = entry + 'r';
                        break;
                    }
                    default: {
                        entry = entry + 'x';
                    }
                }
                entry = entry + this.actionParameters[i][j];
                System.out.print(this.fixString(entry, entryWidth) + " ");
            }
            System.out.println();
        }
    }

    private String fixString(String str, int size) {
        int len = str.length();
        if (len < size) {
            String ret = str;
            for (int i = 0; i < size - len; ++i) {
                ret = ret + " ";
            }
            return ret;
        }
        return str;
    }
}

