/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.copper.compiletime.checkers;

import edu.umn.cs.melt.copper.compiletime.auxiliary.SymbolTable;
import edu.umn.cs.melt.copper.compiletime.logging.CompilerLogger;
import edu.umn.cs.melt.copper.compiletime.logging.messages.DuplicateDisambiguationFunctionMessage;
import edu.umn.cs.melt.copper.compiletime.logging.messages.OverlappingDisambiguationFunctionMessage;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.CopperASTBean;
import edu.umn.cs.melt.copper.compiletime.spec.numeric.ParserSpec;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.Map;

public class DisambiguationFunctionConflictChecker {
    private CompilerLogger logger;
    private SymbolTable<CopperASTBean> symbolTable;
    private ParserSpec spec;

    private DisambiguationFunctionConflictChecker(CompilerLogger logger, SymbolTable<CopperASTBean> symbolTable, ParserSpec spec) {
        this.logger = logger;
        this.symbolTable = symbolTable;
        this.spec = spec;
    }

    public static boolean check(CompilerLogger logger, SymbolTable<CopperASTBean> symbolTable, ParserSpec spec) {
        return new DisambiguationFunctionConflictChecker(logger, symbolTable, spec).checkDisambiguationFunctionConflicts();
    }

    private boolean checkDisambiguationFunctionConflicts() {
        boolean passed = true;
        int numSubsetDisambiguationMembers = 0;
        BitSet subsetDisambiguationMembers = new BitSet();
        Hashtable<BitSet, Integer> subsetDisambiguationFunctions = new Hashtable<BitSet, Integer>();
        Hashtable<BitSet, Integer> regularDisambiguationFunctions = new Hashtable<BitSet, Integer>();
        int i = this.spec.disambiguationFunctions.nextSetBit(0);
        while (i >= 0) {
            BitSet members = this.spec.df.getMembers(i);
            if (this.spec.df.getApplicableToSubsets(i)) {
                subsetDisambiguationMembers.or(members);
                if (subsetDisambiguationMembers.cardinality() != (numSubsetDisambiguationMembers += members.cardinality())) {
                    for (Map.Entry df : subsetDisambiguationFunctions.entrySet()) {
                        if (!((BitSet)df.getKey()).intersects(members)) continue;
                        BitSet intersect = (BitSet)members.clone();
                        intersect.and((BitSet)df.getKey());
                        this.logger.log(new OverlappingDisambiguationFunctionMessage(this.symbolTable, i, (Integer)df.getValue(), intersect));
                        passed = false;
                    }
                }
                subsetDisambiguationFunctions.put(members, i);
            } else {
                if (regularDisambiguationFunctions.containsKey(members)) {
                    this.logger.log(new DuplicateDisambiguationFunctionMessage(this.symbolTable, i, (Integer)regularDisambiguationFunctions.get(members), members));
                    passed = false;
                }
                regularDisambiguationFunctions.put(members, i);
            }
            i = this.spec.disambiguationFunctions.nextSetBit(i + 1);
        }
        return passed;
    }
}

