/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.copper.compiletime.builders;

import edu.umn.cs.melt.copper.compiletime.lrdfa.LR0DFA;
import edu.umn.cs.melt.copper.compiletime.lrdfa.LR0ItemSet;
import edu.umn.cs.melt.copper.compiletime.lrdfa.LRLookaheadSets;
import edu.umn.cs.melt.copper.compiletime.spec.numeric.ContextSets;
import edu.umn.cs.melt.copper.compiletime.spec.numeric.ParserSpec;
import java.util.BitSet;

public class LALRLookaheadSetBuilder {
    private ParserSpec spec;
    private ContextSets contextSets;
    private LR0DFA dfa;

    private LALRLookaheadSetBuilder(ParserSpec spec, ContextSets contextSets, LR0DFA dfa) {
        this.spec = spec;
        this.contextSets = contextSets;
        this.dfa = dfa;
    }

    public static LRLookaheadSets build(ParserSpec spec, ContextSets contextSets, LR0DFA dfa) {
        return new LALRLookaheadSetBuilder(spec, contextSets, dfa).buildLA();
    }

    public LRLookaheadSets buildLA() {
        LRLookaheadSets lookaheadSets = new LRLookaheadSets(this.dfa);
        BitSet activeTransitions = new BitSet();
        BitSet[] fringeStates = new BitSet[2];
        BitSet[][] fringeItems = new BitSet[2][this.dfa.size()];
        fringeStates[0] = new BitSet();
        fringeStates[1] = new BitSet();
        for (int i = 0; i < this.dfa.size(); ++i) {
            fringeItems[0][i] = new BitSet();
            fringeItems[1][i] = new BitSet();
        }
        int lastFringe = 1;
        int currentFringe = 0;
        fringeStates[lastFringe].set(1);
        fringeItems[lastFringe][1].set(0);
        boolean setsChanged = true;
        while (setsChanged) {
            setsChanged = false;
            int I = fringeStates[lastFringe].nextSetBit(0);
            while (I >= 0) {
                BitSet seedItems = fringeItems[lastFringe][I];
                this.computeLookaheadClosure(lookaheadSets, I, seedItems);
                activeTransitions.clear();
                int item = seedItems.nextSetBit(0);
                while (item >= 0) {
                    int X;
                    if (this.dfa.getItemSet(I).getPosition(item) < this.spec.pr.getRHSLength(this.dfa.getItemSet(I).getProduction(item)) && (X = this.spec.pr.getRHSSym(this.dfa.getItemSet(I).getProduction(item), this.dfa.getItemSet(I).getPosition(item))) != this.spec.getEOFTerminal()) {
                        activeTransitions.set(X);
                    }
                    item = seedItems.nextSetBit(item + 1);
                }
                int X = activeTransitions.nextSetBit(0);
                while (X >= 0) {
                    int J = this.dfa.getTransition(I, X);
                    int i = 0;
                    int item2 = this.dfa.getGotoItems(I, X).nextSetBit(0);
                    while (item2 >= 0) {
                        boolean changed;
                        if (seedItems.get(item2) && (changed = ParserSpec.union(lookaheadSets.getLookahead(J, i), lookaheadSets.getLookahead(I, item2)))) {
                            fringeStates[currentFringe].set(J);
                            fringeItems[currentFringe][J].set(i);
                        }
                        ++i;
                        item2 = this.dfa.getGotoItems(I, X).nextSetBit(item2 + 1);
                    }
                    X = activeTransitions.nextSetBit(X + 1);
                }
                seedItems.clear();
                I = fringeStates[lastFringe].nextSetBit(I + 1);
            }
            fringeStates[lastFringe].clear();
            if (fringeStates[currentFringe].isEmpty()) continue;
            currentFringe = currentFringe == 0 ? 1 : 0;
            lastFringe = lastFringe == 0 ? 1 : 0;
            setsChanged = true;
        }
        return lookaheadSets;
    }

    private void computeLookaheadClosure(LRLookaheadSets lookaheadSets, int state, BitSet seedItems) {
        LR0ItemSet stateI = this.dfa.getItemSet(state);
        BitSet fringe1 = new BitSet();
        BitSet fringe2 = new BitSet();
        BitSet combinedFirst = new BitSet();
        fringe1.or(seedItems);
        boolean setsChanged = true;
        while (setsChanged) {
            setsChanged = false;
            int item = fringe1.nextSetBit(0);
            while (item >= 0) {
                if (stateI.getPosition(item) < this.spec.pr.getRHSLength(stateI.getProduction(item))) {
                    combinedFirst.clear();
                    boolean useLookahead = this.computeCombinedFirst(stateI.getProduction(item), stateI.getPosition(item), combinedFirst);
                    for (int i = 0; i < stateI.size(); ++i) {
                        if (this.spec.pr.getLHS(stateI.getProduction(i)) != this.spec.pr.getRHSSym(stateI.getProduction(item), stateI.getPosition(item)) || stateI.getPosition(i) != 0) continue;
                        boolean setChanged = ParserSpec.union(lookaheadSets.getLookahead(state, i), combinedFirst);
                        if (useLookahead) {
                            setChanged |= ParserSpec.union(lookaheadSets.getLookahead(state, i), lookaheadSets.getLookahead(state, item));
                        }
                        if (!setChanged) continue;
                        setsChanged = true;
                        fringe2.set(i);
                    }
                }
                item = fringe1.nextSetBit(item + 1);
            }
            seedItems.or(fringe2);
            fringe1.clear();
            fringe1.or(fringe2);
        }
    }

    private boolean computeCombinedFirst(int production, int position, BitSet combinedFirst) {
        boolean stillNullable = true;
        for (int i = position + 1; i < this.spec.pr.getRHSLength(production) && stillNullable; stillNullable &= this.contextSets.isNullable(this.spec.pr.getRHSSym(production, i)), ++i) {
            combinedFirst.or(this.contextSets.getFirst(this.spec.pr.getRHSSym(production, i)));
        }
        return stillNullable;
    }
}

