/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.copper.compiletime.skins.xml.v0p9;

import edu.umn.cs.melt.copper.compiletime.auxiliary.SetOfCharsSyntax;
import edu.umn.cs.melt.copper.compiletime.auxiliary.xml.SAXWriter;
import edu.umn.cs.melt.copper.compiletime.auxiliary.xml.SAXWriterImpl;
import edu.umn.cs.melt.copper.compiletime.skins.xml.v0p9.XMLSkinElements;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.CharacterSetRegex;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.ChoiceRegex;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.ConcatenationRegex;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.CopperElementName;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.CopperElementReference;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.DisambiguationFunction;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.EmptyStringRegex;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.ExtendedParserBean;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.ExtensionGrammar;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.Grammar;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.GrammarElement;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.KleeneStarRegex;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.MacroHoleRegex;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.NonTerminal;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.OperatorAssociativity;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.OperatorClass;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.ParserAttribute;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.ParserBean;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.Production;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.Regex;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.Terminal;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.TerminalClass;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.visitors.CopperASTBeanVisitor;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.visitors.RegexBeanVisitor;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.visitors.RegexSimplifier;
import java.io.PrintStream;
import java.util.TreeSet;
import org.xml.sax.SAXException;

public class ParserSpecXMLPrinter
implements CopperASTBeanVisitor<Boolean, SAXException>,
RegexBeanVisitor<Boolean, SAXException> {
    private ParserBean currentParser;
    private Grammar currentGrammar;
    private RegexSimplifier regexSimplifier;
    private SAXWriter out;

    public ParserSpecXMLPrinter(PrintStream out) {
        this(out, "\t");
    }

    public ParserSpecXMLPrinter(PrintStream out, String ppIndentation) {
        this.out = new SAXWriterImpl(out, ppIndentation, false);
        this.regexSimplifier = new RegexSimplifier();
        this.currentParser = null;
        this.currentGrammar = null;
    }

    @Override
    public Boolean visitDisambiguationFunction(DisambiguationFunction bean) throws SAXException {
        this.startElement(XMLSkinElements.Type.DISAMBIGUATION_FUNCTION_ELEMENT, "id", bean.getName().toString());
        if (bean.hasDisplayName()) {
            this.startElement(XMLSkinElements.Type.PP_ELEMENT, new String[0]);
            this.out.string(bean.getDisplayName());
            this.endElement(XMLSkinElements.Type.PP_ELEMENT);
        }
        this.startElement(XMLSkinElements.Type.MEMBERS_ELEMENT, new String[0]);
        TreeSet<CopperElementReference> members = new TreeSet<CopperElementReference>(bean.getMembers());
        for (CopperElementReference member : members) {
            this.writeGrammarElementRef(member);
        }
        this.endElement(XMLSkinElements.Type.MEMBERS_ELEMENT);
        if (bean.getDisambiguateTo() != null) {
            this.startElement(XMLSkinElements.Type.DISAMBIGUATE_TO_ELEMENT, new String[0]);
            this.writeGrammarElementRef(bean.getDisambiguateTo());
            this.endElement(XMLSkinElements.Type.DISAMBIGUATE_TO_ELEMENT);
        } else {
            this.startElement(XMLSkinElements.Type.CODE_ELEMENT, new String[0]);
            this.out.verbatimString(bean.getCode());
            this.endElement(XMLSkinElements.Type.CODE_ELEMENT);
        }
        this.endElement(XMLSkinElements.Type.DISAMBIGUATION_FUNCTION_ELEMENT);
        return false;
    }

    @Override
    public Boolean visitGrammar(Grammar bean) throws SAXException {
        this.currentGrammar = bean;
        this.startElement(XMLSkinElements.Type.GRAMMAR_ELEMENT, "id", bean.getName().toString());
        if (bean.hasDisplayName()) {
            this.startElement(XMLSkinElements.Type.PP_ELEMENT, new String[0]);
            this.out.string(bean.getDisplayName());
            this.endElement(XMLSkinElements.Type.PP_ELEMENT);
        }
        if (bean.getGrammarLayout() != null) {
            this.startElement(XMLSkinElements.Type.LAYOUT_ELEMENT, new String[0]);
            for (CopperElementReference layout : bean.getGrammarLayout()) {
                this.writeGrammarElementRef(layout);
            }
            this.endElement(XMLSkinElements.Type.LAYOUT_ELEMENT);
        }
        this.startElement(XMLSkinElements.Type.DECLARATIONS_ELEMENT, new String[0]);
        boolean hasError = false;
        TreeSet<CopperElementName> elements = new TreeSet<CopperElementName>(bean.getGrammarElements());
        for (CopperElementName n : elements) {
            hasError |= bean.getGrammarElement(n).acceptVisitor(this).booleanValue();
        }
        this.endElement(XMLSkinElements.Type.DECLARATIONS_ELEMENT);
        this.endElement(XMLSkinElements.Type.GRAMMAR_ELEMENT);
        return hasError;
    }

    @Override
    public Boolean visitExtensionGrammar(ExtensionGrammar bean) throws SAXException {
        throw new SAXException("Extension grammars not yet supported in XML");
    }

    @Override
    public Boolean visitNonTerminal(NonTerminal bean) throws SAXException {
        this.startElement(XMLSkinElements.Type.NONTERMINAL_ELEMENT, "id", bean.getName().toString());
        if (bean.hasDisplayName()) {
            this.startElement(XMLSkinElements.Type.PP_ELEMENT, new String[0]);
            this.out.string(bean.getDisplayName());
            this.endElement(XMLSkinElements.Type.PP_ELEMENT);
        }
        if (bean.getReturnType() != null && !bean.getReturnType().isEmpty()) {
            this.startElement(XMLSkinElements.Type.TYPE_ELEMENT, new String[0]);
            this.out.verbatimString(bean.getReturnType());
            this.endElement(XMLSkinElements.Type.TYPE_ELEMENT);
        }
        this.endElement(XMLSkinElements.Type.NONTERMINAL_ELEMENT);
        return false;
    }

    @Override
    public Boolean visitParserAttribute(ParserAttribute bean) throws SAXException {
        this.startElement(XMLSkinElements.Type.PARSER_ATTRIBUTE_ELEMENT, "id", bean.getName().toString());
        if (bean.hasDisplayName()) {
            this.startElement(XMLSkinElements.Type.PP_ELEMENT, new String[0]);
            this.out.string(bean.getDisplayName());
            this.endElement(XMLSkinElements.Type.PP_ELEMENT);
        }
        this.startElement(XMLSkinElements.Type.TYPE_ELEMENT, new String[0]);
        this.out.verbatimString(bean.getAttributeType());
        this.endElement(XMLSkinElements.Type.TYPE_ELEMENT);
        this.startElement(XMLSkinElements.Type.CODE_ELEMENT, new String[0]);
        this.out.verbatimString(bean.getCode());
        this.endElement(XMLSkinElements.Type.CODE_ELEMENT);
        this.endElement(XMLSkinElements.Type.PARSER_ATTRIBUTE_ELEMENT);
        return false;
    }

    @Override
    public Boolean visitParserBean(ParserBean bean) throws SAXException {
        this.currentParser = bean;
        this.out.startDocument();
        this.startElement(XMLSkinElements.Type.COPPER_SPEC_ELEMENT, "xmlns", "http://melt.cs.umn.edu/copper/xmlns/skins/xml/0.9");
        this.startElement(XMLSkinElements.Type.PARSER_ELEMENT, "id", bean.getName().toString(), "isUnitary", bean.isUnitary() ? "true" : "false");
        if (bean.hasDisplayName()) {
            this.startElement(XMLSkinElements.Type.PP_ELEMENT, new String[0]);
            this.out.string(bean.getDisplayName());
            this.endElement(XMLSkinElements.Type.PP_ELEMENT);
        }
        this.startElement(XMLSkinElements.Type.GRAMMARS_ELEMENT, new String[0]);
        TreeSet<CopperElementName> grammars = new TreeSet<CopperElementName>(bean.getGrammars());
        for (CopperElementName grammar : grammars) {
            this.writeFullElement(XMLSkinElements.Type.GRAMMAR_REF_ELEMENT, "id", grammar.toString());
        }
        this.endElement(XMLSkinElements.Type.GRAMMARS_ELEMENT);
        this.startElement(XMLSkinElements.Type.START_SYMBOL_ELEMENT, new String[0]);
        this.writeGrammarElementRef(bean.getStartSymbol());
        this.endElement(XMLSkinElements.Type.START_SYMBOL_ELEMENT);
        if (bean.getStartLayout() != null) {
            this.startElement(XMLSkinElements.Type.START_LAYOUT_ELEMENT, new String[0]);
            for (CopperElementReference layout : bean.getStartLayout()) {
                this.writeGrammarElementRef(layout);
            }
            this.endElement(XMLSkinElements.Type.START_LAYOUT_ELEMENT);
        }
        if (bean.getPackageDecl() != null && !bean.getPackageDecl().isEmpty()) {
            this.startElement(XMLSkinElements.Type.PACKAGE_ELEMENT, new String[0]);
            this.out.string(bean.getPackageDecl());
            this.endElement(XMLSkinElements.Type.PACKAGE_ELEMENT);
        }
        if (bean.getClassName() != null && !bean.getClassName().isEmpty()) {
            this.startElement(XMLSkinElements.Type.CLASS_NAME_ELEMENT, new String[0]);
            this.out.string(bean.getClassName());
            this.endElement(XMLSkinElements.Type.CLASS_NAME_ELEMENT);
        }
        if (bean.getParserClassAuxCode() != null && !bean.getParserClassAuxCode().isEmpty()) {
            this.startElement(XMLSkinElements.Type.CLASS_AUXILIARY_CODE_ELEMENT, new String[0]);
            this.startElement(XMLSkinElements.Type.CODE_ELEMENT, new String[0]);
            this.out.verbatimString(bean.getParserClassAuxCode());
            this.endElement(XMLSkinElements.Type.CODE_ELEMENT);
            this.endElement(XMLSkinElements.Type.CLASS_AUXILIARY_CODE_ELEMENT);
        }
        if (bean.getDefaultProductionCode() != null && !bean.getDefaultProductionCode().isEmpty()) {
            this.startElement(XMLSkinElements.Type.DEFAULT_PRODUCTION_CODE_ELEMENT, new String[0]);
            this.startElement(XMLSkinElements.Type.CODE_ELEMENT, new String[0]);
            this.out.verbatimString(bean.getDefaultProductionCode());
            this.endElement(XMLSkinElements.Type.CODE_ELEMENT);
            this.endElement(XMLSkinElements.Type.DEFAULT_PRODUCTION_CODE_ELEMENT);
        }
        if (bean.getDefaultTerminalCode() != null && !bean.getDefaultTerminalCode().isEmpty()) {
            this.startElement(XMLSkinElements.Type.DEFAULT_TERMINAL_CODE_ELEMENT, new String[0]);
            this.startElement(XMLSkinElements.Type.CODE_ELEMENT, new String[0]);
            this.out.verbatimString(bean.getDefaultTerminalCode());
            this.endElement(XMLSkinElements.Type.CODE_ELEMENT);
            this.endElement(XMLSkinElements.Type.DEFAULT_TERMINAL_CODE_ELEMENT);
        }
        if (bean.getParserInitCode() != null && !bean.getParserInitCode().isEmpty()) {
            this.startElement(XMLSkinElements.Type.PARSER_INIT_CODE_ELEMENT, new String[0]);
            this.startElement(XMLSkinElements.Type.CODE_ELEMENT, new String[0]);
            this.out.verbatimString(bean.getParserInitCode());
            this.endElement(XMLSkinElements.Type.CODE_ELEMENT);
            this.endElement(XMLSkinElements.Type.PARSER_INIT_CODE_ELEMENT);
        }
        if (bean.getPostParseCode() != null && !bean.getPostParseCode().isEmpty()) {
            this.startElement(XMLSkinElements.Type.POST_PARSE_CODE_ELEMENT, new String[0]);
            this.startElement(XMLSkinElements.Type.CODE_ELEMENT, new String[0]);
            this.out.verbatimString(bean.getPostParseCode());
            this.endElement(XMLSkinElements.Type.CODE_ELEMENT);
            this.endElement(XMLSkinElements.Type.POST_PARSE_CODE_ELEMENT);
        }
        if (bean.getPreambleCode() != null && !bean.getPreambleCode().isEmpty()) {
            this.startElement(XMLSkinElements.Type.PREAMBLE_ELEMENT, new String[0]);
            this.startElement(XMLSkinElements.Type.CODE_ELEMENT, new String[0]);
            this.out.verbatimString(bean.getPreambleCode());
            this.endElement(XMLSkinElements.Type.CODE_ELEMENT);
            this.endElement(XMLSkinElements.Type.PREAMBLE_ELEMENT);
        }
        if (bean.getSemanticActionAuxCode() != null && !bean.getSemanticActionAuxCode().isEmpty()) {
            this.startElement(XMLSkinElements.Type.SEMANTIC_ACTION_AUXILIARY_CODE_ELEMENT, new String[0]);
            this.startElement(XMLSkinElements.Type.CODE_ELEMENT, new String[0]);
            this.out.verbatimString(bean.getSemanticActionAuxCode());
            this.endElement(XMLSkinElements.Type.CODE_ELEMENT);
            this.endElement(XMLSkinElements.Type.SEMANTIC_ACTION_AUXILIARY_CODE_ELEMENT);
        }
        this.endElement(XMLSkinElements.Type.PARSER_ELEMENT);
        boolean hasError = false;
        for (CopperElementName n : grammars) {
            hasError |= bean.getGrammar(n).acceptVisitor(this).booleanValue();
        }
        this.endElement(XMLSkinElements.Type.COPPER_SPEC_ELEMENT);
        this.currentParser = null;
        return hasError;
    }

    @Override
    public Boolean visitExtendedParserBean(ExtendedParserBean bean) throws SAXException {
        return this.visitParserBean(bean);
    }

    @Override
    public Boolean visitProduction(Production bean) throws SAXException {
        this.startElement(XMLSkinElements.Type.PRODUCTION_ELEMENT, "id", bean.getName().toString());
        if (bean.hasDisplayName()) {
            this.startElement(XMLSkinElements.Type.PP_ELEMENT, new String[0]);
            this.out.string(bean.getDisplayName());
            this.endElement(XMLSkinElements.Type.PP_ELEMENT);
        }
        if (bean.getPrecedenceClass() != null) {
            this.startElement(XMLSkinElements.Type.CLASS_ELEMENT, new String[0]);
            this.writeGrammarElementRef(bean.getPrecedenceClass());
            this.endElement(XMLSkinElements.Type.CLASS_ELEMENT);
        }
        if (bean.getPrecedence() != null && bean.getPrecedence() != -1) {
            this.startElement(XMLSkinElements.Type.PRECEDENCE_ELEMENT, new String[0]);
            this.out.string(String.valueOf(bean.getPrecedence()));
            this.endElement(XMLSkinElements.Type.PRECEDENCE_ELEMENT);
        }
        if (bean.getCode() != null && !bean.getCode().isEmpty()) {
            this.startElement(XMLSkinElements.Type.CODE_ELEMENT, new String[0]);
            this.out.verbatimString(bean.getCode());
            this.endElement(XMLSkinElements.Type.CODE_ELEMENT);
        }
        this.startElement(XMLSkinElements.Type.LHS_ELEMENT, new String[0]);
        this.writeGrammarElementRef(bean.getLhs());
        this.endElement(XMLSkinElements.Type.LHS_ELEMENT);
        this.startElement(XMLSkinElements.Type.RHS_ELEMENT, new String[0]);
        for (int i = 0; i < bean.getRhs().size(); ++i) {
            this.writeGrammarElementRef(bean.getRhs().get(i), bean.getRhsVarNames().get(i), false);
        }
        this.endElement(XMLSkinElements.Type.RHS_ELEMENT);
        if (bean.getLayout() != null) {
            this.startElement(XMLSkinElements.Type.LAYOUT_ELEMENT, new String[0]);
            for (CopperElementReference layout : bean.getLayout()) {
                this.writeGrammarElementRef(layout);
            }
            this.endElement(XMLSkinElements.Type.LAYOUT_ELEMENT);
        }
        if (bean.getOperator() != null) {
            this.startElement(XMLSkinElements.Type.OPERATOR_ELEMENT, new String[0]);
            this.writeGrammarElementRef(bean.getOperator());
            this.endElement(XMLSkinElements.Type.OPERATOR_ELEMENT);
        }
        this.endElement(XMLSkinElements.Type.PRODUCTION_ELEMENT);
        return false;
    }

    @Override
    public Boolean visitTerminal(Terminal bean) throws SAXException {
        TreeSet<CopperElementReference> members;
        this.startElement(XMLSkinElements.Type.TERMINAL_ELEMENT, "id", bean.getName().toString());
        if (bean.hasDisplayName()) {
            this.startElement(XMLSkinElements.Type.PP_ELEMENT, new String[0]);
            this.out.string(bean.getDisplayName());
            this.endElement(XMLSkinElements.Type.PP_ELEMENT);
        }
        this.startElement(XMLSkinElements.Type.REGEX_ELEMENT, new String[0]);
        bean.getRegex().acceptVisitor(this.regexSimplifier).acceptVisitor(this);
        this.endElement(XMLSkinElements.Type.REGEX_ELEMENT);
        if (bean.getOperatorClass() != null || bean.getOperatorPrecedence() != null && bean.getOperatorPrecedence() != -1 || bean.getOperatorAssociativity() != null && bean.getOperatorAssociativity() != OperatorAssociativity.NONE) {
            this.startElement(XMLSkinElements.Type.OPERATOR_ELEMENT, new String[0]);
            if (bean.getOperatorClass() != null) {
                this.startElement(XMLSkinElements.Type.CLASS_ELEMENT, new String[0]);
                this.writeGrammarElementRef(bean.getOperatorClass());
                this.endElement(XMLSkinElements.Type.CLASS_ELEMENT);
            }
            if (bean.getOperatorPrecedence() != null && bean.getOperatorPrecedence() != -1) {
                this.startElement(XMLSkinElements.Type.PRECEDENCE_ELEMENT, new String[0]);
                this.out.string(String.valueOf(bean.getOperatorPrecedence()));
                this.endElement(XMLSkinElements.Type.PRECEDENCE_ELEMENT);
            }
            if (bean.getOperatorAssociativity() != null && bean.getOperatorAssociativity() != OperatorAssociativity.NONE) {
                switch (bean.getOperatorAssociativity()) {
                    case LEFT: {
                        this.writeFullElement(XMLSkinElements.Type.LEFT_ASSOCIATIVE_ELEMENT, new String[0]);
                        break;
                    }
                    case NONASSOC: {
                        this.writeFullElement(XMLSkinElements.Type.NON_ASSOCIATIVE_ELEMENT, new String[0]);
                        break;
                    }
                    case RIGHT: {
                        this.writeFullElement(XMLSkinElements.Type.RIGHT_ASSOCIATIVE_ELEMENT, new String[0]);
                        break;
                    }
                }
            }
            this.endElement(XMLSkinElements.Type.OPERATOR_ELEMENT);
        }
        if (bean.getReturnType() != null) {
            this.startElement(XMLSkinElements.Type.TYPE_ELEMENT, new String[0]);
            this.out.string(bean.getReturnType());
            this.endElement(XMLSkinElements.Type.TYPE_ELEMENT);
        }
        if (bean.getCode() != null && !bean.getCode().isEmpty()) {
            this.startElement(XMLSkinElements.Type.CODE_ELEMENT, new String[0]);
            this.out.verbatimString(bean.getCode());
            this.endElement(XMLSkinElements.Type.CODE_ELEMENT);
        }
        if (bean.getTerminalClasses() != null) {
            this.startElement(XMLSkinElements.Type.IN_CLASSES_ELEMENT, new String[0]);
            members = new TreeSet<CopperElementReference>(bean.getTerminalClasses());
            for (CopperElementReference member : members) {
                this.writeGrammarElementRef(member);
            }
            this.endElement(XMLSkinElements.Type.IN_CLASSES_ELEMENT);
        }
        if (bean.getPrefix() != null) {
            this.startElement(XMLSkinElements.Type.PREFIX_ELEMENT, new String[0]);
            this.writeGrammarElementRef(bean.getPrefix());
            this.endElement(XMLSkinElements.Type.PREFIX_ELEMENT);
        }
        if (bean.getSubmitList() != null) {
            this.startElement(XMLSkinElements.Type.SUBMITS_ELEMENT, new String[0]);
            members = new TreeSet<CopperElementReference>(bean.getSubmitList());
            for (CopperElementReference member : members) {
                this.writeGrammarElementRef(member);
            }
            this.endElement(XMLSkinElements.Type.SUBMITS_ELEMENT);
        }
        if (bean.getDominateList() != null) {
            this.startElement(XMLSkinElements.Type.DOMINATES_ELEMENT, new String[0]);
            members = new TreeSet<CopperElementReference>(bean.getDominateList());
            for (CopperElementReference member : members) {
                this.writeGrammarElementRef(member);
            }
            this.endElement(XMLSkinElements.Type.DOMINATES_ELEMENT);
        }
        this.endElement(XMLSkinElements.Type.TERMINAL_ELEMENT);
        return false;
    }

    @Override
    public Boolean visitTerminalClass(TerminalClass bean) throws SAXException {
        this.startElement(XMLSkinElements.Type.TERMINAL_CLASS_ELEMENT, "id", bean.getName().toString());
        if (bean.hasDisplayName()) {
            this.startElement(XMLSkinElements.Type.PP_ELEMENT, new String[0]);
            this.out.string(bean.getDisplayName());
            this.endElement(XMLSkinElements.Type.PP_ELEMENT);
        }
        if (bean.getMembers() != null && !bean.getMembers().isEmpty()) {
            this.startElement(XMLSkinElements.Type.MEMBERS_ELEMENT, new String[0]);
            TreeSet<CopperElementReference> members = new TreeSet<CopperElementReference>(bean.getMembers());
            for (CopperElementReference member : members) {
                this.writeGrammarElementRef(member);
            }
            this.endElement(XMLSkinElements.Type.MEMBERS_ELEMENT);
        }
        this.endElement(XMLSkinElements.Type.TERMINAL_CLASS_ELEMENT);
        return false;
    }

    @Override
    public Boolean visitOperatorClass(OperatorClass bean) throws SAXException {
        this.startElement(XMLSkinElements.Type.OPERATOR_CLASS_ELEMENT, "id", bean.getName().toString());
        if (bean.hasDisplayName()) {
            this.startElement(XMLSkinElements.Type.PP_ELEMENT, new String[0]);
            this.out.string(bean.getDisplayName());
            this.endElement(XMLSkinElements.Type.PP_ELEMENT);
        }
        this.endElement(XMLSkinElements.Type.OPERATOR_CLASS_ELEMENT);
        return false;
    }

    @Override
    public Boolean visitChoiceRegex(ChoiceRegex bean) throws SAXException {
        this.startElement(XMLSkinElements.Type.CHOICE_ELEMENT, new String[0]);
        for (Regex subexp : bean.getSubexps()) {
            subexp.acceptVisitor(this);
        }
        this.endElement(XMLSkinElements.Type.CHOICE_ELEMENT);
        return false;
    }

    @Override
    public Boolean visitConcatenationRegex(ConcatenationRegex bean) throws SAXException {
        this.startElement(XMLSkinElements.Type.CONCATENATION_ELEMENT, new String[0]);
        for (Regex subexp : bean.getSubexps()) {
            subexp.acceptVisitor(this);
        }
        this.endElement(XMLSkinElements.Type.CONCATENATION_ELEMENT);
        return false;
    }

    @Override
    public Boolean visitKleeneStarRegex(KleeneStarRegex bean) throws SAXException {
        this.startElement(XMLSkinElements.Type.KLEENE_STAR_ELEMENT, new String[0]);
        bean.getSubexp().acceptVisitor(this);
        this.endElement(XMLSkinElements.Type.KLEENE_STAR_ELEMENT);
        return false;
    }

    @Override
    public Boolean visitEmptyStringRegex(EmptyStringRegex bean) throws SAXException {
        this.writeFullElement(XMLSkinElements.Type.EMPTY_STRING_REGEX_ELEMENT, new String[0]);
        return false;
    }

    @Override
    public Boolean visitCharacterSetRegex(CharacterSetRegex bean, SetOfCharsSyntax chars) throws SAXException {
        SetOfCharsSyntax modChars;
        if (chars.getMembers()[0][0] == '\u0000' || chars.getMembers()[chars.getMembers().length - 1][1] == '\uffff') {
            this.startElement(XMLSkinElements.Type.CHARACTER_SET_ELEMENT, "invert", "true");
            modChars = chars.invert();
        } else {
            this.startElement(XMLSkinElements.Type.CHARACTER_SET_ELEMENT, new String[0]);
            modChars = chars;
        }
        for (int i = 0; i < modChars.getMembers().length; ++i) {
            if (modChars.getMembers()[i][0] == modChars.getMembers()[i][1]) {
                this.writeFullElement(XMLSkinElements.Type.SINGLE_CHARACTER_ELEMENT, "char", String.valueOf(modChars.getMembers()[i][0]));
                continue;
            }
            this.writeFullElement(XMLSkinElements.Type.CHARACTER_RANGE_ELEMENT, "lower", String.valueOf(modChars.getMembers()[i][0]), "upper", String.valueOf(modChars.getMembers()[i][1]));
        }
        this.endElement(XMLSkinElements.Type.CHARACTER_SET_ELEMENT);
        return false;
    }

    @Override
    public Boolean visitMacroHoleRegex(MacroHoleRegex bean) throws SAXException {
        this.writeRegexMacroRef(bean.getMacroName());
        return false;
    }

    private void startElement(XMLSkinElements.Type element, String ... attrs) throws SAXException {
        this.out.startElement(element.getNamespace(), element.getName(), element.getName(), false, attrs);
    }

    private void endElement(XMLSkinElements.Type element) throws SAXException {
        this.out.endElement(element.getNamespace(), element.getName(), element.getName());
    }

    private void writeFullElement(XMLSkinElements.Type element, String ... attrs) throws SAXException {
        this.out.writeFullElement(element.getNamespace(), element.getName(), element.getName(), false, attrs);
    }

    private void writeGrammarElementRef(CopperElementReference ref) throws SAXException {
        this.writeGrammarElementRef(ref, null, false);
    }

    private void writeRegexMacroRef(CopperElementReference ref) throws SAXException {
        this.writeGrammarElementRef(ref, null, true);
    }

    private void writeGrammarElementRef(CopperElementReference ref, String name, boolean isMacro) throws SAXException {
        XMLSkinElements.Type refType;
        boolean writeGrammarAttr;
        boolean bl = writeGrammarAttr = this.currentGrammar == null || ref.getGrammarName() != null && !ref.getGrammarName().equals(this.currentGrammar.getName());
        if (isMacro) {
            refType = XMLSkinElements.Type.MACRO_REF_ELEMENT;
        } else {
            switch (this.dereference(ref).getType()) {
                case EXTENSION_GRAMMAR: 
                case GRAMMAR: {
                    refType = XMLSkinElements.Type.GRAMMAR_REF_ELEMENT;
                    break;
                }
                case NON_TERMINAL: {
                    refType = XMLSkinElements.Type.NONTERMINAL_REF_ELEMENT;
                    break;
                }
                case OPERATOR_CLASS: {
                    refType = XMLSkinElements.Type.OPERATOR_CLASS_REF_ELEMENT;
                    break;
                }
                case TERMINAL: {
                    refType = XMLSkinElements.Type.TERMINAL_REF_ELEMENT;
                    break;
                }
                case TERMINAL_CLASS: {
                    refType = XMLSkinElements.Type.TERMINAL_CLASS_REF_ELEMENT;
                    break;
                }
                default: {
                    return;
                }
            }
        }
        if (writeGrammarAttr) {
            if (name != null) {
                this.writeFullElement(refType, "grammar", ref.getGrammarName().toString(), "id", ref.getName().toString(), "name", name);
            } else {
                this.writeFullElement(refType, "grammar", ref.getGrammarName().toString(), "id", ref.getName().toString());
            }
        } else if (name != null) {
            this.writeFullElement(refType, "id", ref.getName().toString(), "name", name);
        } else {
            this.writeFullElement(refType, "id", ref.getName().toString());
        }
    }

    private GrammarElement dereference(CopperElementReference symbol) {
        if (!symbol.isFQ()) {
            return this.currentGrammar.getGrammarElement(symbol.getName());
        }
        return this.currentParser.getGrammar(symbol.getGrammarName()).getGrammarElement(symbol.getName());
    }
}

