/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.copper.legacy.compiletime.logging;

import edu.umn.cs.melt.copper.legacy.compiletime.abstractsyntax.grammar.GrammarSource;
import edu.umn.cs.melt.copper.legacy.compiletime.abstractsyntax.grammar.NonTerminal;
import edu.umn.cs.melt.copper.legacy.compiletime.abstractsyntax.grammar.Production;
import edu.umn.cs.melt.copper.legacy.compiletime.logging.CompilerLogMessageSort;
import edu.umn.cs.melt.copper.legacy.compiletime.logging.CompilerLogger;
import edu.umn.cs.melt.copper.legacy.compiletime.parsetable.ReadOnlyParseTable;

public class FinalReporter {
    private CompilerLogger logger;
    private GrammarSource grammar;
    private ReadOnlyParseTable parseTable;
    private int numTerminals;
    private int numNonTerminals;
    private int numProductions;
    private int numDisambigGroups;
    private int numScannerStates;

    public FinalReporter(CompilerLogger logger, GrammarSource grammar, ReadOnlyParseTable parseTable, int scannerStateCount) {
        this.logger = logger;
        this.grammar = grammar;
        this.parseTable = parseTable;
        this.numScannerStates = scannerStateCount;
    }

    public void logFinalReport() {
        if (!this.logger.isLoggable(CompilerLogMessageSort.FINAL_REPORT)) {
            return;
        }
        this.numTerminals = this.grammar.tSize();
        this.numNonTerminals = this.grammar.ntSize();
        this.numProductions = 0;
        for (NonTerminal nt : this.grammar.getNT()) {
            if (!this.grammar.pContains(nt)) continue;
            for (Production p : this.grammar.getP(nt)) {
                ++this.numProductions;
            }
        }
        this.numDisambigGroups = this.grammar.disambiguationGroupSize();
        this.logger.logMessage(CompilerLogMessageSort.FINAL_REPORT, null, "===== FINAL REPORT =====\n");
        this.logger.logMessage(CompilerLogMessageSort.FINAL_REPORT, null, this.numTerminals + " terminal" + (this.numTerminals == 1 ? "" : "s") + ", " + this.numNonTerminals + " nonterminal" + (this.numNonTerminals == 1 ? "" : "s") + ",\n" + this.numProductions + " productions, and " + this.numDisambigGroups + " disambiguation function" + (this.numDisambigGroups == 1 ? "" : "s") + " declared,\n");
        this.logger.logMessage(CompilerLogMessageSort.FINAL_REPORT, null, "producing " + (this.parseTable.getLastState() + 1) + " unique parse state" + (this.parseTable.getLastState() == 0 ? "" : "s") + "\n");
        this.logger.logMessage(CompilerLogMessageSort.FINAL_REPORT, null, "and " + this.numScannerStates + " unique scanner states.\n");
        this.logger.logMessage(CompilerLogMessageSort.FINAL_REPORT, null, this.grammar.getUselessNonterminalCount() + " useless nonterminal" + (this.grammar.getUselessNonterminalCount() == 1 ? "" : "s") + ".\n");
        if (this.logger.getParseTableConflictCounter() == 0) {
            this.logger.logMessage(CompilerLogMessageSort.FINAL_REPORT, null, "No parse table conflicts detected.\n");
        } else {
            this.logger.logMessage(CompilerLogMessageSort.FINAL_REPORT, null, this.logger.getParseTableConflictCounter() + " parse table conflict" + (this.logger.getParseTableConflictCounter() == 1 ? "" : "s") + " detected; " + this.logger.getResolvedParseTableConflictCounter() + " resolved.\n");
        }
        if (this.logger.getLexicalConflictCounter() == 0) {
            this.logger.logMessage(CompilerLogMessageSort.FINAL_REPORT, null, "No lexical ambiguities detected.\n");
        } else {
            this.logger.logMessage(CompilerLogMessageSort.FINAL_REPORT, null, this.logger.getLexicalConflictCounter() + " lexical ambiguit" + (this.logger.getLexicalConflictCounter() == 1 ? "y" : "ies") + " detected; " + (this.logger.getResolvedLexicalConflictByContextCounter() + this.logger.getResolvedLexicalConflictByGroupCounter()) + " resolved,\n");
            this.logger.logMessage(CompilerLogMessageSort.FINAL_REPORT, null, "   " + this.logger.getResolvedLexicalConflictByContextCounter() + " by context, " + this.logger.getResolvedLexicalConflictByGroupCounter() + " by disambiguation function/group.\n");
        }
    }
}

