/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.copper.compiletime.auxiliary.counterexample;

import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.CopperASTBean;
import edu.umn.cs.melt.copper.compiletime.spec.numeric.PSSymbolTable;
import edu.umn.cs.melt.copper.compiletime.spec.numeric.ParserSpec;
import java.util.BitSet;

public class StateItem {
    private int state;
    private int production;
    private int dotPosition;
    private BitSet lookahead;

    public StateItem(int state, int production, int dotPosition, BitSet lookahead) {
        this.state = state;
        this.production = production;
        this.dotPosition = dotPosition;
        this.lookahead = lookahead;
    }

    public boolean equals(Object o) {
        if (!(o instanceof StateItem)) {
            return false;
        }
        StateItem stateItem = (StateItem)o;
        if (this.state != stateItem.state) {
            return false;
        }
        if (this.production != stateItem.production) {
            return false;
        }
        return this.dotPosition == stateItem.dotPosition;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(State: ");
        sb.append(this.state);
        sb.append(", Production: ");
        sb.append(this.production);
        sb.append(", DotPosition: ");
        sb.append(this.dotPosition);
        sb.append(')');
        return sb.toString();
    }

    public String prettyPrint(PSSymbolTable symbolTable, ParserSpec spec) {
        int i;
        StringBuilder sb = new StringBuilder();
        for (i = 0; i < this.dotPosition; ++i) {
            sb.append(((CopperASTBean)symbolTable.get(spec.pr.getRHSSym(this.production, i))).getDisplayName());
            sb.append(" ");
        }
        sb.append("\u2022 ");
        for (i = this.dotPosition; i < spec.pr.getRHSLength(this.production); ++i) {
            sb.append(((CopperASTBean)symbolTable.get(spec.pr.getRHSSym(this.production, i))).getDisplayName());
            sb.append(" ");
        }
        return sb.toString();
    }

    public int hashCode() {
        int result = this.state;
        result = 31 * result + this.production;
        result = 31 * result + this.dotPosition;
        return result;
    }

    public int getState() {
        return this.state;
    }

    public int getProduction() {
        return this.production;
    }

    public int getDotPosition() {
        return this.dotPosition;
    }

    public BitSet getLookahead() {
        return this.lookahead;
    }
}

