/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.BaseTypeRep;
import common.ConsCell;
import common.Typed;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;

public final class StringCatter
implements Typed {
    private Object fst;
    private StringCatter snd;

    public StringCatter(String str) {
        this.fst = str;
        this.snd = null;
    }

    public StringCatter(StringCatter sc1, StringCatter sc2) {
        this.fst = sc1;
        this.snd = sc2;
    }

    public String toString() {
        if (this.snd == null) {
            return (String)this.fst;
        }
        StringWriter sr = new StringWriter(this.length() + 1);
        try {
            ((StringCatter)this.fst).write(sr);
            this.snd.write(sr);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        this.fst = sr.toString();
        this.snd = null;
        return (String)this.fst;
    }

    public boolean equals(Object obj) {
        return this.toString().equals(obj.toString());
    }

    public int length() {
        if (this.snd == null) {
            return ((String)this.fst).length();
        }
        return ((StringCatter)this.fst).length() + this.snd.length();
    }

    public void write(Writer fout) throws IOException {
        if (this.snd == null) {
            fout.write((String)this.fst);
            return;
        }
        ((StringCatter)this.fst).write(fout);
        this.snd.write(fout);
    }

    public static StringCatter fromChars(ConsCell list) {
        StringBuilder str = new StringBuilder();
        while (!list.nil()) {
            str.append((char)((Integer)list.head()).intValue());
            list = list.tail();
        }
        return new StringCatter(str.toString());
    }

    public ConsCell toChars() {
        CharArrayWriter w = new CharArrayWriter(this.length());
        try {
            this.write(w);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        ConsCell out = ConsCell.nil;
        char[] chars = w.toCharArray();
        for (int i = chars.length - 1; i >= 0; --i) {
            out = new ConsCell(chars[i], out);
        }
        return out;
    }

    @Override
    public BaseTypeRep getType() {
        return new BaseTypeRep("String");
    }
}

