/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.copper.legacy.compiletime.finiteautomaton.lalrengine.lalr1;

import edu.umn.cs.melt.copper.legacy.compiletime.abstractsyntax.grammar.GrammarSymbol;
import edu.umn.cs.melt.copper.legacy.compiletime.abstractsyntax.grammar.Terminal;
import edu.umn.cs.melt.copper.legacy.compiletime.finiteautomaton.lalrengine.lalr1.LALR1LookaheadTables;
import edu.umn.cs.melt.copper.legacy.compiletime.finiteautomaton.lalrengine.lalr1.LALR1State;
import edu.umn.cs.melt.copper.legacy.compiletime.finiteautomaton.lalrengine.lalr1.LALR1StateItem;
import edu.umn.cs.melt.copper.legacy.compiletime.finiteautomaton.lalrengine.lalr1.LALR1Transition;
import java.util.HashSet;
import java.util.Hashtable;

public class LALR1DFA {
    private int nextLabel = 0;
    private Hashtable<LALR1State, Integer> labels = new Hashtable();
    private Hashtable<Integer, LALR1State> statesLabeled = new Hashtable();
    private HashSet<LALR1State> states = new HashSet();
    private Hashtable<LALR1State, HashSet<LALR1Transition>> transitions = new Hashtable();
    private Hashtable<LALR1State, Hashtable<LALR1StateItem, LALR1LookaheadTables>> lookaheadTables = new Hashtable();

    public boolean hasLookaheadTables(LALR1State state) {
        return this.lookaheadTables.containsKey(state);
    }

    public boolean hasLookaheadTables(LALR1State state, LALR1StateItem item) {
        return this.hasLookaheadTables(state) && this.lookaheadTables.get(state).containsKey(item);
    }

    public Hashtable<LALR1StateItem, LALR1LookaheadTables> getLookaheadTables(LALR1State state) {
        if (this.hasLookaheadTables(state)) {
            return this.lookaheadTables.get(state);
        }
        return new Hashtable<LALR1StateItem, LALR1LookaheadTables>();
    }

    public static boolean isILSubset(LALR1State first, Hashtable<LALR1StateItem, LALR1LookaheadTables> firstTables, LALR1State second, Hashtable<LALR1StateItem, LALR1LookaheadTables> secondTables) {
        if (!first.isISubset(second)) {
            return false;
        }
        for (LALR1StateItem item : firstTables.keySet()) {
            if (secondTables.get(item).getLookahead().containsAll(firstTables.get(item).getLookahead())) continue;
            return false;
        }
        return true;
    }

    protected LALR1LookaheadTables getLookaheadTables(LALR1State state, LALR1StateItem item) {
        if (this.hasLookaheadTables(state, item)) {
            return this.lookaheadTables.get(state).get(item);
        }
        return new LALR1LookaheadTables();
    }

    public boolean unionLookaheadTables(LALR1State state, LALR1StateItem item, LALR1LookaheadTables toUnion) {
        if (!this.hasLookaheadTables(state)) {
            this.lookaheadTables.put(state, new Hashtable());
        }
        if (!this.hasLookaheadTables(state, item)) {
            this.lookaheadTables.get(state).put(item, new LALR1LookaheadTables());
        }
        return this.lookaheadTables.get(state).get(item).union(toUnion);
    }

    public boolean addState(LALR1State state) {
        if (this.states.add(state)) {
            int newLabel = this.nextLabel++;
            this.labels.put(state, newLabel);
            this.statesLabeled.put(newLabel, state);
            this.lookaheadTables.put(state, new Hashtable());
            for (LALR1StateItem item : state.getItems()) {
                this.lookaheadTables.get(state).put(item, new LALR1LookaheadTables());
            }
            this.transitions.put(state, new HashSet());
            return true;
        }
        return false;
    }

    public boolean addLookahead(LALR1State state, LALR1StateItem item, HashSet<Terminal> newLookahead) {
        if (this.hasLookaheadTables(state, item)) {
            return this.lookaheadTables.get(state).get(item).addLookahead(newLookahead);
        }
        return false;
    }

    public HashSet<Terminal> getLookahead(LALR1State state, LALR1StateItem item) {
        if (this.hasLookaheadTables(state, item)) {
            return this.lookaheadTables.get(state).get(item).getLookahead();
        }
        return new HashSet<Terminal>();
    }

    public boolean lookaheadContains(LALR1State state, LALR1StateItem item, Terminal sym) {
        return this.hasLookaheadTables(state, item) && this.lookaheadTables.get(state).get(item).hasLookahead(sym);
    }

    public boolean addBeginningLayout(LALR1State state, LALR1StateItem item, HashSet<Terminal> newBeginningLayout) {
        if (this.hasLookaheadTables(state, item)) {
            return this.lookaheadTables.get(state).get(item).addBeginningLayout(newBeginningLayout);
        }
        return false;
    }

    public HashSet<Terminal> getBeginningLayout(LALR1State state, LALR1StateItem item) {
        if (this.hasLookaheadTables(state, item)) {
            return this.lookaheadTables.get(state).get(item).getBeginningLayout();
        }
        return new HashSet<Terminal>();
    }

    public Hashtable<Terminal, HashSet<Terminal>> getLookaheadLayout(LALR1State state, LALR1StateItem item) {
        return this.lookaheadTables.get(state).get(item).getLookaheadLayout();
    }

    public Iterable<Terminal> getLookaheadLayout(LALR1State state, LALR1StateItem item, Terminal layout) {
        return this.lookaheadTables.get(state).get(item).getLookaheadLayout(layout);
    }

    public boolean addLookaheadLayout(LALR1State state, LALR1StateItem item, Terminal layout, Terminal lookahead) {
        if (!this.hasLookaheadTables(state)) {
            this.lookaheadTables.put(state, new Hashtable());
        }
        if (!this.hasLookaheadTables(state, item)) {
            this.lookaheadTables.get(state).put(item, new LALR1LookaheadTables());
        }
        return this.lookaheadTables.get(state).get(item).addLookaheadLayout(layout, lookahead);
    }

    public boolean addLabeledState(LALR1State state, int label) {
        if (this.states.add(state)) {
            this.labels.put(state, label);
            this.statesLabeled.put(label, state);
            this.lookaheadTables.put(state, new Hashtable());
            for (LALR1StateItem item : state.getItems()) {
                this.lookaheadTables.get(state).put(item, new LALR1LookaheadTables());
            }
            return true;
        }
        return false;
    }

    public boolean addTransition(LALR1State src, GrammarSymbol label, LALR1State dest) {
        if (!this.states.contains(src) || !this.states.contains(dest)) {
            return false;
        }
        return this.transitions.get(src).add(new LALR1Transition(src, label, dest));
    }

    public Iterable<LALR1State> getStates() {
        return this.states;
    }

    public boolean hasTransitions(LALR1State state) {
        return this.states.contains(state);
    }

    public Iterable<LALR1Transition> getTransitions(LALR1State state) {
        if (!this.states.contains(state)) {
            return new HashSet<LALR1Transition>();
        }
        return this.transitions.get(state);
    }

    public int getLabel(LALR1State state) {
        if (!this.states.contains(state)) {
            return -1;
        }
        return this.labels.get(state);
    }

    public LALR1State getState(int label) {
        if (!this.statesLabeled.containsKey(label)) {
            return null;
        }
        return this.statesLabeled.get(label);
    }

    public int size() {
        return this.states.size();
    }

    public String toString() {
        String rv = "[\nSTATES = \n";
        for (LALR1State state : this.states) {
            rv = rv + this.labels.get(state) + "=\n" + state.toString() + ",\n";
        }
        rv = rv + "\nTRANSITIONS = \n";
        for (LALR1State state : this.states) {
            for (LALR1Transition transition : this.transitions.get(state)) {
                rv = rv + this.labels.get(transition.getSrc()) + "->";
                rv = rv + transition.getLabel() + "->";
                rv = rv + this.labels.get(transition.getDest());
                rv = rv + "\n";
            }
        }
        rv = rv + "\nTABLES = [\n";
        for (LALR1State state : this.states) {
            rv = rv + "State " + this.getLabel(state) + ":\n";
            rv = rv + "----------";
            for (LALR1StateItem item : state.getItems()) {
                rv = rv + "\n    " + item + ": " + this.lookaheadTables.get(state).get(item);
            }
            rv = rv + "\n";
        }
        rv = rv + "\n]";
        return rv;
    }
}

