/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.copper.legacy.compiletime.abstractsyntax.regex;

import edu.umn.cs.melt.copper.compiletime.auxiliary.SetOfCharsSyntax;
import edu.umn.cs.melt.copper.compiletime.scannerdfa.GeneralizedNFA;
import edu.umn.cs.melt.copper.legacy.compiletime.abstractsyntax.grammar.GrammarSource;
import edu.umn.cs.melt.copper.legacy.compiletime.abstractsyntax.grammar.Symbol;
import edu.umn.cs.melt.copper.legacy.compiletime.abstractsyntax.regex.ParsedRegex;
import edu.umn.cs.melt.copper.legacy.compiletime.abstractsyntax.regex.ParsedRegexVisitor;
import edu.umn.cs.melt.copper.legacy.compiletime.finiteautomaton.oldnfa.NFA;
import edu.umn.cs.melt.copper.legacy.compiletime.finiteautomaton.oldnfa.NFAState;
import edu.umn.cs.melt.copper.runtime.auxiliary.Pair;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Iterator;

public class Concatenation
extends ParsedRegex {
    private ArrayList<ParsedRegex> subexps;

    public Concatenation(ParsedRegex ... subexps) {
        this.NFANumber = nextNFANumber++;
        this.subexps = new ArrayList();
        for (ParsedRegex pr : subexps) {
            if (pr instanceof Concatenation) {
                for (ParsedRegex prc : ((Concatenation)pr).subexps) {
                    this.subexps.add(prc);
                }
                continue;
            }
            this.subexps.add(pr);
        }
    }

    @Override
    public NFA generateAutomaton(Symbol forRegex) {
        NFA[] baseNFAs = new NFA[this.subexps.size()];
        for (int i = 0; i < this.subexps.size(); ++i) {
            baseNFAs[i] = this.subexps.get(i).generateAutomaton(forRegex);
        }
        HashSet<NFAState> states = new HashSet<NFAState>();
        int i = 0;
        while (i + 1 < baseNFAs.length) {
            for (NFAState s : baseNFAs[i].getStates()) {
                states.add(s);
                if (s.getAccepts().isEmpty()) continue;
                s.addTransition(Character.valueOf(NFAState.EmptyChar), baseNFAs[i + 1].getStartState());
                s.getAccepts().clear();
            }
            ++i;
        }
        states.addAll(baseNFAs[baseNFAs.length - 1].getStates());
        NFA rv = new NFA(states, baseNFAs[0].getStartState());
        return rv;
    }

    @Override
    public Pair<Integer, BitSet> generateAutomaton(GeneralizedNFA nfa) {
        int newStartState = -1;
        Pair<Integer, BitSet> currentSub = null;
        Pair<Integer, BitSet> prevSub = null;
        for (ParsedRegex subexp : this.subexps) {
            currentSub = subexp.generateAutomaton(nfa);
            if (prevSub != null) {
                int i = ((BitSet)prevSub.second()).nextSetBit(0);
                while (i >= 0) {
                    nfa.addEpsilonTransition(i, currentSub.first());
                    i = prevSub.second().nextSetBit(i + 1);
                }
            } else {
                newStartState = currentSub.first();
            }
            prevSub = currentSub;
        }
        return Pair.cons(newStartState, currentSub.second());
    }

    @Override
    public Concatenation fillMacroHoles(GrammarSource fillers) {
        ParsedRegex[] newSubexps = new ParsedRegex[this.subexps.size()];
        int i = 0;
        for (ParsedRegex subexp : this.subexps) {
            newSubexps[i++] = subexp.fillMacroHoles(fillers);
        }
        return new Concatenation(newSubexps);
    }

    @Override
    public HashSet<SetOfCharsSyntax> getTransitionLabels() {
        HashSet<SetOfCharsSyntax> rv = new HashSet<SetOfCharsSyntax>();
        for (ParsedRegex sexp : this.subexps) {
            rv.addAll(sexp.getTransitionLabels());
        }
        return rv;
    }

    @Override
    public Concatenation clone() {
        ParsedRegex[] newSubexps = new ParsedRegex[this.subexps.size()];
        int i = 0;
        for (ParsedRegex subexp : this.subexps) {
            newSubexps[i++] = subexp.clone();
        }
        return new Concatenation(newSubexps);
    }

    public String toString() {
        String rv = "";
        Iterator<ParsedRegex> it = this.subexps.iterator();
        while (it.hasNext()) {
            String part = it.next().toString();
            if (part.length() > 1 && part.charAt(0) != '[') {
                rv = rv + '(';
            }
            rv = rv + part;
            if (part.length() <= 1 || part.charAt(0) == '[') continue;
            rv = rv + ')';
        }
        return rv;
    }

    public Iterable<ParsedRegex> getConstituents() {
        return this.subexps;
    }

    @Override
    public <SYNTYPE, INHTYPE, E extends Exception> SYNTYPE acceptVisitor(ParsedRegexVisitor<SYNTYPE, INHTYPE, E> visitor, INHTYPE inheritance) throws E {
        return visitor.visitConcatenation(this, inheritance);
    }
}

