/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.copper.compiletime.builders;

import edu.umn.cs.melt.copper.compiletime.scannerdfa.GeneralizedDFA;
import edu.umn.cs.melt.copper.compiletime.scannerdfa.SingleScannerDFAAnnotations;
import edu.umn.cs.melt.copper.compiletime.spec.numeric.ParserSpec;
import edu.umn.cs.melt.copper.compiletime.spec.numeric.PrecedenceGraph;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashSet;
import java.util.LinkedList;

public class SingleScannerDFAAnnotationBuilder {
    private PrecedenceGraph precedences;
    private GeneralizedDFA dfa;

    private SingleScannerDFAAnnotationBuilder(PrecedenceGraph precedences, GeneralizedDFA dfa) {
        this.precedences = precedences;
        this.dfa = dfa;
    }

    public static SingleScannerDFAAnnotations build(ParserSpec spec, GeneralizedDFA dfa) {
        return new SingleScannerDFAAnnotationBuilder(spec.t.precedences, dfa).buildAnnotations();
    }

    public static SingleScannerDFAAnnotations build(PrecedenceGraph precedences, GeneralizedDFA dfa) {
        return new SingleScannerDFAAnnotationBuilder(precedences, dfa).buildAnnotations();
    }

    private SingleScannerDFAAnnotations buildAnnotations() {
        int j;
        int i;
        HashSet<BitSet> circularDependencies = new HashSet<BitSet>();
        LinkedList<BitSet> stateCircularDependencies = new LinkedList<BitSet>();
        int SCANNER_STATE_COUNT = this.dfa.stateCount();
        BitSet[] acceptSets = new BitSet[SCANNER_STATE_COUNT];
        BitSet[] rejectSets = new BitSet[SCANNER_STATE_COUNT];
        BitSet[] possibleSets = new BitSet[SCANNER_STATE_COUNT];
        int[] cMap = new int[65536];
        for (int state = 0; state < this.dfa.stateCount(); ++state) {
            BitSet accF = this.dfa.getAcceptSymbols(state);
            stateCircularDependencies.clear();
            BitSet rej = this.precedences.partitionAcceptSet(stateCircularDependencies, accF);
            if (!stateCircularDependencies.isEmpty()) {
                circularDependencies.addAll(stateCircularDependencies);
            }
            acceptSets[state] = new BitSet();
            rejectSets[state] = new BitSet();
            possibleSets[state] = new BitSet();
            acceptSets[state].or(accF);
            acceptSets[state].andNot(rej);
            rejectSets[state].or(rej);
        }
        boolean[][] transClosure = new boolean[SCANNER_STATE_COUNT][SCANNER_STATE_COUNT];
        for (i = 0; i < SCANNER_STATE_COUNT; ++i) {
            transClosure[i][i] = true;
        }
        for (int state = 0; state < this.dfa.stateCount(); ++state) {
            BitSet connections = this.dfa.getConnectedStates(state);
            j = connections.nextSetBit(0);
            while (j >= 0) {
                transClosure[state][j] = true;
                j = connections.nextSetBit(j + 1);
            }
        }
        for (int k = 0; k < SCANNER_STATE_COUNT; ++k) {
            for (i = 0; i < SCANNER_STATE_COUNT; ++i) {
                for (int j2 = 0; j2 < SCANNER_STATE_COUNT; ++j2) {
                    transClosure[i][j2] = transClosure[i][j2] || transClosure[i][k] && transClosure[k][j2];
                }
            }
        }
        for (i = 0; i < SCANNER_STATE_COUNT; ++i) {
            for (int j3 = 0; j3 < SCANNER_STATE_COUNT; ++j3) {
                if (!transClosure[i][j3]) continue;
                possibleSets[i].or(acceptSets[j3]);
                possibleSets[i].or(rejectSets[j3]);
            }
        }
        for (int cr = 0; cr < this.dfa.charRangeCount(); ++cr) {
            char[][] canonicalRanges = this.dfa.getCharRange(cr).getMembers();
            for (j = 0; j < canonicalRanges.length; ++j) {
                Arrays.fill(cMap, (int)canonicalRanges[j][0], canonicalRanges[j][1] + '\u0001', cr);
            }
        }
        BitSet[] circularDependenciesA = new BitSet[circularDependencies.size()];
        circularDependencies.toArray(circularDependenciesA);
        return new SingleScannerDFAAnnotations(acceptSets, rejectSets, possibleSets, cMap, circularDependenciesA);
    }
}

