/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.copper.runtime.logging;

import edu.umn.cs.melt.copper.runtime.auxiliary.internal.PrettyPrinter;
import edu.umn.cs.melt.copper.runtime.engines.semantics.VirtualLocation;
import edu.umn.cs.melt.copper.runtime.io.InputPosition;
import edu.umn.cs.melt.copper.runtime.logging.CopperParserException;
import java.util.ArrayList;

public class CopperSyntaxError
extends CopperParserException {
    private static final long serialVersionUID = -7677888467140493812L;
    private VirtualLocation virtualLocation;
    private InputPosition realLocation;
    private int parseState;
    private ArrayList<String> expectedTerminalsRealNames;
    private ArrayList<String> expectedTerminalsDisplayNames;
    private ArrayList<String> matchedTerminalsRealNames;
    private ArrayList<String> matchedTerminalsDisplayNames;
    private String locationDescription;
    private String stringDescription;

    public CopperSyntaxError(VirtualLocation virtualLocation, InputPosition realLocation, int parseState, ArrayList<String> expectedTerminalsRealNames, ArrayList<String> expectedTerminalsDisplayNames, ArrayList<String> matchedTerminalsRealNames, ArrayList<String> matchedTerminalsDisplayNames) {
        this.virtualLocation = virtualLocation;
        this.realLocation = realLocation;
        this.parseState = parseState;
        this.expectedTerminalsRealNames = expectedTerminalsRealNames;
        this.expectedTerminalsDisplayNames = expectedTerminalsDisplayNames;
        this.matchedTerminalsRealNames = matchedTerminalsRealNames;
        this.matchedTerminalsDisplayNames = matchedTerminalsDisplayNames;
        this.locationDescription = null;
        this.stringDescription = null;
    }

    public String getRealFilename() {
        return this.realLocation.getFileName();
    }

    public int getRealLine() {
        return this.realLocation.getLine();
    }

    public int getRealColumn() {
        return this.realLocation.getColumn();
    }

    public long getRealCharIndex() {
        return this.realLocation.getPos();
    }

    public String getVirtualFileName() {
        return this.virtualLocation.getFileName();
    }

    public int getVirtualLine() {
        return this.virtualLocation.getLine();
    }

    public int getVirtualColumn() {
        return this.virtualLocation.getColumn();
    }

    public int getParseState() {
        return this.parseState;
    }

    public ArrayList<String> getExpectedTerminalsReal() {
        return this.expectedTerminalsRealNames;
    }

    public ArrayList<String> getExpectedTerminalsDisplay() {
        return this.expectedTerminalsDisplayNames;
    }

    public ArrayList<String> getMatchedTerminalsReal() {
        return this.matchedTerminalsRealNames;
    }

    public ArrayList<String> getMatchedTerminalsDisplay() {
        return this.matchedTerminalsDisplayNames;
    }

    public String getLocationDescription() {
        if (this.locationDescription == null) {
            StringBuffer location = new StringBuffer();
            location.append("line ").append(this.virtualLocation.getLine()).append(", column ").append(this.virtualLocation.getColumn());
            if (this.realLocation.getFileName().length() > 40) {
                location.append("\n         ");
            }
            location.append(" in file ").append(this.virtualLocation.getFileName());
            location.append("\n         (parser state: ").append(this.parseState).append("; real character index: ").append(this.realLocation.getPos()).append(")");
            this.locationDescription = location.toString();
        }
        return this.locationDescription;
    }

    @Override
    public String getMessage() {
        if (this.stringDescription == null) {
            StringBuffer error = new StringBuffer();
            error.append("Error at ");
            error.append(this.getLocationDescription());
            error.append(":\n  ");
            error.append("Expected a token of one of the following types:\n");
            error.append(PrettyPrinter.iterablePrettyPrint(this.expectedTerminalsDisplayNames, "   ", PrettyPrinter.getOptimalItemsPerLine(this.expectedTerminalsDisplayNames, 80)));
            error.append("\n   Input currently matches:\n");
            error.append(PrettyPrinter.iterablePrettyPrint(this.matchedTerminalsDisplayNames, "   ", PrettyPrinter.getOptimalItemsPerLine(this.expectedTerminalsDisplayNames, 80)));
            this.stringDescription = error.toString();
        }
        return this.stringDescription;
    }

    @Override
    public String toString() {
        return this.getMessage();
    }
}

