/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.copper.runtime;

import edu.umn.cs.melt.copper.runtime.engines.CopperParser;
import edu.umn.cs.melt.copper.runtime.logging.CopperParserException;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.InputStreamReader;
import java.lang.reflect.Method;

public class RunParser {
    public static void main(String[] args) {
        boolean useFile = false;
        boolean runVerbose = false;
        String filename = "<stdin>";
        InputStreamReader reader = null;
        try {
            Class<?> className;
            if (args.length < 1) {
                throw new CopperParserException("The first argument to RunParser must be a parser class name");
            }
            try {
                className = Class.forName(args[0]);
            }
            catch (ClassNotFoundException ex) {
                throw new CopperParserException("No such class: " + args[0]);
            }
            for (int i = 1; i < args.length && args[i].charAt(0) == '-'; ++i) {
                if (args[i].equals("-f")) {
                    if (++i >= args.length) {
                        throw new CopperParserException("A filename must be provided with switch '-f'");
                    }
                    useFile = true;
                    filename = args[i];
                    continue;
                }
                if (!args[i].equals("-v")) continue;
                runVerbose = true;
            }
            if (!useFile) {
                reader = new InputStreamReader(System.in);
            } else {
                try {
                    reader = new FileReader(filename);
                }
                catch (FileNotFoundException ex) {
                    throw new CopperParserException("File not found: '" + filename + "'");
                }
            }
            CopperParser engine = (CopperParser)className.newInstance();
            Object parseTree = engine.parse(reader, filename);
            try {
                Method postParseCode = className.getMethod("runPostParseCode", Object.class);
                postParseCode.invoke((Object)engine, parseTree);
            }
            catch (NoSuchMethodException noSuchMethodException) {}
        }
        catch (Exception ex) {
            if (runVerbose) {
                ex.printStackTrace();
            } else {
                System.err.println(ex.getClass().getSimpleName() + ": " + ex.getMessage());
            }
            System.exit(1);
        }
    }
}

