/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.copper.compiletime.logging.messages;

import edu.umn.cs.melt.copper.compiletime.auxiliary.SymbolTable;
import edu.umn.cs.melt.copper.compiletime.logging.CompilerLevel;
import edu.umn.cs.melt.copper.compiletime.logging.CompilerLogMessage;
import edu.umn.cs.melt.copper.compiletime.scannerdfa.LexicalAmbiguities;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.CopperASTBean;
import edu.umn.cs.melt.copper.compiletime.spec.numeric.PSSymbolTable;
import java.util.BitSet;

public class LexicalAmbiguityMessage
implements CompilerLogMessage {
    private SymbolTable<CopperASTBean> symbolTable;
    private boolean isUnresolved;
    private BitSet ambiguity;
    private BitSet states;
    private int resolution;

    public LexicalAmbiguityMessage(SymbolTable<CopperASTBean> symbolTable, LexicalAmbiguities ambiguities, int ambiguity) {
        this.symbolTable = symbolTable;
        this.isUnresolved = ambiguities.isUnresolved(ambiguity);
        this.ambiguity = ambiguities.getAmbiguity(ambiguity);
        this.states = ambiguities.getLocations(ambiguity);
        this.resolution = ambiguities.getResolution(ambiguity);
    }

    @Override
    public CompilerLevel getLevel() {
        if (this.isUnresolved) {
            return CompilerLevel.QUIET;
        }
        return CompilerLevel.VERBOSE;
    }

    @Override
    public int getType() {
        return 6;
    }

    @Override
    public boolean isError() {
        return this.isUnresolved;
    }

    @Override
    public boolean isFatalError() {
        return false;
    }

    @Override
    public String toString() {
        String ambigHash = PSSymbolTable.bitSetPrettyPrint(this.ambiguity, this.symbolTable, "    ", 80);
        StringBuffer rv = new StringBuffer();
        if (this.isUnresolved) {
            rv.append("Unresolvable l");
        } else {
            rv.append("L");
        }
        rv.append("exical ambiguity");
        if (this.isUnresolved) {
            String statesHash = PSSymbolTable.bitSetPrettyPrint(this.states, null, "   ", 80);
            rv.append(" at parser states").append(statesHash);
        }
        rv.append(this.ambiguity.cardinality() == 2 ? " between" : " among").append(" terminals:\n   ").append(ambigHash);
        if (!this.isUnresolved) {
            rv.append("\nResolved by ").append(this.resolution == -1 ? "context" : "disambiguation function");
        }
        return rv.toString();
    }
}

