/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.copper.compiletime.auxiliary.xml;

import edu.umn.cs.melt.copper.compiletime.auxiliary.xml.Entities;
import edu.umn.cs.melt.copper.compiletime.auxiliary.xml.SAXWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Hashtable;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class SAXWriterImpl
implements SAXWriter {
    private Hashtable<String, String> prefixes = new Hashtable();
    private Hashtable<String, Stack<String>> reversePrefixes = new Hashtable();
    private Stack<ElementStackElement> elementStack = new Stack();
    private boolean prettyPrint = false;
    private boolean indentAttributes = false;
    private String elementIndentation = "";
    private PrintStream out;

    public SAXWriterImpl(PrintStream out) {
        this.out = out;
    }

    public SAXWriterImpl(PrintStream out, String elementIndentation, boolean indentAttributes) {
        this.out = out;
        this.prettyPrint = true;
        this.elementIndentation = elementIndentation;
        this.indentAttributes = indentAttributes;
    }

    private static Attributes buildAttributes(String[] atts, boolean attrNamesFullyQualified) {
        AttributesImpl attrs = new AttributesImpl();
        if (attrNamesFullyQualified) {
            for (int i = 0; i < atts.length - 3; i += 4) {
                attrs.addAttribute(atts[i], atts[i + 1], atts[i + 2], "xs:string", atts[i + 3]);
            }
        } else {
            for (int i = 0; i < atts.length - 1; i += 2) {
                attrs.addAttribute(null, atts[i], atts[i], "xs:string", atts[i + 1]);
            }
        }
        return attrs;
    }

    @Override
    public void writeFullElement(String uri, String localName, String qName, boolean attrNamesFullyQualified, String ... atts) throws SAXException {
        this.writeFullElement(uri, localName, qName, SAXWriterImpl.buildAttributes(atts, attrNamesFullyQualified));
    }

    @Override
    public void startElement(String uri, String localName, String qName, boolean attrNamesFullyQualified, String ... atts) throws SAXException {
        this.startElement(uri, localName, qName, SAXWriterImpl.buildAttributes(atts, attrNamesFullyQualified));
    }

    @Override
    public void writeFullElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        this.writeElement(uri, localName, qName, atts, true);
    }

    @Override
    public void string(String s) throws SAXException {
        this.characters(s.toCharArray(), 0, s.length());
    }

    @Override
    public void verbatimString(String s) throws SAXException {
        this.verbatimCharacters(s.toCharArray(), 0, s.length());
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void startDocument() throws SAXException {
        if (this.elementStack != null && !this.elementStack.isEmpty()) {
            throw new SAXException("startDocument() received in the middle of outputting a document");
        }
        this.out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        this.elementStack.clear();
        this.prefixes.clear();
    }

    @Override
    public void endDocument() throws SAXException {
        if (this.elementStack == null || !this.elementStack.isEmpty()) {
            throw new SAXException("endDocument() received prematurely");
        }
        this.prefixes.clear();
        if (this.prettyPrint) {
            this.out.print("\n");
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        System.err.println("Prefix mappings are not properly supported");
        this.prefixes.put(uri, prefix);
        if (!this.reversePrefixes.containsKey(prefix)) {
            this.reversePrefixes.put(prefix, new Stack());
        }
        this.reversePrefixes.get(prefix).push(uri);
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        System.err.println("Prefix mappings are not properly supported");
        if (!this.reversePrefixes.containsKey(prefix) || this.reversePrefixes.get(prefix).isEmpty()) {
            throw new SAXException("endPrefixMapping() received for a prefix that was never mapped");
        }
        String uri = this.reversePrefixes.get(prefix).pop();
        this.prefixes.remove(uri);
    }

    private String getElementName(String uri, String localName, String qName) throws SAXException {
        if (qName != null) {
            return qName;
        }
        if (uri != null) {
            if (!this.prefixes.containsKey(uri)) {
                throw new SAXException("URI '" + uri + "' has no prefix");
            }
            return this.prefixes.get(uri) + ":" + localName;
        }
        return localName;
    }

    private void writeElement(String uri, String localName, String qName, Attributes atts, boolean close) throws SAXException {
        int i;
        String elementName = this.getElementName(uri, localName, qName);
        if (!this.elementStack.isEmpty()) {
            ++this.elementStack.peek().childCount;
        }
        this.elementStack.push(new ElementStackElement(elementName));
        if (this.prettyPrint) {
            this.out.print("\n");
            for (i = 0; i < this.elementStack.size() - 1; ++i) {
                this.out.print(this.elementIndentation);
            }
        }
        this.out.print("<" + elementName);
        if (atts != null) {
            for (i = 0; i < atts.getLength(); ++i) {
                if (atts.getValue(i) == null || atts.getValue(i).isEmpty()) continue;
                String name = atts.getQName(i);
                if (name.isEmpty()) {
                    name = atts.getLocalName(i);
                }
                if (this.indentAttributes && i > 0) {
                    int j;
                    this.out.print("\n");
                    for (j = 0; j < this.elementStack.size() - 1; ++j) {
                        this.out.print(this.elementIndentation);
                    }
                    for (j = 0; j < elementName.length() + 1; ++j) {
                        this.out.print(" ");
                    }
                }
                this.out.print(" ");
                this.out.print(name + "=\"");
                PrintWriter outPW = new PrintWriter(this.out);
                try {
                    Entities.XML.escape(outPW, atts.getValue(i));
                }
                catch (IOException ex) {
                    throw new SAXException(ex);
                }
                outPW.flush();
                this.out.print("\"");
            }
        }
        if (close) {
            this.elementStack.pop();
            this.out.print("/");
        }
        this.out.print(">");
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        this.writeElement(uri, localName, qName, atts, false);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        String elementName = this.getElementName(uri, localName, qName);
        if (!this.elementStack.peek().element.equals(elementName)) {
            throw new SAXException("Misplaced end to element " + elementName);
        }
        ElementStackElement endedElement = this.elementStack.pop();
        if (this.prettyPrint && endedElement.childCount > 0) {
            this.out.print("\n");
            for (int i = 0; i < this.elementStack.size(); ++i) {
                this.out.print(this.elementIndentation);
            }
        }
        this.out.print("</" + elementName + ">");
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        PrintWriter outPW = new PrintWriter(this.out);
        try {
            Entities.XML.escape(outPW, new String(ch, start, length));
        }
        catch (IOException ex) {
            throw new SAXException(ex);
        }
        outPW.flush();
    }

    @Override
    public void verbatimCharacters(char[] ch, int start, int length) throws SAXException {
        this.out.print("<![CDATA[");
        this.out.print(new String(ch, start, length));
        this.out.print("]]>");
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    private class ElementStackElement {
        public String element;
        public int childCount;

        public ElementStackElement(String element) {
            this.element = element;
            this.childCount = 0;
        }
    }
}

