/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.copper.compiletime.skins.xml.v0p7;

import edu.umn.cs.melt.copper.compiletime.logging.CompilerLevel;
import edu.umn.cs.melt.copper.compiletime.logging.messages.GenericLocatedMessage;
import edu.umn.cs.melt.copper.compiletime.skins.xml.VersionSpecificXMLSkinParser;
import edu.umn.cs.melt.copper.compiletime.skins.xml.v0p7.XMLSkinElements;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.CharacterSetRegex;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.ChoiceRegex;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.ConcatenationRegex;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.CopperElementName;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.CopperElementReference;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.CopperElementType;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.DisambiguationFunction;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.EmptyStringRegex;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.ExtendedParserBean;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.ExtensionGrammar;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.Grammar;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.KleeneStarRegex;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.MacroHoleRegex;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.NonTerminal;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.OperatorAssociativity;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.OperatorClass;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.ParserAttribute;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.ParserBean;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.Production;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.Regex;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.Terminal;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.TerminalClass;
import edu.umn.cs.melt.copper.runtime.io.InputPosition;
import edu.umn.cs.melt.copper.runtime.io.Location;
import edu.umn.cs.melt.copper.runtime.logging.CopperException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLSkinParser
extends VersionSpecificXMLSkinParser {
    private SAXStackElement[] saxStack;
    private int saxStackPointer;
    private ExtendedParserBean currentExtendedParser = null;
    private Grammar currentGrammar = null;
    private ExtensionGrammar currentExtensionGrammar = null;
    private Terminal currentTerminal = null;
    private TerminalClass currentTerminalClass = null;
    private OperatorClass currentOperatorClass = null;
    private NonTerminal currentNonTerminal = null;
    private Production currentProduction = null;
    private DisambiguationFunction currentDisambiguationFunction = null;
    private ParserAttribute currentParserAttribute = null;
    private ArrayList<CopperElementReference> refList = null;
    private Set<CopperElementReference> refSet = null;
    private Set<String> interfaceNames = null;
    private ArrayList<String> varNames = null;
    private String nodeText = null;
    private SAXStackElement lastTextNode = null;

    @Override
    public void init() {
        this.saxStack = new SAXStackElement[32];
        this.saxStackPointer = -1;
    }

    private void push(SAXStackElement e) {
        if (this.saxStackPointer + 1 >= this.saxStack.length) {
            SAXStackElement[] newSAXStack = new SAXStackElement[this.saxStack.length * 2];
            System.arraycopy(this.saxStack, 0, newSAXStack, 0, this.saxStack.length);
            this.saxStack = newSAXStack;
        }
        this.saxStack[++this.saxStackPointer] = e;
    }

    private SAXStackElement peek() {
        return this.saxStack[this.saxStackPointer];
    }

    private SAXStackElement pop() {
        if (this.saxStackPointer == -1) {
            return null;
        }
        return this.saxStack[this.saxStackPointer--];
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        try {
            this.startElementInner(uri, localName, qName, attributes);
        }
        catch (ParseException ex) {
            this.error(new SAXParseException(ex.getMessage(), this.locator));
        }
        catch (CopperException ex) {
            this.error(new SAXParseException(ex.getMessage(), this.locator));
        }
    }

    private void startElementInner(String uri, String localName, String qName, Attributes attributes) throws ParseException, CopperException {
        SAXStackElement parent = null;
        if (this.saxStackPointer != -1) {
            parent = this.peek();
        }
        this.push(new SAXStackElement(XMLSkinElements.nodeTypes.get(qName), InputPosition.fromSAXLocator(this.loc, this.locator)));
        switch (this.peek().type) {
            case BRIDGE_PRODUCTIONS_ELEMENT: {
                this.refSet = new HashSet<CopperElementReference>();
                break;
            }
            case CHARACTER_RANGE_ELEMENT: {
                String lowerBound = attributes.getValue("lower");
                String upperBound = attributes.getValue("upper");
                try {
                    ((CharacterSetRegex)parent.regexChildren.get(0)).addRange(lowerBound.charAt(0), upperBound.charAt(0));
                }
                catch (IllegalArgumentException ex) {
                    this.logger.logError(new GenericLocatedMessage(CompilerLevel.QUIET, this.peek().startLocation, ex.getMessage()));
                }
                break;
            }
            case CHARACTER_SET_ELEMENT: {
                String invert = attributes.getValue("invert");
                if (invert != null && (invert.equals("true") || invert.equals("1"))) {
                    this.peek().invertCharacterSet = true;
                }
                this.peek().regexChildren = new ArrayList();
                this.peek().regexChildren.add(new CharacterSetRegex());
                break;
            }
            case CHOICE_ELEMENT: {
                this.peek().regexChildren = new ArrayList();
                break;
            }
            case CLASS_AUXILIARY_CODE_ELEMENT: {
                break;
            }
            case CLASS_ELEMENT: {
                this.refList = new ArrayList();
                break;
            }
            case CLASS_NAME_ELEMENT: {
                break;
            }
            case CODE_ELEMENT: {
                break;
            }
            case CONCATENATION_ELEMENT: {
                this.peek().regexChildren = new ArrayList();
                break;
            }
            case COPPER_SPEC_ELEMENT: {
                break;
            }
            case DECLARATIONS_ELEMENT: {
                break;
            }
            case DEFAULT_PRODUCTION_CODE_ELEMENT: {
                break;
            }
            case DEFAULT_TERMINAL_CODE_ELEMENT: {
                break;
            }
            case DISAMBIGUATE_TO_ELEMENT: {
                this.refList = new ArrayList();
                break;
            }
            case DISAMBIGUATION_FUNCTION_ELEMENT: {
                CopperElementName currentDisambiguationFunctionName = CopperElementName.newName(attributes.getValue("id"));
                this.currentDisambiguationFunction = (DisambiguationFunction)this.currentGrammar.getGrammarElement(currentDisambiguationFunctionName);
                if (this.currentDisambiguationFunction != null) break;
                this.currentDisambiguationFunction = new DisambiguationFunction();
                this.currentDisambiguationFunction.setName(currentDisambiguationFunctionName);
                this.currentDisambiguationFunction.setLocation(this.peek().startLocation);
                this.currentGrammar.addGrammarElement(this.currentDisambiguationFunction);
                break;
            }
            case DOMINATES_ELEMENT: {
                this.refSet = new HashSet<CopperElementReference>();
                break;
            }
            case EMPTY_STRING_REGEX_ELEMENT: {
                break;
            }
            case EXTENSION_GRAMMARS_ELEMENT: 
            case GRAMMARS_ELEMENT: {
                this.refSet = new HashSet<CopperElementReference>();
                break;
            }
            case EXTENSION_GRAMMAR_ELEMENT: {
                CopperElementName grammarName = CopperElementName.newName(attributes.getValue("id"));
                if (!this.grammars.containsKey(grammarName)) {
                    this.grammars.put(grammarName, new ExtensionGrammar());
                    ((Grammar)this.grammars.get(grammarName)).setName(grammarName);
                }
                this.currentGrammar = (Grammar)this.grammars.get(grammarName);
                if (this.currentGrammar.getType() == CopperElementType.EXTENSION_GRAMMAR) {
                    this.currentExtensionGrammar = (ExtensionGrammar)this.currentGrammar;
                }
                if (this.currentGrammar.getLocation() != null) break;
                ((Grammar)this.grammars.get(grammarName)).setLocation(this.peek().startLocation);
                break;
            }
            case GRAMMAR_ELEMENT: {
                CopperElementName grammarName = CopperElementName.newName(attributes.getValue("id"));
                if (!this.grammars.containsKey(grammarName)) {
                    this.grammars.put(grammarName, new Grammar());
                    ((Grammar)this.grammars.get(grammarName)).setName(grammarName);
                }
                this.currentGrammar = (Grammar)this.grammars.get(grammarName);
                if (this.currentGrammar.getLocation() != null) break;
                ((Grammar)this.grammars.get(grammarName)).setLocation(this.peek().startLocation);
                break;
            }
            case HOST_GRAMMAR_ELEMENT: {
                this.refList = new ArrayList();
                break;
            }
            case IN_CLASSES_ELEMENT: {
                this.refSet = new HashSet<CopperElementReference>();
                break;
            }
            case INTERFACE_NAME_ELEMENT: {
                break;
            }
            case INTERFACE_NAMES_ELEMENT: {
                this.interfaceNames = new HashSet<String>();
                break;
            }
            case KLEENE_STAR_ELEMENT: {
                this.peek().regexChildren = new ArrayList();
                break;
            }
            case LAYOUT_ELEMENT: {
                this.refSet = new HashSet<CopperElementReference>();
                break;
            }
            case LEFT_ASSOCIATIVE_ELEMENT: {
                this.currentTerminal.setOperatorAssociativity(OperatorAssociativity.LEFT);
                break;
            }
            case LHS_ELEMENT: {
                this.refList = new ArrayList();
                break;
            }
            case MARKING_TERMINALS_ELEMENT: {
                this.refSet = new HashSet<CopperElementReference>();
                break;
            }
            case MEMBERS_ELEMENT: {
                this.refSet = new HashSet<CopperElementReference>();
                break;
            }
            case NON_ASSOCIATIVE_ELEMENT: {
                this.currentTerminal.setOperatorAssociativity(OperatorAssociativity.NONASSOC);
                break;
            }
            case NONTERMINAL_ELEMENT: {
                CopperElementName currentNonterminalName = CopperElementName.newName(attributes.getValue("id"));
                this.currentNonTerminal = (NonTerminal)this.currentGrammar.getGrammarElement(currentNonterminalName);
                if (this.currentNonTerminal != null) break;
                this.currentNonTerminal = new NonTerminal();
                this.currentNonTerminal.setName(currentNonterminalName);
                this.currentNonTerminal.setLocation(this.peek().startLocation);
                this.currentGrammar.addGrammarElement(this.currentNonTerminal);
                break;
            }
            case OPERATOR_ELEMENT: {
                if (parent.type != XMLSkinElements.Type.PRODUCTION_ELEMENT) break;
                this.refList = new ArrayList();
                break;
            }
            case OPERATOR_CLASS_ELEMENT: {
                CopperElementName currentOperatorClassName = CopperElementName.newName(attributes.getValue("id"));
                this.currentOperatorClass = (OperatorClass)this.currentGrammar.getGrammarElement(currentOperatorClassName);
                if (this.currentOperatorClass != null) break;
                this.currentOperatorClass = new OperatorClass();
                this.currentOperatorClass.setName(currentOperatorClassName);
                this.currentOperatorClass.setLocation(this.peek().startLocation);
                this.currentGrammar.addGrammarElement(this.currentOperatorClass);
                break;
            }
            case PACKAGE_ELEMENT: {
                break;
            }
            case PARSER_ATTRIBUTE_ELEMENT: {
                CopperElementName currentParserAttributeName = CopperElementName.newName(attributes.getValue("id"));
                this.currentParserAttribute = (ParserAttribute)this.currentGrammar.getGrammarElement(currentParserAttributeName);
                if (this.currentParserAttribute != null) break;
                this.currentParserAttribute = new ParserAttribute();
                this.currentParserAttribute.setName(currentParserAttributeName);
                this.currentParserAttribute.setLocation(this.peek().startLocation);
                this.currentGrammar.addGrammarElement(this.currentParserAttribute);
                break;
            }
            case EXTENDED_PARSER_ELEMENT: {
                this.currentExtendedParser = new ExtendedParserBean();
            }
            case PARSER_ELEMENT: {
                if (this.currentExtendedParser != null) {
                    this.addParser(this.currentExtendedParser);
                } else {
                    this.addParser(new ParserBean());
                }
                this.getCurrentParser().setName(attributes.getValue("id"));
                this.getCurrentParser().setLocation(this.peek().startLocation);
                String isUnitary = attributes.getValue("isUnitary");
                if (isUnitary == null || !isUnitary.equals("true") && !isUnitary.equals("1")) break;
                this.getCurrentParser().setUnitary(true);
                break;
            }
            case PARSER_INIT_CODE_ELEMENT: {
                break;
            }
            case POST_PARSE_CODE_ELEMENT: {
                break;
            }
            case PP_ELEMENT: {
                break;
            }
            case PREAMBLE_ELEMENT: {
                break;
            }
            case PRECEDENCE_ELEMENT: {
                break;
            }
            case PREFIX_ELEMENT: {
                this.refList = new ArrayList();
                break;
            }
            case PRODUCTION_ELEMENT: {
                CopperElementName currentProductionName = CopperElementName.newName(attributes.getValue("id"));
                this.currentProduction = (Production)this.currentGrammar.getGrammarElement(currentProductionName);
                if (this.currentProduction != null) break;
                this.currentProduction = new Production();
                this.currentProduction.setName(currentProductionName);
                this.currentProduction.setLocation(this.peek().startLocation);
                this.currentGrammar.addGrammarElement(this.currentProduction);
                break;
            }
            case REGEX_ELEMENT: {
                this.peek().regexChildren = new ArrayList();
                break;
            }
            case RHS_ELEMENT: {
                this.refList = new ArrayList();
                this.varNames = new ArrayList();
                break;
            }
            case RIGHT_ASSOCIATIVE_ELEMENT: {
                this.currentTerminal.setOperatorAssociativity(OperatorAssociativity.RIGHT);
                break;
            }
            case SEMANTIC_ACTION_AUXILIARY_CODE_ELEMENT: {
                break;
            }
            case SINGLE_CHARACTER_ELEMENT: {
                String character = attributes.getValue("char");
                ((CharacterSetRegex)parent.regexChildren.get(0)).addLooseChar(character.charAt(0));
                break;
            }
            case START_LAYOUT_ELEMENT: {
                this.refSet = new HashSet<CopperElementReference>();
                break;
            }
            case START_SYMBOL_ELEMENT: {
                this.refList = new ArrayList();
                break;
            }
            case SUBMITS_ELEMENT: {
                this.refSet = new HashSet<CopperElementReference>();
                break;
            }
            case TERMINAL_CLASS_ELEMENT: {
                CopperElementName currentTerminalClassName = CopperElementName.newName(attributes.getValue("id"));
                this.currentTerminalClass = (TerminalClass)this.currentGrammar.getGrammarElement(currentTerminalClassName);
                if (this.currentTerminalClass != null) break;
                this.currentTerminalClass = new TerminalClass();
                this.currentTerminalClass.setName(currentTerminalClassName);
                this.currentTerminalClass.setLocation(this.peek().startLocation);
                this.currentGrammar.addGrammarElement(this.currentTerminalClass);
                break;
            }
            case TERMINAL_ELEMENT: {
                CopperElementName currentTerminalName = CopperElementName.newName(attributes.getValue("id"));
                this.currentTerminal = (Terminal)this.currentGrammar.getGrammarElement(currentTerminalName);
                if (this.currentTerminal != null) break;
                this.currentTerminal = new Terminal();
                this.currentTerminal.setName(currentTerminalName);
                this.currentTerminal.setLocation(this.peek().startLocation);
                this.currentGrammar.addGrammarElement(this.currentTerminal);
                break;
            }
            case TYPE_ELEMENT: {
                break;
            }
            case MACRO_REF_ELEMENT: {
                String grammar = attributes.getValue("grammar");
                CopperElementName grammarName = grammar == null || grammar.equals("") ? this.currentGrammar.getName() : CopperElementName.newName(grammar);
                this.peek().regexChildren = new ArrayList();
                this.peek().regexChildren.add(new MacroHoleRegex(CopperElementReference.ref(grammarName, CopperElementName.newName(attributes.getValue("id")), (Location)this.peek().startLocation)));
                break;
            }
            case NONTERMINAL_REF_ELEMENT: 
            case TERMINAL_REF_ELEMENT: {
                if (this.varNames != null) {
                    String varName = attributes.getValue("name");
                    if (varName == null || varName.equals("")) {
                        this.varNames.add(null);
                    } else {
                        this.varNames.add(varName);
                    }
                }
            }
            case OPERATOR_CLASS_REF_ELEMENT: 
            case TERMINAL_CLASS_REF_ELEMENT: 
            case PRODUCTION_REF_ELEMENT: {
                String grammar = attributes.getValue("grammar");
                CopperElementName grammarName = grammar == null || grammar.equals("") ? this.currentGrammar.getName() : CopperElementName.newName(grammar);
                (this.refList != null ? this.refList : this.refSet).add(CopperElementReference.ref(grammarName, CopperElementName.newName(attributes.getValue("id")), (Location)this.peek().startLocation));
                break;
            }
            case GRAMMAR_REF_ELEMENT: {
                (this.refList != null ? this.refList : this.refSet).add(CopperElementReference.ref(CopperElementName.newName(attributes.getValue("id")), (Location)this.peek().startLocation));
                break;
            }
            default: {
                this.logger.logError(new GenericLocatedMessage(CompilerLevel.QUIET, this.peek().startLocation, "Unrecognized XML tag '" + localName + "'. There is a bug in Copper's XML schema.", true, true));
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        this.charactersInner(ch, start, length);
    }

    private void charactersInner(char[] ch, int start, int length) {
        switch (this.peek().type) {
            case CLASS_NAME_ELEMENT: 
            case CODE_ELEMENT: 
            case INTERFACE_NAME_ELEMENT: 
            case PACKAGE_ELEMENT: 
            case PP_ELEMENT: 
            case PRECEDENCE_ELEMENT: 
            case TYPE_ELEMENT: {
                if (this.peek() != this.lastTextNode) {
                    this.nodeText = "";
                    this.lastTextNode = this.peek();
                }
                this.nodeText = this.nodeText + String.copyValueOf(ch, start, length);
                break;
            }
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        try {
            this.endElementInner(uri, localName, qName);
        }
        catch (CopperException ex) {
            this.error(new SAXParseException(ex.getMessage(), this.locator));
        }
    }

    private void endElementInner(String uri, String localName, String qName) throws CopperException {
        SAXStackElement element = this.pop();
        block0 : switch (element.type) {
            case BRIDGE_PRODUCTIONS_ELEMENT: {
                for (CopperElementReference ref : this.refSet) {
                    if (ref.isFQ() && !ref.getGrammarName().equals(this.currentExtensionGrammar.getName())) {
                        this.logger.logError(new GenericLocatedMessage(CompilerLevel.QUIET, element.startLocation, "Only local references are allowed in <" + element.type.getName() + "> elements", true, false));
                        continue;
                    }
                    this.currentExtensionGrammar.addBridgeProduction(ref.getName());
                }
                this.refSet = null;
                break;
            }
            case CHARACTER_RANGE_ELEMENT: {
                break;
            }
            case CHARACTER_SET_ELEMENT: {
                CharacterSetRegex cset = (CharacterSetRegex)element.regexChildren.get(0);
                if (element.invertCharacterSet) {
                    cset.invert();
                }
                this.peek().regexChildren.add(cset);
                break;
            }
            case CHOICE_ELEMENT: {
                ChoiceRegex newChoiceBean = new ChoiceRegex();
                newChoiceBean.setSubexps(element.regexChildren);
                this.peek().regexChildren.add(newChoiceBean);
                break;
            }
            case CLASS_AUXILIARY_CODE_ELEMENT: {
                this.getCurrentParser().setParserClassAuxCode(this.nodeText);
                break;
            }
            case CLASS_ELEMENT: {
                switch (this.peek().type) {
                    case OPERATOR_ELEMENT: {
                        if (!this.refList.isEmpty()) {
                            this.currentTerminal.setOperatorClass(this.refList.get(0));
                        }
                        this.refList = null;
                        break block0;
                    }
                    case PRODUCTION_ELEMENT: {
                        if (!this.refList.isEmpty()) {
                            this.currentProduction.setPrecedenceClass(this.refList.get(0));
                        }
                        this.refList = null;
                        break block0;
                    }
                }
                break;
            }
            case CLASS_NAME_ELEMENT: {
                this.getCurrentParser().setClassName(this.nodeText);
                break;
            }
            case CODE_ELEMENT: {
                switch (this.peek().type) {
                    case DISAMBIGUATION_FUNCTION_ELEMENT: {
                        this.currentDisambiguationFunction.setCode(this.nodeText);
                        break block0;
                    }
                    case PARSER_ATTRIBUTE_ELEMENT: {
                        this.currentParserAttribute.setCode(this.nodeText);
                        break block0;
                    }
                    case PRODUCTION_ELEMENT: {
                        this.currentProduction.setCode(this.nodeText);
                        break block0;
                    }
                    case TERMINAL_ELEMENT: {
                        this.currentTerminal.setCode(this.nodeText);
                        break block0;
                    }
                }
                break;
            }
            case CONCATENATION_ELEMENT: {
                ConcatenationRegex newConcatenationBean = new ConcatenationRegex();
                newConcatenationBean.setSubexps(element.regexChildren);
                this.peek().regexChildren.add(newConcatenationBean);
                break;
            }
            case COPPER_SPEC_ELEMENT: {
                break;
            }
            case DECLARATIONS_ELEMENT: {
                break;
            }
            case DEFAULT_PRODUCTION_CODE_ELEMENT: {
                this.getCurrentParser().setDefaultProductionCode(this.nodeText);
                break;
            }
            case DEFAULT_TERMINAL_CODE_ELEMENT: {
                this.getCurrentParser().setDefaultTerminalCode(this.nodeText);
                break;
            }
            case DISAMBIGUATE_TO_ELEMENT: {
                this.currentDisambiguationFunction.setDisambiguateTo(this.refList.get(0));
                this.refList = null;
                break;
            }
            case DISAMBIGUATION_FUNCTION_ELEMENT: {
                this.currentDisambiguationFunction = null;
                break;
            }
            case DOMINATES_ELEMENT: {
                this.currentTerminal.setDominateList(this.refSet);
                this.refSet = null;
                break;
            }
            case EMPTY_STRING_REGEX_ELEMENT: {
                this.peek().regexChildren.add(new EmptyStringRegex());
                break;
            }
            case EXTENSION_GRAMMARS_ELEMENT: {
                for (CopperElementReference ref : this.refSet) {
                    if (!this.grammars.containsKey(ref.getName())) {
                        this.grammars.put(ref.getName(), new ExtensionGrammar());
                        ((Grammar)this.grammars.get(ref.getName())).setName(ref.getName());
                    }
                    this.getCurrentParser().addGrammar((Grammar)this.grammars.get(ref.getName()));
                }
                this.refSet = null;
                break;
            }
            case GRAMMARS_ELEMENT: {
                for (CopperElementReference ref : this.refSet) {
                    if (!this.grammars.containsKey(ref.getName())) {
                        this.grammars.put(ref.getName(), new Grammar());
                        ((Grammar)this.grammars.get(ref.getName())).setName(ref.getName());
                    }
                    this.getCurrentParser().addGrammar((Grammar)this.grammars.get(ref.getName()));
                }
                this.refSet = null;
                break;
            }
            case EXTENSION_GRAMMAR_ELEMENT: {
                this.currentExtensionGrammar = null;
            }
            case GRAMMAR_ELEMENT: {
                this.currentGrammar = null;
                break;
            }
            case GRAMMAR_REF_ELEMENT: {
                break;
            }
            case HOST_GRAMMAR_ELEMENT: {
                CopperElementReference ref = this.refList.get(0);
                if (!this.grammars.containsKey(ref.getName())) {
                    this.grammars.put(ref.getName(), new Grammar());
                    ((Grammar)this.grammars.get(ref.getName())).setName(ref.getName());
                }
                this.getCurrentParser().addGrammar((Grammar)this.grammars.get(ref.getName()));
                this.currentExtendedParser.setHostGrammar(ref.getName());
                this.refList = null;
                break;
            }
            case IN_CLASSES_ELEMENT: {
                this.currentTerminal.setTerminalClasses(this.refSet);
                this.refSet = null;
                break;
            }
            case INTERFACE_NAME_ELEMENT: {
                this.interfaceNames.add(this.nodeText);
                break;
            }
            case INTERFACE_NAMES_ELEMENT: {
                this.getCurrentParser().setInterfaceNames(this.interfaceNames);
                this.interfaceNames = null;
                break;
            }
            case KLEENE_STAR_ELEMENT: {
                this.peek().regexChildren.add(new KleeneStarRegex(element.regexChildren.get(0)));
                break;
            }
            case LAYOUT_ELEMENT: {
                switch (this.peek().type) {
                    case GRAMMAR_ELEMENT: {
                        this.currentGrammar.setGrammarLayout(this.refSet);
                        this.refSet = null;
                        break block0;
                    }
                    case EXTENSION_GRAMMAR_ELEMENT: {
                        this.currentGrammar.setGrammarLayout(this.refSet);
                        this.refSet = null;
                        break block0;
                    }
                    case PRODUCTION_ELEMENT: {
                        this.currentProduction.setLayout(this.refSet);
                        this.refSet = null;
                        break block0;
                    }
                }
                break;
            }
            case LEFT_ASSOCIATIVE_ELEMENT: {
                break;
            }
            case LHS_ELEMENT: {
                this.currentProduction.setLhs(this.refList.get(0));
                this.refList = null;
                break;
            }
            case MACRO_REF_ELEMENT: {
                this.peek().regexChildren.add(element.regexChildren.get(0));
                break;
            }
            case MARKING_TERMINALS_ELEMENT: {
                for (CopperElementReference ref1 : this.refSet) {
                    if (ref1.isFQ() && !ref1.getGrammarName().equals(this.currentExtensionGrammar.getName())) {
                        this.logger.logError(new GenericLocatedMessage(CompilerLevel.QUIET, element.startLocation, "Only local references are allowed in <" + element.type.getName() + "> elements", true, false));
                    }
                    this.currentExtensionGrammar.addMarkingTerminal(ref1.getName());
                }
                this.refSet = null;
                break;
            }
            case MEMBERS_ELEMENT: {
                switch (this.peek().type) {
                    case DISAMBIGUATION_FUNCTION_ELEMENT: {
                        this.currentDisambiguationFunction.setMembers(this.refSet);
                        break;
                    }
                    case TERMINAL_CLASS_ELEMENT: {
                        this.currentTerminalClass.setMembers(this.refSet);
                        break;
                    }
                }
                this.refSet = null;
                break;
            }
            case NONTERMINAL_ELEMENT: {
                this.currentNonTerminal = null;
                break;
            }
            case NONTERMINAL_REF_ELEMENT: {
                break;
            }
            case NON_ASSOCIATIVE_ELEMENT: {
                break;
            }
            case OPERATOR_ELEMENT: {
                if (this.peek().type != XMLSkinElements.Type.PRODUCTION_ELEMENT) break;
                this.currentProduction.setOperator(this.refList.get(0));
                this.refSet = null;
                break;
            }
            case OPERATOR_CLASS_ELEMENT: {
                this.currentOperatorClass = null;
                break;
            }
            case OPERATOR_CLASS_REF_ELEMENT: {
                break;
            }
            case PACKAGE_ELEMENT: {
                this.getCurrentParser().setPackageDecl(this.nodeText);
                break;
            }
            case PARSER_ATTRIBUTE_ELEMENT: {
                this.currentParserAttribute = null;
                break;
            }
            case EXTENDED_PARSER_ELEMENT: 
            case PARSER_ELEMENT: {
                break;
            }
            case PARSER_INIT_CODE_ELEMENT: {
                this.getCurrentParser().setParserInitCode(this.nodeText);
                break;
            }
            case POST_PARSE_CODE_ELEMENT: {
                this.getCurrentParser().setPostParseCode(this.nodeText);
                break;
            }
            case PP_ELEMENT: {
                switch (this.peek().type) {
                    case DISAMBIGUATION_FUNCTION_ELEMENT: {
                        this.currentDisambiguationFunction.setDisplayName(this.nodeText);
                        break block0;
                    }
                    case GRAMMAR_ELEMENT: {
                        this.currentGrammar.setDisplayName(this.nodeText);
                        break block0;
                    }
                    case OPERATOR_CLASS_ELEMENT: {
                        this.currentOperatorClass.setDisplayName(this.nodeText);
                        break block0;
                    }
                    case PARSER_ATTRIBUTE_ELEMENT: {
                        this.currentParserAttribute.setDisplayName(this.nodeText);
                        break block0;
                    }
                    case PARSER_ELEMENT: {
                        this.getCurrentParser().setDisplayName(this.nodeText);
                        break block0;
                    }
                    case PRODUCTION_ELEMENT: {
                        this.currentProduction.setDisplayName(this.nodeText);
                        break block0;
                    }
                    case NONTERMINAL_ELEMENT: {
                        this.currentNonTerminal.setDisplayName(this.nodeText);
                        break block0;
                    }
                    case TERMINAL_ELEMENT: {
                        this.currentTerminal.setDisplayName(this.nodeText);
                        break block0;
                    }
                    case TERMINAL_CLASS_ELEMENT: {
                        this.currentTerminalClass.setDisplayName(this.nodeText);
                        break block0;
                    }
                }
                break;
            }
            case PREAMBLE_ELEMENT: {
                this.getCurrentParser().setPreambleCode(this.nodeText);
                break;
            }
            case PRECEDENCE_ELEMENT: {
                switch (this.peek().type) {
                    case OPERATOR_ELEMENT: {
                        this.currentTerminal.setOperatorPrecedence(Integer.valueOf(this.nodeText));
                        break block0;
                    }
                    case PRODUCTION_ELEMENT: {
                        this.currentProduction.setPrecedence(Integer.valueOf(this.nodeText));
                        break block0;
                    }
                }
                break;
            }
            case PREFIX_ELEMENT: {
                this.currentTerminal.setPrefix(this.refList.get(0));
                this.refList = null;
                break;
            }
            case PRODUCTION_ELEMENT: {
                this.currentProduction = null;
                break;
            }
            case PRODUCTION_REF_ELEMENT: {
                break;
            }
            case REGEX_ELEMENT: {
                this.currentTerminal.setRegex(element.regexChildren.get(0));
                break;
            }
            case RHS_ELEMENT: {
                this.currentProduction.setRhs(this.refList);
                this.currentProduction.setRhsVarNames(this.varNames);
                this.refList = null;
                this.varNames = null;
                break;
            }
            case RIGHT_ASSOCIATIVE_ELEMENT: {
                break;
            }
            case SEMANTIC_ACTION_AUXILIARY_CODE_ELEMENT: {
                this.getCurrentParser().setSemanticActionAuxCode(this.nodeText);
                break;
            }
            case SINGLE_CHARACTER_ELEMENT: {
                break;
            }
            case START_LAYOUT_ELEMENT: {
                this.getCurrentParser().setStartLayout(this.refSet);
                this.refSet = null;
                break;
            }
            case START_SYMBOL_ELEMENT: {
                this.getCurrentParser().setStartSymbol(this.refList.get(0));
                this.refList = null;
                break;
            }
            case SUBMITS_ELEMENT: {
                this.currentTerminal.setSubmitList(this.refSet);
                this.refSet = null;
                break;
            }
            case TERMINAL_CLASS_ELEMENT: {
                this.currentTerminalClass = null;
                break;
            }
            case TERMINAL_CLASS_REF_ELEMENT: {
                break;
            }
            case TERMINAL_ELEMENT: {
                this.currentTerminal = null;
                break;
            }
            case TERMINAL_REF_ELEMENT: {
                break;
            }
            case TYPE_ELEMENT: {
                switch (this.peek().type) {
                    case NONTERMINAL_ELEMENT: {
                        this.currentNonTerminal.setReturnType(this.nodeText);
                        break block0;
                    }
                    case PARSER_ATTRIBUTE_ELEMENT: {
                        this.currentParserAttribute.setAttributeType(this.nodeText);
                        break block0;
                    }
                    case TERMINAL_ELEMENT: {
                        this.currentTerminal.setReturnType(this.nodeText);
                        break block0;
                    }
                }
                break;
            }
            default: {
                this.logger.logError(new GenericLocatedMessage(CompilerLevel.QUIET, this.peek().startLocation, "Unrecognized XML tag '" + localName + "'. There is a bug in Copper's XML schema.", true, true));
            }
        }
    }

    private static class SAXStackElement {
        public XMLSkinElements.Type type;
        public InputPosition startLocation;
        public ArrayList<Regex> regexChildren;
        public boolean invertCharacterSet;

        public SAXStackElement(XMLSkinElements.Type type, InputPosition startLocation) {
            this.type = type;
            this.startLocation = startLocation;
            this.regexChildren = null;
            this.invertCharacterSet = false;
        }
    }
}

