/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.ConsCell;
import common.Thunk;

public class AppendCell
extends ConsCell {
    private boolean literalConsCell = false;

    private AppendCell(ConsCell l, Object r) {
        super(l, r);
        assert (!(l instanceof ConsCell.NilConsCell));
        assert (!(l instanceof AppendCell) || ((AppendCell)l).literalConsCell);
    }

    public static final ConsCell append(Object l, Object r) {
        ConsCell left;
        if (l instanceof Thunk) {
            l = ((Thunk)l).eval();
        }
        if ((left = (ConsCell)l).nil()) {
            if (r instanceof Thunk) {
                r = ((Thunk)r).eval();
            }
            ConsCell right = (ConsCell)r;
            return right;
        }
        if (left instanceof AppendCell) {
            AppendCell leftap = (AppendCell)left;
            Object rightap = r;
            if (!leftap.literalConsCell) {
                Object leftaptail = leftap.tail;
                return AppendCell.append(leftap.head, new Thunk<ConsCell>(() -> AppendCell.append(leftaptail, rightap)));
            }
        }
        return new AppendCell(left, r);
    }

    private final void becomeLiteralConsCell() {
        assert (!this.literalConsCell);
        ConsCell left = (ConsCell)this.head;
        this.head = left.head();
        Object oldtail = this.tail;
        this.tail = new Thunk<ConsCell>(() -> AppendCell.append(left.tail(), oldtail));
        this.literalConsCell = true;
    }

    @Override
    public Object head() {
        if (this.literalConsCell) {
            return super.head();
        }
        this.becomeLiteralConsCell();
        return super.head();
    }

    @Override
    public ConsCell tail() {
        if (this.literalConsCell) {
            return super.tail();
        }
        this.becomeLiteralConsCell();
        return super.tail();
    }

    @Override
    public boolean nil() {
        return false;
    }

    @Override
    public int length() {
        if (this.literalConsCell) {
            return super.length();
        }
        return ((ConsCell)super.head()).length() + super.tail().length();
    }
}

