/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.AppTypeRep;
import common.FunctionTypeRep;
import common.NodeFactory;
import common.OriginContext;
import common.TypeRep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

public class PartialNameNodeFactory<T>
extends NodeFactory<T> {
    final NodeFactory<? extends T> ref;
    final int[] iConvertedToOrdered;
    final int[] iSuppliedHere;
    final Object[] args;

    public PartialNameNodeFactory(NodeFactory<? extends T> ref, int[] iConvertedToOrdered, int[] iSuppliedHere, Object[] args) {
        this.ref = ref;
        this.iConvertedToOrdered = iConvertedToOrdered == null ? new int[]{} : iConvertedToOrdered;
        this.iSuppliedHere = iSuppliedHere == null ? new int[]{} : iSuppliedHere;
        this.args = args;
    }

    @Override
    public T invoke(OriginContext originCtx, Object[] restargs, Object[] namedArgs) {
        int i;
        int numConverted = this.iConvertedToOrdered.length;
        int newArgsLength = restargs.length - numConverted;
        Object[] finalArgs = restargs.length == newArgsLength ? restargs : Arrays.copyOf(restargs, newArgsLength);
        int namedArgsLen = namedArgs == null ? 0 : namedArgs.length;
        int argsLen = this.args == null ? 0 : this.args.length;
        int fullNamedArgsSize = numConverted + namedArgsLen + argsLen;
        Object[] fullNamedArgs = new Object[fullNamedArgsSize];
        for (i = newArgsLength; i < restargs.length; ++i) {
            fullNamedArgs[this.iConvertedToOrdered[i - newArgsLength]] = restargs[i];
        }
        for (i = 0; i < argsLen; ++i) {
            fullNamedArgs[this.iSuppliedHere[i]] = this.args[i];
        }
        int namedArgsIndex = 0;
        for (i = 0; i < fullNamedArgsSize && namedArgsIndex < namedArgsLen; ++i) {
            if (fullNamedArgs[i] != null) continue;
            fullNamedArgs[i] = namedArgs[namedArgsIndex++];
        }
        return this.ref.invoke(originCtx, finalArgs, fullNamedArgs);
    }

    @Override
    public final TypeRep getType() {
        LinkedList<TypeRep> typeArgs = new LinkedList<TypeRep>();
        TypeRep a = this.ref.getType();
        while (a instanceof AppTypeRep) {
            typeArgs.add(0, ((AppTypeRep)a).arg);
            a = ((AppTypeRep)a).cons;
        }
        FunctionTypeRep fnType = (FunctionTypeRep)a;
        List params = typeArgs.subList(0, fnType.params);
        List namedParamTypes = typeArgs.subList(fnType.params, fnType.params + fnType.namedParams.length);
        TypeRep resultType = (TypeRep)typeArgs.get(fnType.params + fnType.namedParams.length);
        LinkedList newArgs = new LinkedList();
        newArgs.addAll(params);
        for (int i = 0; i < this.iConvertedToOrdered.length; ++i) {
            newArgs.add((TypeRep)namedParamTypes.get(this.iConvertedToOrdered[i]));
        }
        HashSet<Integer> iConvertedToOrderedSet = new HashSet<Integer>(this.iConvertedToOrdered.length);
        for (int i : this.iConvertedToOrdered) {
            iConvertedToOrderedSet.add(i);
        }
        String[] newNamedParams = new String[fnType.namedParams.length - (this.iConvertedToOrdered.length + this.iSuppliedHere.length)];
        ArrayList<TypeRep> newNamedParamTypes = new ArrayList<TypeRep>(newNamedParams.length);
        int i = 0;
        int j = 0;
        int k = 0;
        while (k < newNamedParams.length) {
            if (i < this.iSuppliedHere.length && i + j + k == this.iSuppliedHere[i]) {
                ++i;
                continue;
            }
            if (iConvertedToOrderedSet.contains(j)) {
                ++j;
                continue;
            }
            newNamedParams[k] = fnType.namedParams[i + j + k];
            newNamedParamTypes.set(k, (TypeRep)namedParamTypes.get(i + j + k));
            ++k;
        }
        newArgs.addAll(newNamedParamTypes);
        newArgs.add(resultType);
        TypeRep result = new FunctionTypeRep(fnType.params + this.iConvertedToOrdered.length, newNamedParams);
        for (TypeRep arg : newArgs) {
            result = new AppTypeRep(result, arg);
        }
        return result;
    }

    public final String toString() {
        return "partial named application of " + this.ref.toString();
    }
}

