/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.copper.compiletime.scannerdfa;

import edu.umn.cs.melt.copper.compiletime.auxiliary.SetOfCharsSyntax;
import edu.umn.cs.melt.copper.compiletime.auxiliary.SetTiling;
import edu.umn.cs.melt.copper.compiletime.scannerdfa.GeneralizedDFA;
import edu.umn.cs.melt.copper.compiletime.scannerdfa.GeneralizedDFABuilder;
import edu.umn.cs.melt.copper.compiletime.scannerdfa.GeneralizedFA;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeSet;

public class GeneralizedNFA
extends GeneralizedFA {
    private static final long serialVersionUID = -6346939067775842570L;
    private BitSet[][] transitions;

    @Override
    public void lengthenArrays() {
        BitSet[] newAcceptStates = new BitSet[2 * this.acceptStates.length];
        System.arraycopy(this.acceptStates, 0, newAcceptStates, 0, this.acceptStates.length);
        this.acceptStates = newAcceptStates;
        BitSet[][] newTransitions = new BitSet[2 * this.transitions.length][this.alphabetSize + 1];
        System.arraycopy(this.transitions, 0, newTransitions, 0, this.transitions.length);
        this.transitions = newTransitions;
    }

    public GeneralizedNFA(int numRegexes, int alphabetSize) {
        super(numRegexes, alphabetSize);
        int initialArraySizes = this.getInitialArraySizes(numRegexes);
        this.transitions = new BitSet[initialArraySizes][alphabetSize + 1];
    }

    private boolean prepareTransitionDest(SetOfCharsSyntax chars, int src) {
        int charRangeNumber;
        if (src >= this.stateCount()) {
            return false;
        }
        if (!this.charRangeNumbers.containsKey(chars)) {
            this.charRangeNumbers.put(chars, this.nextNewCharRangeNumber);
            this.charRanges[this.nextNewCharRangeNumber] = chars;
            charRangeNumber = this.nextNewCharRangeNumber++;
        } else {
            charRangeNumber = (Integer)this.charRangeNumbers.get(chars);
        }
        if (this.transitions[src][charRangeNumber] == null) {
            BitSet destSet;
            this.transitions[src][charRangeNumber] = destSet = new BitSet(this.stateCount() + 1);
        } else {
            BitSet destSet = this.transitions[src][charRangeNumber];
        }
        return true;
    }

    @Override
    public boolean addTransition(SetOfCharsSyntax chars, int src, int dest) {
        if (dest >= this.stateCount() || !this.prepareTransitionDest(chars, src)) {
            return false;
        }
        this.transitions[src][(Integer)this.charRangeNumbers.get(chars)].set(dest);
        return true;
    }

    public boolean addEpsilonTransition(int src, int dest) {
        return this.addTransition(new SetOfCharsSyntax(), src, dest);
    }

    public boolean addTransitions(SetOfCharsSyntax chars, int src, BitSet dests) {
        if (dests.nextSetBit(this.stateCount()) != -1 || !this.prepareTransitionDest(chars, src)) {
            return false;
        }
        this.transitions[src][(Integer)this.charRangeNumbers.get(chars)].or(dests);
        return true;
    }

    public boolean addEpsilonTransitions(int src, BitSet dests) {
        return this.addTransitions(new SetOfCharsSyntax(), src, dests);
    }

    public GeneralizedDFA determinize(int start) {
        Hashtable<BitSet, BitSet> memoizedEpsClosures = new Hashtable<BitSet, BitSet>();
        Hashtable<BitSet, Integer> mergedStateNames = new Hashtable<BitSet, Integer>();
        BitSet startStates = new BitSet(this.nextNewStateNumber);
        startStates.set(start);
        GeneralizedDFABuilder dfa = new GeneralizedDFABuilder(this.nextNewStateNumber, this.charRanges.length);
        SetTiling<SetOfCharsSyntax> tiledCharSets = GeneralizedNFA.tileCharSets(this.charRanges);
        LinkedList<BitSet> stateQueue = new LinkedList<BitSet>();
        startStates = this.getEpsilonClosure(memoizedEpsClosures, startStates);
        int dfaStartStateNumber = dfa.addState();
        mergedStateNames.put(startStates, dfaStartStateNumber);
        BitSet startAccepts = new BitSet();
        int i = startStates.nextSetBit(0);
        while (i >= 0) {
            if (this.acceptStates[i] != null) {
                startAccepts.or(this.acceptStates[i]);
            }
            i = startStates.nextSetBit(i + 1);
        }
        dfa.addAcceptSymbols(dfaStartStateNumber, startAccepts);
        dfa.setStartState(dfaStartStateNumber);
        stateQueue.offer(startStates);
        while (!stateQueue.isEmpty()) {
            BitSet front = (BitSet)stateQueue.poll();
            Hashtable<Integer, BitSet> allNFATransitions = new Hashtable<Integer, BitSet>();
            for (int i2 = 1; i2 < this.nextNewCharRangeNumber; ++i2) {
                int j = front.nextSetBit(0);
                while (j >= 0) {
                    if (this.transitions[j][i2] != null) {
                        if (!allNFATransitions.containsKey(i2)) {
                            allNFATransitions.put(i2, new BitSet(this.nextNewStateNumber));
                        }
                        ((BitSet)allNFATransitions.get(i2)).or(this.transitions[j][i2]);
                    }
                    j = front.nextSetBit(j + 1);
                }
            }
            Hashtable<Integer, BitSet> allDFATransitions = new Hashtable<Integer, BitSet>();
            Iterator iterator = allNFATransitions.keySet().iterator();
            while (iterator.hasNext()) {
                int k = (Integer)iterator.next();
                BitSet tiles = tiledCharSets.getAllTilesCovering(k);
                int i3 = tiles.nextSetBit(0);
                while (i3 >= 0) {
                    if (!allDFATransitions.containsKey(i3)) {
                        allDFATransitions.put(i3, new BitSet(this.nextNewStateNumber));
                    }
                    ((BitSet)allDFATransitions.get(i3)).or((BitSet)allNFATransitions.get(k));
                    i3 = tiles.nextSetBit(i3 + 1);
                }
            }
            iterator = allDFATransitions.keySet().iterator();
            while (iterator.hasNext()) {
                int newDFAState;
                int i4 = (Integer)iterator.next();
                BitSet newDestSet = (BitSet)allDFATransitions.get(i4);
                newDestSet = this.getEpsilonClosure(memoizedEpsClosures, newDestSet);
                BitSet newAcceptSet = new BitSet(this.nextAcceptSymbolNumber);
                int j = newDestSet.nextSetBit(0);
                while (j >= 0) {
                    if (this.acceptStates[j] != null) {
                        newAcceptSet.or(this.acceptStates[j]);
                    }
                    j = newDestSet.nextSetBit(j + 1);
                }
                if (mergedStateNames.containsKey(newDestSet)) {
                    newDFAState = (Integer)mergedStateNames.get(newDestSet);
                } else {
                    newDFAState = dfa.addState();
                    dfa.addAcceptSymbols(newDFAState, newAcceptSet);
                    mergedStateNames.put(newDestSet, newDFAState);
                    stateQueue.add(newDestSet);
                }
                dfa.addTransition(tiledCharSets.getTiledObject(i4), (Integer)mergedStateNames.get(front), newDFAState);
            }
        }
        return dfa.buildDFA();
    }

    public BitSet getEpsilonClosure(Hashtable<BitSet, BitSet> epsClosures, BitSet states) {
        if (epsClosures.containsKey(states)) {
            return epsClosures.get(states);
        }
        BitSet stateQueue = new BitSet(this.nextNewStateNumber);
        BitSet closure = new BitSet(this.nextNewStateNumber);
        epsClosures.put(states, closure);
        stateQueue.or(states);
        while (!stateQueue.isEmpty()) {
            int front = stateQueue.nextSetBit(0);
            stateQueue.clear(front);
            closure.set(front);
            if (this.transitions[front][0] == null) continue;
            BitSet intersection = (BitSet)this.transitions[front][0].clone();
            intersection.andNot(closure);
            stateQueue.or(intersection);
        }
        return closure;
    }

    public static SetTiling<SetOfCharsSyntax> tileCharSets(SetOfCharsSyntax ... sets) {
        Hashtable<BitSet, SetOfCharsSyntax> rv = new Hashtable<BitSet, SetOfCharsSyntax>();
        Hashtable<Character, BitSet> openingExtrema = new Hashtable<Character, BitSet>();
        Hashtable<Character, BitSet> closingExtrema = new Hashtable<Character, BitSet>();
        for (int i = 0; i < sets.length; ++i) {
            char[][] members = sets[i].getMembers();
            for (int j = 0; j < members.length; ++j) {
                if (!openingExtrema.containsKey(Character.valueOf(members[j][0]))) {
                    openingExtrema.put(Character.valueOf(members[j][0]), new BitSet(sets.length));
                }
                if (!closingExtrema.containsKey(Character.valueOf(members[j][1]))) {
                    closingExtrema.put(Character.valueOf(members[j][1]), new BitSet(sets.length));
                }
                ((BitSet)openingExtrema.get(Character.valueOf(members[j][0]))).set(i);
                ((BitSet)closingExtrema.get(Character.valueOf(members[j][1]))).set(i);
            }
        }
        TreeSet allExtremaS = new TreeSet();
        allExtremaS.addAll(openingExtrema.keySet());
        allExtremaS.addAll(closingExtrema.keySet());
        Character[] allExtrema = new Character[allExtremaS.size()];
        allExtremaS.toArray(allExtrema);
        BitSet on = new BitSet(sets.length);
        for (int i = 0; i < allExtrema.length; ++i) {
            SetOfCharsSyntax toPut;
            if (i != 0 && allExtrema[i - 1].charValue() + '\u0001' != allExtrema[i].charValue() && !on.isEmpty()) {
                toPut = new SetOfCharsSyntax((char)(allExtrema[i - 1].charValue() + '\u0001'), (char)(allExtrema[i].charValue() - '\u0001'));
                if (rv.containsKey(on)) {
                    toPut = SetOfCharsSyntax.union((SetOfCharsSyntax)rv.get(on), toPut);
                }
                rv.put((BitSet)on.clone(), toPut);
            }
            if (openingExtrema.containsKey(allExtrema[i])) {
                on.or((BitSet)openingExtrema.get(allExtrema[i]));
            }
            if (!on.isEmpty()) {
                toPut = new SetOfCharsSyntax(allExtrema[i].charValue(), allExtrema[i].charValue());
                if (rv.containsKey(on)) {
                    toPut = SetOfCharsSyntax.union((SetOfCharsSyntax)rv.get(on), toPut);
                }
                rv.put((BitSet)on.clone(), toPut);
            }
            if (!closingExtrema.containsKey(allExtrema[i])) continue;
            on.andNot((BitSet)closingExtrema.get(allExtrema[i]));
        }
        return new SetTiling<SetOfCharsSyntax>(rv);
    }

    public String toString() {
        int i;
        StringBuffer rv = new StringBuffer();
        rv.append("Character sets:\n");
        for (i = 0; i < this.nextNewCharRangeNumber; ++i) {
            rv.append(i + ": " + this.charRanges[i] + "\n");
        }
        for (i = 0; i < this.nextNewStateNumber; ++i) {
            rv.append("State " + i + ":\n  Transitions -");
            for (int j = 0; j < this.nextNewCharRangeNumber; ++j) {
                rv.append(" ").append(j).append(" -> ").append(this.transitions[i][j]);
            }
            rv.append("\n  Accepts: " + this.acceptStates[i]);
            rv.append("\n");
        }
        return rv.toString();
    }
}

