/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.copper.compiletime.auxiliary;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.TreeSet;

public class SetOfCharsSyntax
implements Serializable {
    private static final long serialVersionUID = -7073107634038068176L;
    private String stringRep = null;
    private int size = -1;
    private char[][] canonicalRanges;

    private SetOfCharsSyntax(char[][] canonicalRanges, boolean isSorted) {
        CharRange first;
        if (canonicalRanges.length == 0 || isSorted) {
            this.canonicalRanges = canonicalRanges;
            return;
        }
        if (canonicalRanges[0].length != 2) {
            throw new ArrayIndexOutOfBoundsException("Canonical range array's second dimension must be 2");
        }
        TreeSet<CharRange> ranges = new TreeSet<CharRange>();
        for (int i = 0; i < canonicalRanges.length; ++i) {
            if (canonicalRanges[i][0] > canonicalRanges[i][1]) continue;
            ranges.add(new CharRange(canonicalRanges[i][0], canonicalRanges[i][1]));
        }
        ArrayList<CharRange> newRanges = new ArrayList<CharRange>(ranges.size());
        Iterator it = ranges.iterator();
        CharRange last = first = (CharRange)it.next();
        while (it.hasNext()) {
            CharRange current = (CharRange)it.next();
            if (current.min - '\u0001' > last.max) {
                newRanges.add(new CharRange(first.min, last.max));
                first = current;
            }
            if (current.max <= last.max) continue;
            last = current;
        }
        newRanges.add(new CharRange(first.min, last.max));
        this.canonicalRanges = new char[newRanges.size()][2];
        for (int i = 0; i < newRanges.size(); ++i) {
            this.canonicalRanges[i][0] = ((CharRange)newRanges.get((int)i)).min;
            this.canonicalRanges[i][1] = ((CharRange)newRanges.get((int)i)).max;
        }
    }

    public SetOfCharsSyntax(char[][] canonicalRanges) {
        this(canonicalRanges, false);
    }

    public SetOfCharsSyntax(char lowerBound, char upperBound) {
        if (lowerBound > upperBound) {
            this.canonicalRanges = new char[0][2];
        } else {
            this.canonicalRanges = new char[1][2];
            this.canonicalRanges[0][0] = lowerBound;
            this.canonicalRanges[0][1] = upperBound;
        }
    }

    public SetOfCharsSyntax() {
        this.canonicalRanges = new char[0][2];
    }

    private static String charToString(char c) {
        return "U+" + Integer.toHexString(c);
    }

    public String toString() {
        if (this.stringRep == null) {
            this.stringRep = "";
            if (this.isEmpty()) {
                this.stringRep = this.stringRep + "EMPTY";
            }
            for (int i = 0; i < this.canonicalRanges.length; ++i) {
                this.stringRep = this.canonicalRanges[i][0] == this.canonicalRanges[i][1] ? this.stringRep + SetOfCharsSyntax.charToString(this.canonicalRanges[i][0]) : this.stringRep + SetOfCharsSyntax.charToString(this.canonicalRanges[i][0]) + "-" + SetOfCharsSyntax.charToString(this.canonicalRanges[i][1]);
                if (i >= this.canonicalRanges.length - 1) continue;
                this.stringRep = this.stringRep + ",";
            }
        }
        return this.stringRep;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public boolean equals(Object o) {
        return o instanceof SetOfCharsSyntax && this.toString().equals(((SetOfCharsSyntax)o).toString());
    }

    public char[][] getMembers() {
        return this.canonicalRanges;
    }

    public boolean isEmpty() {
        return this.canonicalRanges.length == 0;
    }

    public int size() {
        if (this.size != -1) {
            return this.size;
        }
        this.size = 0;
        for (int i = 0; i < this.canonicalRanges.length; ++i) {
            this.size += this.canonicalRanges[i][1] - this.canonicalRanges[i][0] + 1;
        }
        return this.size;
    }

    private static TreeMap<Character, Byte> mapExtrema(SetOfCharsSyntax left, SetOfCharsSyntax right) {
        int i;
        TreeMap<Character, Byte> extrema = new TreeMap<Character, Byte>();
        for (i = 0; i < left.canonicalRanges.length; ++i) {
            if (!extrema.containsKey(Character.valueOf(left.canonicalRanges[i][0]))) {
                extrema.put(Character.valueOf(left.canonicalRanges[i][0]), (byte)1);
            } else {
                extrema.put(Character.valueOf(left.canonicalRanges[i][0]), (byte)(extrema.get(Character.valueOf(left.canonicalRanges[i][0])) | 1));
            }
            if (!extrema.containsKey(Character.valueOf(left.canonicalRanges[i][1]))) {
                extrema.put(Character.valueOf(left.canonicalRanges[i][1]), (byte)2);
                continue;
            }
            extrema.put(Character.valueOf(left.canonicalRanges[i][1]), (byte)(extrema.get(Character.valueOf(left.canonicalRanges[i][1])) | 2));
        }
        for (i = 0; i < right.canonicalRanges.length; ++i) {
            if (!extrema.containsKey(Character.valueOf(right.canonicalRanges[i][0]))) {
                extrema.put(Character.valueOf(right.canonicalRanges[i][0]), (byte)4);
            } else {
                extrema.put(Character.valueOf(right.canonicalRanges[i][0]), (byte)(extrema.get(Character.valueOf(right.canonicalRanges[i][0])) | 4));
            }
            if (!extrema.containsKey(Character.valueOf(right.canonicalRanges[i][1]))) {
                extrema.put(Character.valueOf(right.canonicalRanges[i][1]), (byte)8);
                continue;
            }
            extrema.put(Character.valueOf(right.canonicalRanges[i][1]), (byte)(extrema.get(Character.valueOf(right.canonicalRanges[i][1])) | 8));
        }
        return extrema;
    }

    private static TreeMap<Character, Byte> mapExtremaSubtract(SetOfCharsSyntax left, SetOfCharsSyntax right) {
        TreeMap<Character, Byte> extrema = new TreeMap<Character, Byte>();
        for (int i = 0; i < left.canonicalRanges.length; ++i) {
            if (!extrema.containsKey(Character.valueOf(left.canonicalRanges[i][0]))) {
                extrema.put(Character.valueOf(left.canonicalRanges[i][0]), (byte)1);
            } else {
                extrema.put(Character.valueOf(left.canonicalRanges[i][0]), (byte)(extrema.get(Character.valueOf(left.canonicalRanges[i][0])) | 1));
            }
            if (!extrema.containsKey(Character.valueOf(left.canonicalRanges[i][1]))) {
                extrema.put(Character.valueOf(left.canonicalRanges[i][1]), (byte)2);
                continue;
            }
            extrema.put(Character.valueOf(left.canonicalRanges[i][1]), (byte)(extrema.get(Character.valueOf(left.canonicalRanges[i][1])) | 2));
        }
        boolean rightHasMin = false;
        boolean rightHasMax = false;
        for (int i = 0; i < right.canonicalRanges.length; ++i) {
            if (right.canonicalRanges[i][0] != '\u0000') {
                if (!extrema.containsKey(Character.valueOf((char)(right.canonicalRanges[i][0] - '\u0001')))) {
                    extrema.put(Character.valueOf((char)(right.canonicalRanges[i][0] - '\u0001')), (byte)8);
                } else {
                    extrema.put(Character.valueOf((char)(right.canonicalRanges[i][0] - '\u0001')), (byte)(extrema.get(Character.valueOf((char)(right.canonicalRanges[i][0] - '\u0001'))) | 8));
                }
            } else {
                rightHasMin = true;
            }
            if (right.canonicalRanges[i][1] != '\uffff') {
                if (!extrema.containsKey(Character.valueOf((char)(right.canonicalRanges[i][1] + '\u0001')))) {
                    extrema.put(Character.valueOf((char)(right.canonicalRanges[i][1] + '\u0001')), (byte)4);
                    continue;
                }
                extrema.put(Character.valueOf((char)(right.canonicalRanges[i][1] + '\u0001')), (byte)(extrema.get(Character.valueOf((char)(right.canonicalRanges[i][1] + '\u0001'))) | 4));
                continue;
            }
            rightHasMax = true;
        }
        if (!rightHasMin) {
            if (!extrema.containsKey(Character.valueOf('\u0000'))) {
                extrema.put(Character.valueOf('\u0000'), (byte)4);
            } else {
                extrema.put(Character.valueOf('\u0000'), (byte)(extrema.get(Character.valueOf('\u0000')) | 4));
            }
        }
        if (!rightHasMax) {
            if (!extrema.containsKey(Character.valueOf('\uffff'))) {
                extrema.put(Character.valueOf('\uffff'), (byte)8);
            } else {
                extrema.put(Character.valueOf('\uffff'), (byte)(extrema.get(Character.valueOf('\uffff')) | 8));
            }
        }
        return extrema;
    }

    private static char[][] clipRanges(char[][] ranges, int i) {
        if (i < ranges.length) {
            char[][] newRanges = new char[i][2];
            System.arraycopy(ranges, 0, newRanges, 0, i);
            return newRanges;
        }
        return ranges;
    }

    private static SetOfCharsSyntax operate(SetOperation operation, TreeMap<Character, Byte> extrema) {
        boolean leftOn = false;
        boolean leftTurnsOn = false;
        boolean leftTurnsOff = false;
        boolean rightOn = false;
        boolean rightTurnsOn = false;
        boolean rightTurnsOff = false;
        char[][] newCanonicalRanges = new char[extrema.size()][2];
        int i = 0;
        for (char extremum : extrema.keySet()) {
            leftTurnsOff = (extrema.get(Character.valueOf(extremum)) & 2) != 0;
            leftTurnsOn = (extrema.get(Character.valueOf(extremum)) & 1) != 0;
            rightTurnsOff = (extrema.get(Character.valueOf(extremum)) & 8) != 0;
            boolean bl = rightTurnsOn = (extrema.get(Character.valueOf(extremum)) & 4) != 0;
            if (operation.onLogic(leftOn, rightOn, leftTurnsOn, rightTurnsOn)) {
                if (i > 0 && extremum - newCanonicalRanges[i - 1][1] <= 1) {
                    --i;
                } else {
                    newCanonicalRanges[i][0] = extremum;
                }
            }
            leftOn = leftOn || leftTurnsOn;
            boolean bl2 = rightOn = rightOn || rightTurnsOn;
            if (operation.offLogic(leftOn, rightOn, leftTurnsOff, rightTurnsOff)) {
                newCanonicalRanges[i][1] = extremum;
                ++i;
            }
            leftOn = leftOn && !leftTurnsOff;
            rightOn = rightOn && !rightTurnsOff;
        }
        return new SetOfCharsSyntax(SetOfCharsSyntax.clipRanges(newCanonicalRanges, i), true);
    }

    public static SetOfCharsSyntax union(SetOfCharsSyntax augend, SetOfCharsSyntax addend) {
        return SetOfCharsSyntax.operate(SetOperation.UNION, SetOfCharsSyntax.mapExtrema(augend, addend));
    }

    public static SetOfCharsSyntax intersect(SetOfCharsSyntax lfactor, SetOfCharsSyntax rfactor) {
        return SetOfCharsSyntax.operate(SetOperation.INTERSECT, SetOfCharsSyntax.mapExtrema(lfactor, rfactor));
    }

    public static SetOfCharsSyntax subtract(SetOfCharsSyntax minuend, SetOfCharsSyntax subtrahend) {
        return SetOfCharsSyntax.operate(SetOperation.INTERSECT, SetOfCharsSyntax.mapExtremaSubtract(minuend, subtrahend));
    }

    public SetOfCharsSyntax invert(SetOfCharsSyntax universal) {
        return SetOfCharsSyntax.subtract(universal, this);
    }

    public SetOfCharsSyntax invert() {
        return this.invert(new SetOfCharsSyntax('\u0000', '\uffff'));
    }

    private static enum SetOperation {
        UNION{

            @Override
            public boolean onLogic(boolean leftOn, boolean rightOn, boolean leftTurnsOn, boolean rightTurnsOn) {
                return !leftOn && rightTurnsOn || !rightOn && leftTurnsOn;
            }

            @Override
            public boolean offLogic(boolean leftOn, boolean rightOn, boolean leftTurnsOff, boolean rightTurnsOff) {
                return !leftOn && rightTurnsOff || !rightOn && leftTurnsOff || leftTurnsOff && rightTurnsOff;
            }
        }
        ,
        INTERSECT{

            @Override
            public boolean onLogic(boolean leftOn, boolean rightOn, boolean leftTurnsOn, boolean rightTurnsOn) {
                return !(!leftTurnsOn && !leftOn || !rightTurnsOn && !rightOn || leftOn && rightOn);
            }

            @Override
            public boolean offLogic(boolean leftOn, boolean rightOn, boolean leftTurnsOff, boolean rightTurnsOff) {
                return leftOn && rightOn && (leftTurnsOff || rightTurnsOff);
            }
        };


        public abstract boolean onLogic(boolean var1, boolean var2, boolean var3, boolean var4);

        public abstract boolean offLogic(boolean var1, boolean var2, boolean var3, boolean var4);
    }

    private class Masks {
        public static final byte LEFT_TURNS_ON = 1;
        public static final byte LEFT_TURNS_OFF = 2;
        public static final byte RIGHT_TURNS_ON = 4;
        public static final byte RIGHT_TURNS_OFF = 8;

        private Masks() {
        }
    }

    private class CharRange
    implements Comparable<CharRange> {
        public char min;
        public char max;

        public CharRange(char min, char max) {
            this.min = min;
            this.max = max;
        }

        @Override
        public int compareTo(CharRange r) {
            if (this.min < r.min) {
                return -1;
            }
            if (this.min > r.min) {
                return 1;
            }
            if (this.max < r.max) {
                return -1;
            }
            if (this.max == r.max) {
                return 0;
            }
            return 1;
        }

        public boolean equals(Object rhs) {
            return rhs instanceof CharRange && this.min == ((CharRange)rhs).min && this.max == ((CharRange)rhs).max;
        }

        public String toString() {
            return this.min + "-" + this.max;
        }
    }
}

