/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.copper.compiletime.checkers;

import edu.umn.cs.melt.copper.compiletime.auxiliary.SymbolTable;
import edu.umn.cs.melt.copper.compiletime.logging.CompilerLevel;
import edu.umn.cs.melt.copper.compiletime.logging.CompilerLogger;
import edu.umn.cs.melt.copper.compiletime.logging.messages.ParseTableConflictMessage;
import edu.umn.cs.melt.copper.compiletime.parsetable.LRParseTable;
import edu.umn.cs.melt.copper.compiletime.parsetable.LRParseTableConflict;
import edu.umn.cs.melt.copper.compiletime.spec.grammarbeans.CopperASTBean;
import edu.umn.cs.melt.copper.compiletime.spec.numeric.GrammarStatistics;
import edu.umn.cs.melt.copper.compiletime.spec.numeric.ParserSpec;

public class ParseTableConflictChecker {
    private CompilerLogger logger;
    private SymbolTable<CopperASTBean> symbolTable;
    private ParserSpec spec;
    private LRParseTable parseTable;
    private GrammarStatistics stats;

    public static boolean check(CompilerLogger logger, SymbolTable<CopperASTBean> symbolTable, ParserSpec spec, LRParseTable parseTable, GrammarStatistics stats) {
        return new ParseTableConflictChecker(logger, symbolTable, spec, parseTable, stats).checkConflicts();
    }

    private ParseTableConflictChecker(CompilerLogger logger, SymbolTable<CopperASTBean> symbolTable, ParserSpec spec, LRParseTable parseTable, GrammarStatistics stats) {
        this.logger = logger;
        this.symbolTable = symbolTable;
        this.spec = spec;
        this.parseTable = parseTable;
        this.stats = stats;
    }

    private boolean checkConflicts() {
        boolean passed = true;
        this.stats.parseTableConflictCount = this.parseTable.getConflictCount();
        this.stats.shiftReduceParseTableConflictCount = 0;
        this.stats.reduceReduceParseTableConflictCount = 0;
        this.stats.unresolvedParseTableConflictCount = 0;
        for (int i = 0; i < this.parseTable.getConflictCount(); ++i) {
            boolean logConflict = this.logger.isLoggable(CompilerLevel.VERBOSE);
            LRParseTableConflict conflict = this.parseTable.getConflict(i);
            if (conflict.shift != -1) {
                ++this.stats.shiftReduceParseTableConflictCount;
            }
            if (conflict.reduce.cardinality() > 1) {
                ++this.stats.reduceReduceParseTableConflictCount;
            }
            if (this.parseTable.getActionType(conflict.getState(), conflict.getSymbol()) == 3) {
                ++this.stats.unresolvedParseTableConflictCount;
                logConflict = this.logger.isLoggable(CompilerLevel.QUIET);
                passed = false;
            }
            if (!logConflict) continue;
            this.logger.log(new ParseTableConflictMessage(this.symbolTable, this.spec, this.parseTable, conflict));
        }
        return passed;
    }
}

