/*
 * Decompiled with CFR 0.152.
 */
package zmq;

import java.util.ArrayList;
import java.util.List;
import zmq.Msg;
import zmq.Pipe;
import zmq.Utils;
import zmq.ValueReference;

public class LB {
    private final List<Pipe> pipes = new ArrayList<Pipe>();
    private int active = 0;
    private int current = 0;
    private boolean more = false;
    private boolean dropping = false;

    public void attach(Pipe pipe_) {
        this.pipes.add(pipe_);
        this.activated(pipe_);
    }

    public void terminated(Pipe pipe_) {
        int index = this.pipes.indexOf(pipe_);
        if (index == this.current && this.more) {
            this.dropping = true;
        }
        if (index < this.active) {
            --this.active;
            Utils.swap(this.pipes, index, this.active);
            if (this.current == this.active) {
                this.current = 0;
            }
        }
        this.pipes.remove(pipe_);
    }

    public void activated(Pipe pipe_) {
        Utils.swap(this.pipes, this.pipes.indexOf(pipe_), this.active);
        ++this.active;
    }

    public boolean send(Msg msg_, ValueReference<Integer> errno) {
        if (this.dropping) {
            this.dropping = this.more = msg_.hasMore();
            return true;
        }
        while (this.active > 0 && !this.pipes.get(this.current).write(msg_)) {
            assert (!this.more);
            --this.active;
            if (this.current < this.active) {
                Utils.swap(this.pipes, this.current, this.active);
                continue;
            }
            this.current = 0;
        }
        if (this.active == 0) {
            errno.set(35);
            return false;
        }
        this.more = msg_.hasMore();
        if (!this.more) {
            this.pipes.get(this.current).flush();
            if (this.active > 1) {
                this.current = (this.current + 1) % this.active;
            }
        }
        return true;
    }

    public boolean has_out() {
        if (this.more) {
            return true;
        }
        while (this.active > 0) {
            if (this.pipes.get(this.current).check_write()) {
                return true;
            }
            --this.active;
            Utils.swap(this.pipes, this.current, this.active);
            if (this.current != this.active) continue;
            this.current = 0;
        }
        return false;
    }
}

