/*
 * Decompiled with CFR 0.152.
 */
package zmq;

import zmq.Utils;

public class Trie {
    private int refcnt = 0;
    private byte min = 0;
    private int count = 0;
    private int live_nodes = 0;
    Trie[] next = null;

    public boolean add(byte[] prefix_) {
        return this.add(prefix_, 0);
    }

    public boolean add(byte[] prefix_, int start_) {
        if (prefix_ == null || prefix_.length == start_) {
            ++this.refcnt;
            return this.refcnt == 1;
        }
        byte c = prefix_[start_];
        if (c < this.min || c >= this.min + this.count) {
            if (this.count == 0) {
                this.min = c;
                this.count = 1;
                this.next = null;
            } else if (this.count == 1) {
                byte oldc = this.min;
                Trie oldp = this.next[0];
                this.count = (this.min < c ? c - this.min : this.min - c) + 1;
                this.next = new Trie[this.count];
                this.min = (byte)Math.min(this.min, c);
                this.next[oldc - this.min] = oldp;
            } else if (this.min < c) {
                this.count = c - this.min + 1;
                this.next = this.realloc(this.next, this.count, true);
            } else {
                this.count = this.min + this.count - c;
                this.next = this.realloc(this.next, this.count, false);
                this.min = c;
            }
        }
        if (this.count == 1) {
            if (this.next == null) {
                this.next = new Trie[1];
                this.next[0] = new Trie();
                ++this.live_nodes;
            }
            return this.next[0].add(prefix_, start_ + 1);
        }
        if (this.next[c - this.min] == null) {
            this.next[c - this.min] = new Trie();
            ++this.live_nodes;
        }
        return this.next[c - this.min].add(prefix_, start_ + 1);
    }

    private Trie[] realloc(Trie[] table, int size, boolean ended) {
        return Utils.realloc(Trie.class, table, size, ended);
    }

    public boolean rm(byte[] prefix_, int start_) {
        Trie next_node;
        if (prefix_ == null || prefix_.length == start_) {
            if (this.refcnt == 0) {
                return false;
            }
            --this.refcnt;
            return this.refcnt == 0;
        }
        byte c = prefix_[start_];
        if (this.count == 0 || c < this.min || c >= this.min + this.count) {
            return false;
        }
        Trie trie = next_node = this.count == 1 ? this.next[0] : this.next[c - this.min];
        if (next_node == null) {
            return false;
        }
        boolean ret = next_node.rm(prefix_, start_ + 1);
        if (next_node.is_redundant()) {
            assert (this.count > 0);
            if (this.count == 1) {
                this.next = null;
                this.count = 0;
                --this.live_nodes;
                assert (this.live_nodes == 0);
            } else {
                this.next[c - this.min] = null;
                assert (this.live_nodes > 1);
                --this.live_nodes;
                if (this.live_nodes == 1) {
                    Trie node = null;
                    for (int i = 0; i < this.count; ++i) {
                        if (this.next[i] == null) continue;
                        node = this.next[i];
                        this.min = (byte)(i + this.min);
                        break;
                    }
                    assert (node != null);
                    this.next = null;
                    this.next = new Trie[]{node};
                    this.count = 1;
                } else if (c == this.min) {
                    byte new_min = this.min;
                    for (int i = 1; i < this.count; ++i) {
                        if (this.next[i] == null) continue;
                        new_min = (byte)(i + this.min);
                        break;
                    }
                    assert (new_min != this.min);
                    assert (new_min > this.min);
                    assert (this.count > new_min - this.min);
                    this.count -= new_min - this.min;
                    this.next = this.realloc(this.next, this.count, true);
                    this.min = new_min;
                } else if (c == this.min + this.count - 1) {
                    int new_count = this.count;
                    for (int i = 1; i < this.count; ++i) {
                        if (this.next[this.count - 1 - i] == null) continue;
                        new_count = this.count - i;
                        break;
                    }
                    assert (new_count != this.count);
                    this.count = new_count;
                    this.next = this.realloc(this.next, this.count, false);
                }
            }
        }
        return ret;
    }

    public boolean check(byte[] data_) {
        Trie current = this;
        int start = 0;
        while (current.refcnt <= 0) {
            if (data_.length == start) {
                return false;
            }
            byte c = data_[start];
            if (c < current.min || c >= current.min + current.count) {
                return false;
            }
            if (current.count == 1) {
                current = current.next[0];
            } else {
                current = current.next[c - current.min];
                if (current == null) {
                    return false;
                }
            }
            ++start;
        }
        return true;
    }

    public void apply(ITrieHandler func, Object arg_) {
        this.apply_helper(null, 0, 0, func, arg_);
    }

    private void apply_helper(byte[] buff_, int buffsize_, int maxbuffsize_, ITrieHandler func_, Object arg_) {
        if (this.refcnt > 0) {
            func_.added(buff_, buffsize_, arg_);
        }
        if (buffsize_ >= maxbuffsize_) {
            maxbuffsize_ = buffsize_ + 256;
            buff_ = Utils.realloc(buff_, maxbuffsize_);
            assert (buff_ != null);
        }
        if (this.count == 0) {
            return;
        }
        if (this.count == 1) {
            buff_[buffsize_] = this.min;
            this.next[0].apply_helper(buff_, ++buffsize_, maxbuffsize_, func_, arg_);
            return;
        }
        for (int c = 0; c != this.count; ++c) {
            buff_[buffsize_] = (byte)(this.min + c);
            if (this.next[c] == null) continue;
            this.next[c].apply_helper(buff_, buffsize_ + 1, maxbuffsize_, func_, arg_);
        }
    }

    private boolean is_redundant() {
        return this.refcnt == 0 && this.live_nodes == 0;
    }

    public static interface ITrieHandler {
        public void added(byte[] var1, int var2, Object var3);
    }
}

