/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.copper.runtime.io;

import edu.umn.cs.melt.copper.runtime.io.ScannerBuffer;
import java.io.IOException;
import java.io.Reader;

class SlidingWindowScannerBuffer
extends ScannerBuffer {
    private static final int defaultInitialCapacity = 512;
    private Reader reader;
    private long bufferBegin;
    private long bufferEnd;
    private char[] circleBuffer;
    private int head;
    private int tail;
    private boolean eofReached;

    protected SlidingWindowScannerBuffer(Reader reader) {
        this.reader = reader;
        this.head = 0;
        this.tail = 0;
        this.circleBuffer = new char[512];
        this.bufferBegin = 0L;
        this.bufferEnd = 0L;
        this.eofReached = false;
    }

    @Override
    public char charAt(long pos) throws IOException {
        if (pos >= this.bufferEnd) {
            this.readNewChars((int)(pos - this.bufferEnd) + 1);
        }
        if (pos >= this.bufferEnd) {
            return EOFIndicator;
        }
        return this.circleBuffer[(this.head + (int)(pos - this.bufferBegin)) % this.circleBuffer.length];
    }

    @Override
    public void advanceBufferTo(long newBufferBegin) throws IOException {
        this.head = (this.head + (int)(newBufferBegin - this.bufferBegin)) % this.circleBuffer.length;
        this.bufferBegin = newBufferBegin;
        if (!this.eofReached && this.size() < this.circleBuffer.length / 2) {
            this.readNewChars(this.circleBuffer.length - this.size() - 1);
        }
    }

    private void readNewChars(int additionLength) throws IOException {
        if (additionLength == 0) {
            return;
        }
        int originalLength = this.size();
        if (originalLength + additionLength >= this.circleBuffer.length) {
            char[] newCircleBuffer = this.readBuffer(this.head, this.tail, Math.max(this.circleBuffer.length * 2, this.circleBuffer.length + additionLength));
            this.head = 0;
            this.tail = originalLength;
            this.circleBuffer = newCircleBuffer;
        }
        int readLength = 0;
        int readLength2 = 0;
        if (this.tail + additionLength > this.circleBuffer.length) {
            readLength = this.reader.read(this.circleBuffer, this.tail, this.circleBuffer.length - this.tail);
            if (readLength == this.circleBuffer.length - this.tail && (readLength2 = this.reader.read(this.circleBuffer, 0, additionLength - (this.circleBuffer.length - this.tail))) >= 0) {
                readLength += readLength2;
            }
        } else {
            readLength = this.reader.read(this.circleBuffer, this.tail, additionLength);
        }
        if (readLength < additionLength || readLength2 == -1) {
            this.eofReached = true;
        }
        if (readLength > 0) {
            this.bufferEnd += (long)readLength;
            this.tail = (this.tail + readLength) % this.circleBuffer.length;
        }
    }

    private char[] readBuffer(int head, int tail, int length) {
        char[] arrayRep = new char[length];
        if (tail > head) {
            System.arraycopy(this.circleBuffer, head, arrayRep, 0, tail - head);
        } else if (tail < head) {
            System.arraycopy(this.circleBuffer, head, arrayRep, 0, this.circleBuffer.length - head);
            System.arraycopy(this.circleBuffer, 0, arrayRep, this.circleBuffer.length - head, tail);
        }
        return arrayRep;
    }

    @Override
    public String readStringFromBuffer(long begin, long end) throws IOException {
        int length = (int)(end - begin);
        int head = (this.head + (int)(begin - this.bufferBegin)) % this.circleBuffer.length;
        int tail = (this.head + (int)(end - this.bufferBegin)) % this.circleBuffer.length;
        char[] arrayRep = this.readBuffer(head, tail, length);
        return new String(arrayRep);
    }

    private int size() {
        return (this.tail - this.head + this.circleBuffer.length) % this.circleBuffer.length;
    }
}

