/*
 * Decompiled with CFR 0.152.
 */
package org.zeromq;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.zeromq.ZMQ;

public class ZLoop {
    private final List<SPoller> pollers = new ArrayList<SPoller>();
    private final List<STimer> timers = new ArrayList<STimer>();
    private int pollSize;
    private ZMQ.Poller pollset;
    private SPoller[] pollact;
    private boolean dirty;
    private boolean verbose;
    private final List<Object> zombies = new ArrayList<Object>();
    private final List<STimer> newTimers = new ArrayList<STimer>();

    public void destroy() {
    }

    private void rebuild() {
        this.pollact = null;
        this.pollSize = this.pollers.size();
        this.pollset = new ZMQ.Poller(this.pollSize);
        this.pollact = new SPoller[this.pollSize];
        int itemNbr = 0;
        for (SPoller poller : this.pollers) {
            this.pollset.register(poller.item);
            this.pollact[itemNbr] = poller;
            ++itemNbr;
        }
        this.dirty = false;
    }

    private long ticklessTimer() {
        long tickless = System.currentTimeMillis() + 3600000L;
        for (STimer timer : this.timers) {
            if (timer.when == -1L) {
                timer.when = (long)timer.delay + System.currentTimeMillis();
            }
            if (tickless <= timer.when) continue;
            tickless = timer.when;
        }
        long timeout = tickless - System.currentTimeMillis();
        if (timeout < 0L) {
            timeout = 0L;
        }
        if (this.verbose) {
            System.out.printf("I: zloop: polling for %d msec\n", timeout);
        }
        return timeout;
    }

    public int addPoller(ZMQ.PollItem item_, IZLoopHandler handler, Object arg) {
        ZMQ.PollItem item = item_;
        if (item.getRawSocket() == null && item.getSocket() == null) {
            return -1;
        }
        SPoller poller = new SPoller(item_, handler, arg);
        this.pollers.add(poller);
        this.dirty = true;
        if (this.verbose) {
            System.out.printf("I: zloop: register %s poller (%s, %s)\n", item.getSocket() != null ? Integer.valueOf(item.getSocket().getType()) : "RAW", item.getSocket(), item.getRawSocket());
        }
        return 0;
    }

    public void removePoller(ZMQ.PollItem item_) {
        ZMQ.PollItem item = item_;
        Iterator<SPoller> it = this.pollers.iterator();
        while (it.hasNext()) {
            SPoller p = it.next();
            if (!item.equals(p.item)) continue;
            it.remove();
            this.dirty = true;
        }
        if (this.verbose) {
            System.out.printf("I: zloop: cancel %s poller (%s, %s)", item.getSocket() != null ? Integer.valueOf(item.getSocket().getType()) : "RAW", item.getSocket(), item.getRawSocket());
        }
    }

    public int addTimer(int delay, int times, IZLoopHandler handler, Object arg) {
        STimer timer = new STimer(delay, times, handler, arg);
        this.newTimers.add(timer);
        if (this.verbose) {
            System.out.printf("I: zloop: register timer delay=%d times=%d\n", delay, times);
        }
        return 0;
    }

    public int removeTimer(Object arg) {
        assert (arg != null);
        this.zombies.add(arg);
        if (this.verbose) {
            System.out.printf("I: zloop: cancel timer\n", new Object[0]);
        }
        return 0;
    }

    public void verbose(boolean verbose) {
        this.verbose = verbose;
    }

    public int start() {
        int rc = 0;
        this.timers.addAll(this.newTimers);
        this.newTimers.clear();
        for (STimer timer : this.timers) {
            timer.when = (long)timer.delay + System.currentTimeMillis();
        }
        while (!Thread.currentThread().isInterrupted()) {
            long wait;
            if (this.dirty) {
                this.rebuild();
            }
            if ((rc = this.pollset.poll(wait = this.ticklessTimer())) == -1) {
                if (this.verbose) {
                    System.out.printf("I: zloop: interrupted (%d)\n", rc);
                }
                rc = 0;
                break;
            }
            Iterator<STimer> it = this.timers.iterator();
            while (it.hasNext()) {
                STimer timer = it.next();
                if (System.currentTimeMillis() < timer.when || timer.when == -1L) continue;
                if (this.verbose) {
                    System.out.println("I: zloop: call timer handler");
                }
                if ((rc = timer.handler.handle(this, null, timer.arg)) == -1) break;
                if (timer.times != 0 && --timer.times == 0) {
                    it.remove();
                    continue;
                }
                timer.when = (long)timer.delay + System.currentTimeMillis();
            }
            if (rc == -1) break;
            for (int itemNbr = 0; itemNbr < this.pollSize; ++itemNbr) {
                SPoller poller = this.pollact[itemNbr];
                if (this.pollset.getItem(itemNbr).isError()) {
                    if (this.verbose) {
                        System.out.printf("I: zloop: can't poll %s socket (%s, %s)\n", poller.item.getSocket() != null ? Integer.valueOf(poller.item.getSocket().getType()) : "RAW", poller.item.getSocket(), poller.item.getRawSocket());
                    }
                    if (poller.errors++ > 0) {
                        this.removePoller(poller.item);
                    }
                } else {
                    poller.errors = 0;
                }
                if (this.pollset.getItem(itemNbr).readyOps() <= 0) continue;
                if (this.verbose) {
                    System.out.printf("I: zloop: call %s socket handler (%s, %s)\n", poller.item.getSocket() != null ? Integer.valueOf(poller.item.getSocket().getType()) : "RAW", poller.item.getSocket(), poller.item.getRawSocket());
                }
                if ((rc = poller.handler.handle(this, poller.item, poller.arg)) == -1) break;
            }
            for (Object arg : this.zombies) {
                it = this.timers.iterator();
                while (it.hasNext()) {
                    STimer timer = it.next();
                    if (timer.arg != arg) continue;
                    it.remove();
                }
            }
            this.timers.addAll(this.newTimers);
            this.newTimers.clear();
            if (rc != -1) continue;
            break;
        }
        return rc;
    }

    private class STimer {
        int delay;
        int times;
        IZLoopHandler handler;
        Object arg;
        long when;

        public STimer(int delay, int times, IZLoopHandler handler, Object arg) {
            this.delay = delay;
            this.times = times;
            this.handler = handler;
            this.arg = arg;
            this.when = -1L;
        }
    }

    private class SPoller {
        ZMQ.PollItem item;
        IZLoopHandler handler;
        Object arg;
        int errors;

        protected SPoller(ZMQ.PollItem item, IZLoopHandler handler, Object arg) {
            this.item = item;
            this.handler = handler;
            this.arg = arg;
            this.errors = 0;
        }
    }

    public static interface IZLoopHandler {
        public int handle(ZLoop var1, ZMQ.PollItem var2, Object var3);
    }
}

