/*
 * Decompiled with CFR 0.152.
 */
package zmq;

import java.util.HashSet;
import java.util.Set;
import zmq.Pipe;
import zmq.Utils;

public class Mtrie {
    private Set<Pipe> pipes = null;
    private int min = 0;
    private int count = 0;
    private int live_nodes = 0;
    private Mtrie[] next = null;

    public boolean add(byte[] prefix_, Pipe pipe_) {
        return this.add_helper(prefix_, 0, pipe_);
    }

    public boolean add(byte[] prefix_, int start_, Pipe pipe_) {
        return this.add_helper(prefix_, start_, pipe_);
    }

    private boolean add_helper(byte[] prefix_, int start_, Pipe pipe_) {
        if (prefix_ == null || prefix_.length == start_) {
            boolean result;
            boolean bl = result = this.pipes == null;
            if (this.pipes == null) {
                this.pipes = new HashSet<Pipe>();
            }
            this.pipes.add(pipe_);
            return result;
        }
        int c = prefix_[start_];
        if (c < this.min || c >= this.min + this.count) {
            if (this.count == 0) {
                this.min = c;
                this.count = 1;
                this.next = null;
            } else if (this.count == 1) {
                int oldc = this.min;
                Mtrie oldp = this.next[0];
                this.count = (this.min < c ? c - this.min : this.min - c) + 1;
                this.next = new Mtrie[this.count];
                this.min = Math.min(this.min, c);
                this.next[oldc - this.min] = oldp;
            } else if (this.min < c) {
                this.count = c - this.min + 1;
                this.next = this.realloc(this.next, this.count, true);
            } else {
                this.count = this.min + this.count - c;
                this.next = this.realloc(this.next, this.count, false);
                this.min = c;
            }
        }
        if (this.count == 1) {
            if (this.next == null) {
                this.next = new Mtrie[1];
                this.next[0] = new Mtrie();
                ++this.live_nodes;
            }
            return this.next[0].add_helper(prefix_, start_ + 1, pipe_);
        }
        if (this.next[c - this.min] == null) {
            this.next[c - this.min] = new Mtrie();
            ++this.live_nodes;
        }
        return this.next[c - this.min].add_helper(prefix_, start_ + 1, pipe_);
    }

    private Mtrie[] realloc(Mtrie[] table, int size, boolean ended) {
        return Utils.realloc(Mtrie.class, table, size, ended);
    }

    public boolean rm(Pipe pipe_, IMtrieHandler func, Object arg) {
        return this.rm_helper(pipe_, new byte[0], 0, 0, func, arg);
    }

    private boolean rm_helper(Pipe pipe_, byte[] buff_, int buffsize_, int maxbuffsize_, IMtrieHandler func_, Object arg_) {
        if (this.pipes != null && this.pipes.remove(pipe_) && this.pipes.isEmpty()) {
            func_.invoke(null, buff_, buffsize_, arg_);
            this.pipes = null;
        }
        if (buffsize_ >= maxbuffsize_) {
            maxbuffsize_ = buffsize_ + 256;
            buff_ = Utils.realloc(buff_, maxbuffsize_);
        }
        if (this.count == 0) {
            return true;
        }
        if (this.count == 1) {
            buff_[buffsize_] = (byte)this.min;
            this.next[0].rm_helper(pipe_, buff_, ++buffsize_, maxbuffsize_, func_, arg_);
            if (this.next[0].is_redundant()) {
                this.next = null;
                this.count = 0;
                --this.live_nodes;
                assert (this.live_nodes == 0);
            }
            return true;
        }
        int new_min = this.min + this.count - 1;
        int new_max = this.min;
        for (int c = 0; c != this.count; ++c) {
            buff_[buffsize_] = (byte)(this.min + c);
            if (this.next[c] == null) continue;
            this.next[c].rm_helper(pipe_, buff_, buffsize_ + 1, maxbuffsize_, func_, arg_);
            if (this.next[c].is_redundant()) {
                this.next[c] = null;
                assert (this.live_nodes > 0);
                --this.live_nodes;
                continue;
            }
            if (c + this.min < new_min) {
                new_min = c + this.min;
            }
            if (c + this.min <= new_max) continue;
            new_max = c + this.min;
        }
        assert (this.count > 1);
        if (this.live_nodes == 0) {
            this.next = null;
            this.count = 0;
        } else if (this.live_nodes == 1) {
            assert (new_min == new_max);
            assert (new_min >= this.min && new_min < this.min + this.count);
            Mtrie node = this.next[new_min - this.min];
            assert (node != null);
            this.next = null;
            this.next = new Mtrie[]{node};
            this.count = 1;
            this.min = new_min;
        } else if (new_min > this.min || new_max < this.min + this.count - 1) {
            assert (new_max - new_min + 1 > 1);
            Mtrie[] old_table = this.next;
            assert (new_min > this.min || new_max < this.min + this.count - 1);
            assert (new_min >= this.min);
            assert (new_max <= this.min + this.count - 1);
            assert (new_max - new_min + 1 < this.count);
            this.count = new_max - new_min + 1;
            this.next = new Mtrie[this.count];
            System.arraycopy(old_table, new_min - this.min, this.next, 0, this.count);
            this.min = new_min;
        }
        return true;
    }

    public boolean rm(byte[] prefix_, int start_, Pipe pipe_) {
        return this.rm_helper(prefix_, start_, pipe_);
    }

    private boolean rm_helper(byte[] prefix_, int start_, Pipe pipe_) {
        Mtrie next_node;
        if (prefix_ == null || prefix_.length == start_) {
            if (this.pipes != null) {
                boolean erased = this.pipes.remove(pipe_);
                assert (erased);
                if (this.pipes.isEmpty()) {
                    this.pipes = null;
                }
            }
            return this.pipes == null;
        }
        byte c = prefix_[start_];
        if (this.count == 0 || c < this.min || c >= this.min + this.count) {
            return false;
        }
        Mtrie mtrie = next_node = this.count == 1 ? this.next[0] : this.next[c - this.min];
        if (next_node == null) {
            return false;
        }
        boolean ret = next_node.rm_helper(prefix_, start_ + 1, pipe_);
        if (next_node.is_redundant()) {
            assert (this.count > 0);
            if (this.count == 1) {
                this.next = null;
                this.count = 0;
                --this.live_nodes;
                assert (this.live_nodes == 0);
            } else {
                this.next[c - this.min] = null;
                assert (this.live_nodes > 1);
                --this.live_nodes;
                if (this.live_nodes == 1) {
                    int i;
                    for (i = 0; i < this.count && this.next[i] == null; ++i) {
                    }
                    assert (i < this.count);
                    this.min += i;
                    this.count = 1;
                    Mtrie old = this.next[i];
                    this.next = new Mtrie[]{old};
                } else if (c == this.min) {
                    int i;
                    for (i = 1; i < this.count && this.next[i] == null; ++i) {
                    }
                    assert (i < this.count);
                    this.min += i;
                    this.count -= i;
                    this.next = this.realloc(this.next, this.count, true);
                } else if (c == this.min + this.count - 1) {
                    int i;
                    for (i = 1; i < this.count && this.next[this.count - 1 - i] == null; ++i) {
                    }
                    assert (i < this.count);
                    this.count -= i;
                    this.next = this.realloc(this.next, this.count, false);
                }
            }
        }
        return ret;
    }

    public void match(byte[] data_, int size_, IMtrieHandler func_, Object arg_) {
        Mtrie current = this;
        int idx = 0;
        while (true) {
            if (current.pipes != null) {
                for (Pipe it : current.pipes) {
                    func_.invoke(it, null, 0, arg_);
                }
            }
            if (size_ == 0 || current.count == 0) break;
            byte c = data_[idx];
            if (current.count == 1) {
                if (c != current.min) break;
                current = current.next[0];
                ++idx;
                --size_;
                continue;
            }
            if (c < current.min || c >= current.min + current.count || current.next[c - current.min] == null) break;
            current = current.next[c - current.min];
            ++idx;
            --size_;
        }
    }

    private boolean is_redundant() {
        return this.pipes == null && this.live_nodes == 0;
    }

    public static interface IMtrieHandler {
        public void invoke(Pipe var1, byte[] var2, int var3, Object var4);
    }
}

