/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.copper.runtime.engines.semantics;

import edu.umn.cs.melt.copper.runtime.auxiliary.Pair;
import edu.umn.cs.melt.copper.runtime.io.Location;

public class VirtualLocation
implements Location {
    private static final long serialVersionUID = -4262577268165715268L;
    private boolean isModified = false;
    private String hash;
    protected int tabStop;
    protected int line;
    protected int column;
    protected String fileName;

    public VirtualLocation(String fileName, int line, int column) {
        this.tabStop = 8;
        this.fileName = fileName;
        this.line = line;
        this.column = column;
        this.generateHash();
    }

    public VirtualLocation(VirtualLocation original) {
        this.tabStop = original.tabStop;
        this.line = original.line;
        this.column = original.column;
        this.fileName = original.fileName;
        this.generateHash();
    }

    @Override
    public int getColumn() {
        return this.column;
    }

    public void setColumn(int column) {
        if (this.column != column) {
            this.isModified = true;
        }
        this.column = column;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        if (!this.fileName.equals(fileName)) {
            this.isModified = true;
        }
        this.fileName = fileName;
    }

    @Override
    public int getLine() {
        return this.line;
    }

    public void setLine(int line) {
        if (this.line != line) {
            this.isModified = true;
        }
        this.line = line;
    }

    @Override
    public long getPos() {
        return -1L;
    }

    public int getTabStop() {
        return this.tabStop;
    }

    public void setTabStop(int tabStop) {
        this.tabStop = tabStop;
    }

    public String getHash() {
        if (this.isModified) {
            this.generateHash();
        }
        return this.hash;
    }

    public boolean isModified() {
        return this.isModified;
    }

    private void defaultUpdate(String lexeme, boolean isAutomatic) {
        if (!isAutomatic) {
            this.isModified = true;
        } else if (this.isModified) {
            this.isModified = false;
            return;
        }
        Pair<Integer, Integer> nlCount = this.countNewlines(this.column, lexeme);
        this.line += nlCount.first().intValue();
        this.column = nlCount.second() == -1 ? (this.column += lexeme.length()) : nlCount.second();
        this.generateHash();
    }

    public void defaultUpdateAutomatic(String lexeme) {
        this.defaultUpdate(lexeme, true);
    }

    public void defaultUpdate(String lexeme) {
        this.defaultUpdate(lexeme, false);
    }

    private void generateHash() {
        this.hash = this.fileName + ":" + this.line + "." + this.column;
    }

    public String toString() {
        return this.getHash();
    }

    @Override
    public int compareTo(Location l) {
        int fileNameCompare = this.fileName.compareTo(l.getFileName());
        if (fileNameCompare != 0) {
            return fileNameCompare;
        }
        int lineCompare = Integer.signum(this.line - l.getLine());
        if (lineCompare != 0) {
            return lineCompare;
        }
        return Integer.signum(this.column - l.getColumn());
    }

    public Pair<Integer, Integer> countNewlines(int column, String lexeme) {
        if (lexeme.equals("")) {
            return Pair.cons(0, -1);
        }
        int startIndex = -1;
        int nlCount = -1;
        while (startIndex != 0) {
            ++nlCount;
            startIndex = lexeme.indexOf(10, startIndex) + 1;
        }
        int lastStartIndex = lexeme.lastIndexOf(10) + 1;
        int columnCount = lastStartIndex == 0 ? column : 0;
        startIndex = lexeme.indexOf(9, lastStartIndex);
        while (startIndex != -1) {
            columnCount += startIndex - lastStartIndex;
            columnCount += this.tabStop - columnCount % this.tabStop;
            lastStartIndex = startIndex + 1;
            startIndex = lexeme.indexOf(9, lastStartIndex);
        }
        return Pair.cons(nlCount, columnCount += lexeme.length() - lastStartIndex);
    }
}

