/*
 * Decompiled with CFR 0.152.
 */
package edu.umn.cs.melt.copper.runtime.io;

import edu.umn.cs.melt.copper.runtime.auxiliary.Pair;
import edu.umn.cs.melt.copper.runtime.io.InputPositionFull;
import edu.umn.cs.melt.copper.runtime.io.Location;
import org.xml.sax.Locator;

public abstract class InputPosition
implements Location {
    private static final long serialVersionUID = 2525774701288495668L;

    public abstract boolean isBefore(InputPosition var1);

    public abstract boolean isAfter(InputPosition var1);

    public abstract int diff(InputPosition var1);

    @Override
    public abstract int compareTo(Location var1);

    public abstract boolean equals(Object var1);

    @Override
    public abstract String getFileName();

    @Override
    public abstract int getLine();

    @Override
    public abstract int getColumn();

    @Override
    public abstract long getPos();

    public abstract int hashCode();

    public static InputPosition initialPos() {
        return new InputPositionFull();
    }

    public static InputPosition initialPos(String fileName) {
        return new InputPositionFull(InputPosition.initialPos(), fileName);
    }

    public static InputPosition fromSAXLocator(InputPosition pos, Locator locator) {
        return new InputPositionFull(pos, 0, Pair.cons(locator.getLineNumber() - pos.getLine(), locator.getColumnNumber()));
    }

    public static InputPosition copy(InputPosition i) {
        return i;
    }

    public static InputPosition advance(InputPosition curPos, char pastChar) {
        InputPositionFull rv = pastChar == '\n' ? new InputPositionFull(curPos, 1, Pair.cons(1, 0)) : new InputPositionFull(curPos, 1, Pair.cons(0, -1));
        return rv;
    }

    public static InputPosition advance(InputPosition curPos, int offset, String stringToPass) {
        return new InputPositionFull(curPos, offset, InputPosition.countNewlines(stringToPass));
    }

    public static Pair<Integer, Integer> countNewlines(String lexeme) {
        if (lexeme.equals("")) {
            return Pair.cons(0, -1);
        }
        int startIndex = -1;
        int nlCount = -1;
        while (startIndex != 0) {
            ++nlCount;
            startIndex = lexeme.indexOf(10, startIndex) + 1;
        }
        int pastNewline = lexeme.lastIndexOf(10) == -1 ? -1 : lexeme.length() - (lexeme.lastIndexOf(10) + 1);
        return Pair.cons(nlCount, pastNewline);
    }
}

