/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.ConsCell;
import common.DataNode;
import common.javainterop.ConsCellCollection;
import java.util.List;
import java.util.stream.Collectors;
import silver.core.Init;
import silver.core.NLocation;

public class CodeProberDiagnostic {
    private final String humanReadable;
    private final String diagnostic;

    private CodeProberDiagnostic(String humanReadable, String diagnostic) {
        this.humanReadable = humanReadable;
        this.diagnostic = diagnostic;
    }

    public String cpr_getOutput() {
        return this.humanReadable;
    }

    public String cpr_getDiagnostic() {
        return this.diagnostic;
    }

    public static CodeProberDiagnostic fromMessage(DataNode msg) {
        DataNode where = null;
        String output = null;
        String noLocOutput = null;
        int severity = -1;
        block12: for (int i = 0; i < msg.getNumberOfSynAttrs(); ++i) {
            switch (msg.getNameOfSynAttr(i)) {
                case "silver:langutil:where": {
                    where = (NLocation)msg.synthesized(i);
                    continue block12;
                }
                case "silver:langutil:output": {
                    output = msg.synthesized(i).toString();
                    continue block12;
                }
                case "silver:langutil:noLocOutput": {
                    noLocOutput = msg.synthesized(i).toString();
                    continue block12;
                }
                case "silver:langutil:severity": {
                    severity = (Integer)msg.synthesized(i);
                }
            }
        }
        int line = (Integer)where.synthesized(Init.silver_core_line__ON__silver_core_Location);
        int column = (Integer)where.synthesized(Init.silver_core_column__ON__silver_core_Location);
        int endLine = (Integer)where.synthesized(Init.silver_core_endLine__ON__silver_core_Location);
        int endColumn = (Integer)where.synthesized(Init.silver_core_endColumn__ON__silver_core_Location);
        String sevString = severity == 0 ? "INFO" : (severity == 1 ? "WARN" : (severity == 2 ? "ERR" : "HINT"));
        return new CodeProberDiagnostic(output, String.format("%s@%d;%d;%s", sevString, (line << 12) + column, (endLine << 12) + endColumn, noLocOutput));
    }

    public static List<CodeProberDiagnostic> fromMessageList(ConsCell msgs) {
        return new ConsCellCollection(msgs).stream().map(m -> CodeProberDiagnostic.fromMessage((DataNode)m)).collect(Collectors.toList());
    }
}

