/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.ConsCell;
import common.DecoratedNode;
import common.Node;
import common.OriginContext;
import common.StringCatter;
import common.Terminal;
import common.Tracked;
import common.Typed;
import common.exceptions.SilverInternalError;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import silver.core.NMaybe;
import silver.core.NOriginInfo;
import silver.core.Pjust;
import silver.core.Pnothing;
import silver.core.PoriginAndRedexOriginInfo;
import silver.core.PoriginOriginInfo;
import silver.core.PsetAtAccessOIT;
import silver.core.PsetAtConstructionOIT;
import silver.core.PsetAtForwardingOIT;
import silver.core.PsetAtNewOIT;
import silver.core.PsetFromEntryOIT;
import silver.core.PsetFromFFIOIT;
import silver.core.PsetFromParserActionOIT;
import silver.core.PsetFromParserOIT;
import silver.core.PsetFromReflectionOIT;
import silver.core.PsetFromReificationOIT;
import silver.core.PsetInGlobalOIT;

public final class OriginsUtil {
    public static PsetAtConstructionOIT SET_AT_CONSTRUCTION_OIT = new PsetAtConstructionOIT();
    public static PsetAtNewOIT SET_AT_NEW_OIT = new PsetAtNewOIT();
    public static PsetAtForwardingOIT SET_AT_FORWARDING_OIT = new PsetAtForwardingOIT();
    public static PsetAtAccessOIT SET_AT_ACCESS_OIT = new PsetAtAccessOIT();
    public static PsetFromParserOIT SET_FROM_PARSER_OIT = new PsetFromParserOIT();
    public static PsetFromParserActionOIT SET_FROM_PARSER_ACTION_OIT = new PsetFromParserActionOIT();
    public static PsetFromFFIOIT SET_FROM_FFI_OIT = new PsetFromFFIOIT();
    public static PsetFromReflectionOIT SET_FROM_REFLECTION_OIT = new PsetFromReflectionOIT();
    public static PsetFromReificationOIT SET_FROM_REIFICATION_OIT = new PsetFromReificationOIT();
    public static PsetFromEntryOIT SET_FROM_ENTRY_OIT = new PsetFromEntryOIT();
    public static PsetInGlobalOIT SET_IN_GLOBAL_OIT = new PsetInGlobalOIT();

    private static String ids(Object arg) {
        return Integer.toString(System.identityHashCode(arg));
    }

    private static String pySanitize(String arg) {
        return arg.replace("\\", "\\\\").replace("\"", "\\\"").replace("\n", "\\n");
    }

    private static String sexprifyObj(List<String> seen, Object arg) {
        String id;
        if (arg instanceof DecoratedNode) {
            arg = ((DecoratedNode)arg).getNode();
        }
        if (seen.contains(id = OriginsUtil.ids(arg))) {
            return "[" + id + "]";
        }
        seen.add(id);
        String r = "[" + id + ", ";
        if (arg instanceof Integer) {
            r = r + "'!Integer', " + arg.toString();
        } else if (arg instanceof Float) {
            r = r + "'!Float', " + arg.toString();
        } else if (arg instanceof Boolean) {
            r = r + "'!Boolean', " + arg.toString();
        } else if (arg instanceof StringCatter) {
            r = r + "'!String', \"" + OriginsUtil.pySanitize(arg.toString()) + "\"";
        } else if (arg instanceof Terminal) {
            Terminal t = (Terminal)arg;
            r = r + "'!Terminal', '" + OriginsUtil.pySanitize(t.getName()) + "', \"" + OriginsUtil.pySanitize(t.lexeme.toString()) + "\", " + OriginsUtil.sexprifyObj(seen, t.location);
        } else if (arg instanceof Node) {
            Node n = (Node)arg;
            r = r + "'" + OriginsUtil.pySanitize(n.getName()) + "', [";
            for (int i = 0; i < n.getNumberOfChildren(); ++i) {
                r = r + OriginsUtil.sexprifyObj(seen, n.getChild(i));
                if (i == n.getNumberOfChildren() - 1) continue;
                r = r + ",";
            }
            r = r + "],[";
            String[] annotationNames = n.getAnnoNames();
            for (int i = 0; i < annotationNames.length; ++i) {
                String name = annotationNames[i];
                Object value = n.getAnno(name);
                r = r + "('" + OriginsUtil.pySanitize(name) + "', " + OriginsUtil.sexprifyObj(seen, value) + ")";
                if (i == annotationNames.length - 1) continue;
                r = r + ",";
            }
            r = r + "],";
            r = r + OriginsUtil.sexprifyObj(seen, OriginsUtil.getOriginOrNull(n));
        } else if (arg instanceof ConsCell) {
            ConsCell cc = (ConsCell)arg;
            if (cc.nil()) {
                r = r + "'!List', []";
            } else {
                r = r + "'!List', [";
                while (!cc.nil()) {
                    r = r + OriginsUtil.sexprifyObj(seen, cc.head());
                    r = r + ",";
                    Typed next = cc.tail();
                    if (next instanceof DecoratedNode) {
                        next = ((DecoratedNode)next).getNode();
                    }
                    if (!(next instanceof ConsCell)) {
                        throw new SilverInternalError("ConsCell.tail() evaluated to not a ConsCell");
                    }
                    cc = next;
                }
                r = r + "]";
            }
        } else {
            r = arg == null ? r + "'!Null'" : r + "'???', \"" + OriginsUtil.pySanitize(arg.toString()) + "\"";
        }
        r = r + "]";
        return r;
    }

    public static StringCatter sexprify(Object arg) {
        ArrayList<String> seen = new ArrayList<String>();
        return new StringCatter(OriginsUtil.sexprifyObj(seen, arg));
    }

    public static NOriginInfo getOriginOrNull(Object arg) {
        if (arg instanceof Tracked) {
            return ((Tracked)arg).getOrigin();
        }
        return null;
    }

    public static NMaybe polyGetOrigin(Object o) {
        NOriginInfo r;
        if (o instanceof DecoratedNode) {
            o = ((DecoratedNode)o).getNode();
        }
        if ((r = OriginsUtil.getOriginOrNull(o)) == null) {
            return new Pnothing();
        }
        return new Pjust(r);
    }

    public static NMaybe getOriginLink(NOriginInfo o) {
        if (o instanceof PoriginOriginInfo) {
            return new Pjust(((PoriginOriginInfo)o).getChild_origin());
        }
        if (o instanceof PoriginAndRedexOriginInfo) {
            return new Pjust(((PoriginAndRedexOriginInfo)o).getChild_origin());
        }
        return new Pnothing();
    }

    public static <T> ArrayList<T> arrayListOfArray(T[] a) {
        ArrayList l = new ArrayList();
        Collections.addAll(l, a);
        return l;
    }

    public static Object duplicatePoly(Object x, OriginContext c) {
        if (x instanceof Tracked) {
            return ((Tracked)x).duplicate(c);
        }
        return x;
    }
}

